Unit CD_Play;

Interface

uses Objects, Drivers, Views, Menus, Dialogs, App, CD_Vars, CD_Unit,
     CRT;

Type

  TotPlayRec = Record
     Frames,
     Seconds,
     Minutes,
     Nada     : Byte;
  End;

  PPlayButton = ^TPlayButton;
  TPlayButton = object(TButton)
  end;

  PSongListBox  = ^TSongListBox;
  TSongListBox  = object(TListViewer)
    function GetText(Item : Integer; MaxLen : Integer): String; virtual;
    procedure Draw; virtual;
    procedure HandleEvent(var Event : TEvent); virtual;
  end;

  PPlayerWindow  = ^TPlayerWindow;
  TPlayerWindow = object(TWindow)
    procedure HandleEvent(var Event : TEvent); virtual;
    procedure Draw; virtual;
  end;

  PProgramDialog = ^TProgramDialog;
  TProgramDialog = object(TDialog)
    procedure HandleEvent(var Event : TEvent); virtual;
  end;

  PPlayerDialog = ^ TPlayerDialog;
  TPlayerDialog = object(TDialog)
    procedure HandleEvent(var Event : TEvent); virtual;
  end;

  PSongDialog = ^TSongDialog;
  TSongDialog = object(TDialog)
    procedure HandleEvent(var Event : TEvent); virtual;
  end;


  PTimeView = ^TTimeView;
  TTimeView = object(TView)
    LastTrack  : Byte;
    SongPlayTime,
    Min,
    Sec        : Word;
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
    procedure Update; virtual;
    procedure TotalTime;
  end;

  PStatButton = ^TStatButton;
  TStatButton = object(TView)
    OnOffCh : Char;
    OnOff   : Boolean;
    ChPos   : Byte;
    ShowStr : TDrawBuffer;
    procedure AssignStr(SStr : String; Ch : Char);
    procedure Update(Check : Boolean); virtual;
    procedure Draw; virtual;
  end;


Const
  cmShuffle    = 140;
  cmProgram    = 141;
  cmBackGround = 142;
  cmEject      = 143;
  cmShowInfo   = 144;
  cmDoPlayer   = 145;
  cmPlayCD     = 146;
  cmEditList   = 147;
  cmBegin      = 148;
  cmReset      = 149;
  cmBeep       = 150;
  cmPause      = 151;
  cmRepeat     = 152;
  cmFF         = 153;
  cmRV         = 154;
  cmDel        = 155;
  cmClear      = 156;
  cmMark       = 157;
  cmMove       = 158;
  MaxSongs     = 50;

  { cm201..cm251 are for individual tracks }

Var
  TrackInfo        : Array[1..99] of PAudioTrackInfo;
  PD               : PPlayerDialog;
  OD               : PProgramDialog;
  PlayClock        : PTimeView;
  RepeatButton,
  PauseButton,
  PlayButton       : PStatButton;
  RepeatLast       : Boolean;
  NextTrack,
  CurrentTrack,
  StartTrack,
  EndTrack         : Integer;

procedure ProgramBox;

procedure Song_List;

procedure NoTracks;

procedure Beep;

procedure Setup;

procedure SetupDebug;

procedure PlayBackground;

procedure ClearSongList;

procedure DelLastSong;

procedure AddPlay(Song : Integer);

procedure PlaySongs;

procedure Shuffle;

procedure Stop_Audio;

function LeadingZero(w: Word): String;


{***********************************************************************}

{***********************************************************************}

Implementation


{***********************************************************************}

{***********************************************************************}

Var
  SP, EP           : LongInt;
  LeadOut,
  StartP,
  TotalPlayTime    : LongInt;
  TotPlay          : TotPlayRec;
  Changed : Boolean;
  Marked,
  SongFocused,
  SongListMin,
  SongListSec      : Integer;
  SongList         : PCollection;
  CmdArray         : Array[1..50] of Byte;
  TimeStr1,
  TimeStr2,
  TimeStr3         : string[6];
  ListChanged,
  Programming      : Boolean;
  S                : PSongListBox;
  W                : PSongDialog;

procedure Beep;
begin
  Sound(440);
  Delay(20);
  NoSound;
end;

procedure NoTracks;
begin
  WriteLn;
  WriteLn('No tracks on disk');
  WriteLn;
end;

{***********************************************************************}

{***********************************************************************}

procedure Setup;
Var
  I     : Integer;
  A,B,C : LongInt;
  Track : Byte;
  EA    : Array[1..4] of Byte;
  EP    : LongInt;
Begin

  Audio_Disk_Info;
  Pause_Audio;
  If Paused THEN
     Begin
       Q_Channel_Info;
       CurrentTrack := QChannelInfo.Track;
     End;

  If (AudioDiskInfo.HighestTrack < 1) OR (NumberOfCD = 0) THEN
     SetUpDebug
  ELSE

  Begin

  TotalPlayTime := 0;
  LeadOut := AudioDiskInfo.LeadOutTrack;

  StartTrack := AudioDiskInfo.LowestTrack;
  EndTrack := AudioDiskInfo.HighestTrack;
  CurrentTrack := StartTrack;

  For I := StartTrack to EndTrack DO
      Begin
        Track := I;
        Audio_Track_Info(StartP, Track);
        New(TrackInfo[I]);
        FillChar(TrackInfo[I]^, SizeOf(TrackInfo[I]^), #0);
        TrackInfo[I]^.Track := I;
        TrackInfo[I]^.StartPoint := StartP;
        TrackInfo[I]^.TrackControl := Track;
      End;

  For I := StartTrack to EndTrack - 1 DO
      TrackInfo[I]^.EndPoint := TrackInfo[I+1]^.StartPoint;
  TrackInfo[EndTrack]^.EndPoint := LeadOut;

  For I := StartTrack to EndTrack DO
        Move(TrackInfo[I]^.EndPoint, TrackInfo[I]^.Frames, 4);

  TrackInfo[StartTrack]^.PlayMin := TrackInfo[StartTrack]^.Minutes;
  TrackInfo[StartTrack]^.PlaySec := TrackInfo[StartTrack]^.Seconds - 2;

  For I := StartTrack + 1 to EndTrack DO
      Begin
        EP := (TrackInfo[I]^.Minutes * 60) + TrackInfo[I]^.Seconds;
        SP := (TrackInfo[I-1]^.Minutes * 60) + TrackInfo[I-1]^.Seconds;
        EP := EP - SP;
        TrackInfo[I]^.PlayMin := EP DIV 60;
        TrackInfo[I]^.PlaySec := EP Mod 60;
      End;

  TotalPlayTime := AudioDiskInfo.LeadOutTrack - TrackInfo[StartTrack]^.StartPoint;
  Move(TotalPlayTime, TotPlay, 4);

  End;
end;

{***********************************************************************}

{***********************************************************************}

procedure TPlayerWindow.Draw;
Const TStr = '%03d:%02d';
      VStr = '%1d.%2d';
Var   FStr : String;
      Param: Array[1..2] of LongInt;
      I, J : Integer;
begin
  TWindow.Draw;
  FStr := 'CD ROM Audio Disk Player';
  I := Length(FStr);
  I := (Size.X - I) DIV 2;
  WriteStr(I, 1, FStr,3);
  FStr := 'Copyright 1991 by M. W. ARMSTRONG';
  I := Length(FStr);
  I := (Size.X - I) DIV 2;
  WriteStr(I, 2,FStr,3);
  WriteChar(1,3,#205,2,Size.X-2);
  J := (Size.X DIV 2) - 1;
  For I := 4 TO (Size.Y - 2) DO
      WriteChar(J, I, #186, 2, 1);
  WriteChar(J,3,#203, 2, 1);
  WriteStr(4,4,'CD ROM Drive Information:', 3);
  Param[1] := MSCDEX_Version.Major;
  Param[2] := MSCDEX_Version.Minor;
  FormatStr(FStr, VStr, Param);
  WriteStr(4,6,'MSCDEX Version '+FStr,6);
  Str(NumberOfCD, FStr);
  WriteStr(4,8,'Number of CD ROM Drives is: '+Fstr,6);
  WriteStr(4,9,'First CD Drive Letter is  : '+Chr(FirstCD+65),6);
  I := (Size.X DIV 2) + 2;
  WriteStr(I,4,'CD Audio Disk Information:', 3);
  WriteStr(I,6,'There are ' + LeadingZero(EndTrack) + ' Tracks on this disk',6);
  WriteStr(I,7,'Total Play time is:  '+LeadingZero(TotPlay.Minutes)+':'+LeadingZero(TotPlay.Seconds) ,6);
end;
{***********************************************************************}

{***********************************************************************}

procedure TPlayerWindow.HandleEvent(var Event : TEvent);
begin
  TWindow.HandleEvent(Event);
  If (Event.What = evKeyDown) THEN
    Begin
     Case Event.KeyCode of
          kbEsc,
          kbAltF3 : Close;
     End;
    End;
end;

{***********************************************************************}

{***********************************************************************}

procedure TSongListBox.Draw;
Const
    FStr = '%003d:%02d';
Var
    R : TRect;
    I : Integer;
    L     : PLabel;
begin
  SetRange(SongList^.Count);
  If OD <> Nil THEN
     Begin
       TopItem := Range - Size.Y;
       If TopItem < 0 THEN
          TopItem := 0;
       TListViewer.Draw;
     End;
End;

{***********************************************************************}

function TSongListBox.GetText(Item : Integer; MaxLen : Integer): String;
Const
  FStr = '%c%02d    %02d:%02d';
Var
  PStr   : String;
  MChar  : Char;
  Param  : Array[1..4] of LongInt;
  TI     : PAudioTrackInfo;
begin
  TI := PAudioTrackInfo(SongList^.At(Item));
  If Item = Marked THEN
     MChar := #27
  ELSE
     MChar := #32;
  Param[1] := Ord(MChar);
  Param[2] := TI^.Track;
  Param[3] := TI^.PlayMin;
  Param[4] := TI^.PlaySec;
  FormatStr(PStr, FStr, Param);
  GetText := PStr;
end;

{***********************************************************************}

{***********************************************************************}

procedure TSongListBox.HandleEvent(var Event : TEvent);
var
  SongPtr  : Pointer;
begin
  TListViewer.HandleEvent(Event);
  SongFocused := Focused;
  Case Event.What Of
       evKeyDown :
          Begin
            Changed := True;
            Case Event.KeyCode of

               kbDel    : SongList^.AtDelete(Focused);
               kbEnd    : SongList^.DeleteAll;
               kbAltM   : Marked := Focused;
               kbIns    : Begin
                          SongList^.AtInsert(Focused, SongList^.At(Marked));
                          If Focused > Marked THEN
                             SongList^.AtDelete(Marked)
                          ELSE
                             SongList^.AtDelete(Marked+1);
                          Marked := 0;
                          End;
               kbAltC   : Begin
                            Marked := 0;
                            Changed := False;
                          End;
               kbEsc    : Done;
               ELSE
                 Exit;
            End;
          End;
       evCommand :
          Begin
            Changed := True;
            Case Event.Command of
                 cmDel       : SongList^.AtDelete(Focused);
                 cmClear     : SongList^.DeleteAll;
               Else
                 Exit;
            End;
          End;
       ELSE
          Exit;
       End;
    ClearEvent(Event);
    Range := SongList^.Count;
end;

{***********************************************************************}

procedure TSongDialog.HandleEvent(var Event : TEvent);
var
  SongPtr  : Pointer;
begin
  TDialog.HandleEvent(Event);
  Case Event.What Of
       evCommand :
          Begin
            ListChanged := True;
            Changed := True;
            Case Event.Command of
                 cmDel       : SongList^.AtDelete(SongFocused);
                 cmClear     : SongList^.DeleteAll;
                 cmMark      : Marked := SongFocused;
                 cmMove      : Begin
                                 SongList^.AtInsert(SongFocused, SongList^.At(Marked));
                                 If SongFocused > Marked THEN
                                    SongList^.AtDelete(Marked)
                                 ELSE
                                    SongList^.AtDelete(Marked+1);
                                 Marked := 0;
                               End;
            End;
          End;
       ELSE
            Exit;
  End;
  S^.Draw;
  ClearEvent(Event);
end;

{***********************************************************************}

procedure TPlayerDialog.HandleEvent(var Event : TEvent);
  var I : Integer;
      NewPos : Integer;
      CurCmd : Word;
begin
  TDialog.HandleEvent(Event);
  CurCmd := PPlayButton(Current)^.Command;
  Case Event.What Of
       evCommand :
           case Event.Command of
                cmBeep     : Beep;
                cmPlayCD   : Begin
                               Stop_Audio;
                               If SongList^.Count = 0 THEN
                                  Begin
                                    Programming := True;
                                    NextTrack := 0;
                                    For I := StartTrack to EndTrack DO
                                      AddPlay(I);
                                  End;
                               NextTrack := 0;
                               Programming := False;
                               CurrentTrack := 0;
                               ListChanged := True;
                             end;
                StopPlay   : Begin
                               Stop_Audio;
                               Programming := TRUE; { while programming }
                             end;                   { will not play }

                ResumePlay : Resume_Play;
                cmFF       : Begin
                               If CurrentTrack = EndTrack THEN
                                  NextTrack := 0;
                               If Playing THEN
                                  Stop_Audio;
                             End;

                cmRV       : Begin
                               If Playing THEN
                                  Begin
                                    Stop_Audio;
                                    Inc(NextTrack, -2);
                                    If NextTrack < 0 THEN
                                       Inc(NextTrack);
                                    If NextTrack < 0 THEN
                                       NextTrack := EndTrack;
                                  End;
                             End;

                cmRepeat   : Begin
                               If NOT RepeatLast THEN
                                  Dec(NextTrack);
                               RepeatLast := NOT RepeatLast;
                             End;
                cmEject    : Begin
                               Eject;
                               Halt;
                             end;
                cmBackground : PlayBackground;
                cmShuffle    : Shuffle;
                cmPause      : Pause_Audio;
           ELSE
                Exit;
           End;
       evKeyDown :
           case Event.KeyCode of
                kbDown     : If CurCmd IN [cmEject, cmEditList, cmProgram] THEN
                                Current^.Prev^.Prev^.Prev^.Prev^.Select
                             ELSE
                                Current^.Prev^.Prev^.Prev^.Select;
                kbRight    : SelectNext(False);
                kbUp       : If CurCmd IN [cmFF, cmRV, cmPlayCD] THEN
                                Current^.Next^.Next^.Next^.Next^.Select
                             ELSE
                                Current^.Next^.Next^.Next^.Select;
                kbLeft     : SelectNext(True);
                kbTab      : DeskTop^.SelectNext(True);
           ELSE
                Exit;
           end;
       ELSE
       Exit;
  end;
  ClearEvent(Event);
end;

{***********************************************************************}

{***********************************************************************}

procedure TProgramDialog.HandleEvent(var Event : TEvent);
  var I : Integer;
      NewPos : Integer;

  procedure Rotate(Key : Word);
  Var
    EndList  : Boolean;
    CurCmd   : Word;
    I        : Integer;
  begin
    EndList := False;
    CurCmd := PButton(Current)^.Command;
    Case Key of
         kbUp    :  If (CurCmd <= CmdArray[5]) THEN
                      Current^.Next^.Next^.Next^.Next^.Next^.Next^.Next^.Select
                    ELSE
                      Current^.Next^.Next^.Next^.Next^.Next^.Select;
         kbDown  :  Begin
                      I := (EndTrack MOD 5);
                      If I = 0 THEN I := 5;
                      If (CurCmd > (CmdArray[EndTrack - I])) or (CurCmd = cmBeep) THEN
                         Current^.Prev^.Prev^.Prev^.Prev^.Prev^.Prev^.Prev^.Select
                      ELSE
                         Current^.Prev^.Prev^.Prev^.Prev^.Prev^.Select;
                    End;
    End;
  end;
begin
  Case Event.What Of
       evCommand :
           case Event.Command of
                201..251   : AddPlay(Event.Command - 200);
                cmBeep     : Beep;
           end;
       evKeyDown :
           case Event.KeyCode of
                kbRight    : SelectNext(False);
                kbDown,
                kbUp       : Rotate(Event.KeyCode);
                kbLeft     : SelectNext(True);
                kbDel      : ClearSongList;
                kbBack     : DelLastSong;
                kbTab      : DeskTop^.SelectNext(True);
                kbEsc      : Close;
           ELSE
                TDialog.HandleEvent(Event);
            End;
       ELSE
            TDialog.HandleEvent(Event);

  end;
  ClearEvent(Event);
  DrawView;
end;

{***********************************************************************}

procedure ClearSongList;
begin
  SongList^.DeleteAll;
  ListChanged := TRUE;
end;

{***********************************************************************}

procedure DelLastSong;
Begin
  SongList^.AtDelete(SongList^.Count-1);
  ListChanged := TRUE;
end;

{***********************************************************************}

procedure AddPlay(Song : Integer);
Var
  PStr   : String;
begin
  If SongList^.Count <=  MaxSongs THEN
     Begin
       Str(Song:2, PStr);
       SongList^.Insert(TrackInfo[Song]);
     end;
  ListChanged := TRUE;
end;

{***********************************************************************}

procedure PlaySongs;
Var
  I  : Integer;
  TI : PAudioTrackInfo;
begin
  If Not Programming THEN
  Begin
    If (SongList^.Count > 0) THEN
    Begin
      PlayClock^.UpDate;
      Audio_Status_Info;
      If (NOT Playing) AND (NOT Paused) THEN
       Begin
         Inc(NextTrack);
         If NextTrack < 0 THEN
            NextTrack := 1;
         If (NextTrack > SongList^.Count) THEN
            NextTrack := SongList^.Count
         ELSE
         Begin
           TI := PAudioTrackInfo(SongList^.At(NextTrack-1));
           CurrentTrack := TI^.Track;
           Play_Audio(TI^.StartPoint, TI^.EndPoint);
           RepeatLast := False;
         End;
       End;
    End;
  end;
End;

{***********************************************************************}

procedure Shuffle;
Var
  I, J     : Integer;
  TI       : PAudioTrackInfo;
  RArray   : Array[1..50] of Integer;
begin

  If (Playing OR Paused) THEN
     Exit;
  Programming := TRUE;
  FillChar(RArray, SizeOf(RArray), #0);
  SongList^.DeleteAll;
  NextTrack := 0;
  Randomize;
  I := StartTrack;
  Repeat
    RArray[I] := Random(EndTrack) + 1;
    For J := StartTrack to I-1 DO
        If RArray[J] = RArray[I] THEN
           RArray[I] := 0;
    If RArray[I] <> 0 THEN
       Inc(I);
  Until I > EndTrack;
  For I := StartTrack to EndTrack DO
      AddPlay(RArray[I]);
  CurrentTrack := 0;
  PlayClock^.UpDate;

  Programming := FALSE;
  ListChanged := True;
End;

{***********************************************************************}

procedure PlayBackground;
begin
  Play_Audio(TrackInfo[StartTrack]^.StartPoint, TrackInfo[EndTrack]^.EndPoint);
  Halt;
end;

{***********************************************************************}

procedure Stop_Audio;
begin
  Pause_Audio;
  Play_Audio(TrackInfo[EndTrack]^.EndPoint - 175,
             TrackInfo[EndTrack]^.EndPoint);
end;

{***********************************************************************}

procedure ProgramBox;
Var
  R: TRect;
  I,J,K:Integer;
  PStr : String;
  B: PPlayButton;
  C: Word;
  SB : PScrollBar;
  L : PLabel;
begin

  Programming := TRUE;
  R.Assign(12, 1, 69, 23);
  OD := New(PProgramDialog, Init(R, ''));
  { Create and insert controls into the program dialog}

  For I := StartTrack to EndTrack DO
    Begin
      J := ((I-1) Div 5)*2+1;

      K := I MOD 5;
      If K = 0 THEN K := 5;
      Dec(K);
      Str(I:2, PStr);

      R.Assign(K*6+1, J, (K*6)+5, J+2);
      B := New(PPlayButton, Init(R, PStr, CmdArray[I], bfNormal));
      OD^.Insert(B);
    End;

  { Fill program dialog controls for symmetry }

  If (EndTrack MOD 5) <> 0 THEN
  For I := ((Endtrack Mod 5)+1) To 5 DO
    Begin
      J := ((EndTrack-1) Div 5)*2+1;

      K := I MOD 5;
      If K = 0 THEN K := 5;
      Dec(K);

      R.Assign(K*6+1, J, (K*6)+5, J+2);
      B := New(PPlayButton, Init(R, 'X', cmBeep, bfNormal));
      OD^.Insert(B);
    End;
  OD^.SelectNext(False);
  OD^.SetState(sfShadow, FALSE);
  R.Assign(54, 3,55,20);
  SB := New(PScrollBar, Init(R));
  OD^.Insert(SB);
  R.Assign(37, 3,55,20);
  S := New(PSongListBox, Init(R, 1, Nil, SB));
  I := NextTrack-1;
  If I < 0 THEN
     I := 0;
  Marked := I;
  S^.SetRange(SongList^.Count);
  S^.FocusItem(I);
  S^.Options := ofFramed;
  S^.EventMask := 0;

  R.Assign(37,1,55,2);
  L := New(PLabel, Init(R, 'Total Time: '+ TimeStr2, Nil));
  OD^.Insert(L);


  OD^.Insert(S);
  OD^.SetState(sfShadow, FALSE);
  C := DeskTop^.ExecView(OD);
end;

{***********************************************************************}

procedure Song_List;
var
  C: Word;
  R: TRect;
  I,J,K:Integer;
  PStr : String;
  SB : PScrollBar;
  L : PLabel;

begin

  Programming := TRUE;
    {Set up Player window}

  R.Assign(43, 1, 69, 23);
  W := New(PSongDialog, Init(R, 'Song List'));
  R.Assign(16,2,17,21);
  SB := New(PScrollBar, Init(R));
  W^.Insert(SB);
  R.Assign(2,1,16,2);
  L := New(PLabel, Init(R, 'Track  Time', Nil));
  W^.Insert(L);
  R.Assign(2, 2, 16, 21);
  S := New(PSongListBox, Init(R, 1, Nil, SB));
  I := NextTrack-1;
  If I < 0 THEN
     I := 0;
  Marked := I;
  S^.SetRange(SongList^.Count);
  S^.FocusItem(I);
  W^.Insert(S);
  R.Assign(17,2,25,3);
  L := New(PLabel, Init(R, 'Total', Nil));
  W^.Insert(L);
  R.Assign(17,3,25,4);
  L := New(PLabel, Init(R, 'Time:', Nil));
  W^.Insert(L);
  W^.SetState(sfShadow, FALSE);
  R.Assign(17,6,25,8);
  W^.Insert(New(PPlayButton, Init(R, '~C~lear', cmClear, bfNormal)));
  R.Assign(17,9,25,11);
  W^.Insert(New(PPlayButton, Init(R, '~D~elete', cmDel, bfNormal)));
  R.Assign(17,12,25,14);
  W^.Insert(New(PPlayButton, Init(R, '~M~ark', cmMark, bfNormal)));
  R.Assign(17,15,25,17);
  W^.Insert(New(PPlayButton, Init(R, 'M~o~ve', cmMove, bfNormal)));
  R.Assign(17,18,25,20);
  W^.Insert(New(PPlayButton, Init(R, '~E~xit', cmCancel, bfNormal)));
  Changed := True;

  C := DeskTop^.ExecView(W);
  ListChanged := False;
end;

{-------- TimeView Object --------}

function LeadingZero(w: Word): String;
var s: String;
begin
  Str(w:0, s);
  LeadingZero := Copy('00', 1, 2 - Length(s)) + s;
end;

constructor TTimeView.Init(var Bounds: TRect);
begin
  TView.Init(Bounds);
  Min := $FF;
  Sec := $FF;
  LastTrack := $FF;
  TimeStr1 := '';
  TimeStr2 := '';
  TimeStr3 := '';
end;


procedure TTimeView.Draw;
Var
  PStr : String;
begin
  TView.Draw;
  Str(CurrentTrack:2, PStr);
  WriteStr( 1, 0, 'Track: ' + PStr +  '  Time: ' + TimeStr1 +
                  '  Remainder: ' + TimeStr2, 2);
end;


procedure TTimeView.Update;
Var
  OldSec : Word;
  PTime,
  LTime  : Word;
begin
  If (CurrentTrack <> LastTrack) OR ListChanged THEN
     TotalTime;
  If Playing THEN
     Begin
       OldSec := Sec;
       Q_Channel_Info;
       Min := QChannelInfo.Minutes;
       Sec := QChannelInfo.Seconds;
     End
  ELSE
     Begin
       OldSec := Sec;
       Min := 0;
       Sec := 0;
     End;
  If OldSec <> Sec THEN
     Begin
       LTime := (Min*60) + Sec;
       PTime := SongPlayTime - LTime;
       TimeStr1 := LeadingZero(PTime DIV 60) + ':' + LeadingZero(PTime MOD 60);
       DrawView;
     End;
end;

{***********************************************************************}

procedure TTimeView.TotalTime;
Var
  I : Integer;
Begin
    LastTrack := CurrentTrack;
    TimeStr3 := LeadingZero(TrackInfo[CurrentTrack]^.PlayMin) + ':' + LeadingZero(TrackInfo[CurrentTrack]^.PlaySec);
    SongListMin := 0;
    SongListSec := 0;
    If (SongList^.Count > 0) THEN
    For I := NextTrack To SongList^.Count-1 DO
      Begin
        SongListMin := SongListMin + PAudioTrackInfo(SongList^.At(I))^.PlayMin;
        SongListSec := SongListSec + PAudioTrackInfo(SongList^.At(I))^.PlaySec;
      End
    ELSE
      Begin
        SongListMin := TotPlay.Minutes;
        SongListSec := TotPlay.Seconds;
      End;
    SongListMin := SongListMin + (SongListSec DIV 60);
    SongListSec := SongListSec MOD 60;
    TimeStr2 := LeadingZero(SongListMin) + ':' + LeadingZero(SongListSec);
    SongPlayTime := (TrackInfo[CurrentTrack]^.PlayMin*60) + TrackInfo[CurrentTrack]^.PlaySec;
    ListChanged := False;
end;

{-------- StatButtonView Object --------}

{ TStatButton Bounds must be 2 longer than ShowStr length }
 
procedure TStatButton.Draw;
begin
  TView.Draw;
  WriteLine(0, 0, ChPos + 1, 1, ShowStr);
end;

{***********************************************************************}

procedure TStatButton.AssignStr(SStr : String; Ch : Char);
begin
  OnOffCh := Ch;
  ChPos := Length(SStr) + 1;
  MoveChar(ShowStr, ' ', ((LightGray SHL 4) + Black), SizeOf(ShowStr) DIV 2);

  MoveStr(ShowStr, SStr, ((LightGray SHL 4) + Black));
  If OnOff THEN
     MoveChar(ShowStr[ChPos], OnOffCh, ((LightGray SHL 4) + Green), 1)
  Else
     MoveChar(ShowStr[ChPos], OnOffCh, ((LightGray SHL 4) + Black), 1);
end;

{***********************************************************************}

procedure TStatButton.Update(Check : Boolean);
begin
If Check <> OnOff THEN
Begin
  If Check THEN
     MoveChar(ShowStr[ChPos], OnOffCh, ((LightGray SHL 4) + Green), 1)
  Else
     MoveChar(ShowStr[ChPos], OnOffCh, ((LightGray SHL 4) + Black), 1);
  OnOff := Check;
  DrawView;
End;
end;

{*************************************************************************}

procedure SetupDebug;
Var
  I     : Integer;
Begin
  TotalPlayTime := 0;

  StartTrack := 1;
  EndTrack := MaxSongs-3;

  For I := StartTrack to EndTrack DO
      Begin
        New(TrackInfo[I]);
        FillChar(TrackInfo[I]^, SizeOf(TrackInfo[I]^), #0);
        TrackInfo[I]^.Track := I;
        TrackInfo[I]^.StartPoint := I*1000 + 51;
        TrackInfo[I]^.TrackControl := 1;
      End;

  For I := StartTrack to EndTrack DO
      TrackInfo[I]^.EndPoint := TrackInfo[I]^.StartPoint + I*102;

  For I := StartTrack to EndTrack DO
        Move(TrackInfo[I]^.EndPoint, TrackInfo[I]^.Frames, 4);

  For I := StartTrack to EndTrack DO
      Begin
        EP := (TrackInfo[I]^.Minutes * 60) + TrackInfo[I]^.Seconds;
        TrackInfo[I]^.PlayMin := EP DIV 60;
        TrackInfo[I]^.PlaySec := EP Mod 60;
      End;

  TotalPlayTime := TrackInfo[EndTrack]^.StartPoint;
  Move(TotalPlayTime, TotPlay, 4);
end;

{***********************************************************************}

{*************************************************************************}

Var I : Integer;
begin
  New(SongList, Init(20,5));
  For I := 1 to 50 Do
      CmdArray[I] := 200 + I;
  Programming := FALSE;
  ListChanged := True;
  RepeatLast := False;
  SongListMin := 0;
  SongListSec := 0;
  NextTrack := 0;
END.
