program CDPlay;

uses Objects, Drivers, Views, Menus, Dialogs, App, CD_Vars, CD_Unit,
     CRT, CD_Play;

type
               
  PPlayerApp = ^TPlayerApp;
  TPlayerApp = object(TApplication)
    constructor Init;
    procedure Idle; virtual;
    procedure PlayerBox;
    procedure ShowInfo;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitStatusLine; virtual;
  end;

Var
  SaveExit : Pointer;
  OldMode    : Word;
{$F+}
procedure CleanUp;   { Exit procedure to retore screen }
Begin
  TextMode(OldMode);
  ClrScr;
  ExitProc := SaveExit;
end;
{$F-}

{ TPlayerApp }
procedure TPlayerApp.PlayerBox;
Const
  X1 = 5;
  X2 = X1 + 17;
  M = 20;
var
  C: Word;
  R: TRect;
  I,J,K:Integer;
  PStr : String;
  SB : PScrollBar;
  L : PLabel;
  PlayB:PPlayButton;
begin

  { Create play dialog }

  R.Assign(2, 2, 75, 20);
  PD := New(PPlayerDialog, Init(R, ''));

  { Create and insert controls into the play dialog}

  R.Assign(X1, 2, X2, 5);
  PD^.Insert(New(PPlayButton, Init(R, 'Forward ~>~>', cmFF, bfNormal)));

  R.Assign(X1+M, 2, X2+M, 5);
  PlayB := New(PPlayButton, Init(R, '~P~lay', cmPlayCD, bfDefault));
  PD^.Insert(PlayB);

  R.Assign(X1+M+M, 2, X2+M+M, 5);
  PD^.Insert(New(PPlayButton, Init(R, 'Reverse ~<~<', cmRV, bfNormal)));

  R.Assign(X1, 6, X2, 9);
  PD^.Insert(New(PPlayButton, Init(R, 'P~a~use', cmPause, bfNormal)));

  R.Assign(X1+M, 6, X2+M, 9);
  PD^.Insert(New(PPlayButton, Init(R, '~S~top', StopPlay, bfNormal)));

  R.Assign(X1+M+M, 6, X2+M+M, 9);
  PD^.Insert(New(PPlayButton, Init(R, '~R~esume', ResumePlay, bfNormal)));

  R.Assign(X1, 11, X2, 13);
  PD^.Insert(New(PPlayButton, Init(R, 'Shu~f~fle', cmShuffle, bfNormal)));

  R.Assign(X1+M, 11, X2+M, 13);
  PD^.Insert(New(PPlayButton, Init(R, '~B~ackground', cmBackground, bfNormal)));

  R.Assign(X1+M+M, 11, X2+M+M, 13);
  PD^.Insert(New(PPlayButton, Init(R, '~R~epeat', cmRepeat, bfNormal)));

  R.Assign(X1, 14, X2, 16);
  PD^.Insert(New(PPlayButton, Init(R, 'Pr~o~gram', cmProgram, bfNormal)));

  R.Assign(X1+M, 14, X2+M, 16);
  PD^.Insert(New(PPlayButton, Init(R, 'Edit ~L~ist', cmEditList, bfNormal)));

  R.Assign(X1+M+M, 14, X2+M+M, 16);
  PD^.Insert(New(PPlayButton, Init(R, '~E~ject', cmEject, bfNormal)));

  PD^.Flags := 0;

  PD^.SetState(sfShadow, FALSE);
  PlayB^.Select;

  DeskTop^.Insert(PD);



end;

procedure TPlayerApp.ShowInfo;
Var
  W : PPlayerWindow;
  R : TRect;
  C : Word;
begin

  R.Assign(2,2,78,22);
  W := New(PPlayerWindow, Init(R, 'CD Information', 1));
  DeskTop^.Insert(W);

end;

procedure TPlayerApp.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);

  if Event.What = evCommand then
  begin

    case Event.Command of
      cmBeep     : Beep;
      cmDoPlayer : PD^.Select;
      cmProgram  : ProgramBox;
      cmShowInfo : ShowInfo;
      cmEditList : Song_List;
      cmBegin    : PlayerBox;
    ELSE
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

constructor TPlayerApp.Init;
Var
  Event : TEvent;
  R : TRect;
begin
  TApplication.Init;
  Setup;
  Audio_Status_Info;
  R.Assign(3,0,11,1);
  PauseButton := New(PStatButton, Init(R));
  PauseButton^.OnOff := Paused;
  PauseButton^.AssignStr('Paused', #4);
  R.Assign(13,0,21,1);
  PlayButton := New(PStatButton, Init(R));
  PlayButton^.OnOff := Playing;
  PlayButton^.AssignStr('Play', #16);
  R.Assign(23,0,31,1);
  RepeatButton := New(PStatButton, Init(R));
  RepeatButton^.OnOff := RepeatLast;
  RepeatButton^.AssignStr('Repeat', #4);
  R.Assign(35, 0, 79, 1);
  PlayClock := New(PTimeView, Init(R));

  Insert(PauseButton);
  Insert(PlayButton);
  Insert(RepeatButton);
  Insert(PlayClock);

  Event.What := evCommand;
  Event.Command := cmBegin;
  PutEvent(Event);
end;

procedure TPlayerApp.InitStatusLine;

var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y-1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~Alt-I~ Show Info', kbAltI, cmShowInfo, nil))), nil)));

end;

procedure TPlayerApp.Idle;
begin
  TApplication.Idle;
  PlayClock^.UpDate;
  Audio_Status_Info;
  PauseButton^.Update(Paused);
  PlayButton^.Update(Playing);
  RepeatButton^.Update(RepeatLast);
  If NOT Playing Then
     PlaySongs;
end;

var
  CD_Player: TPlayerApp;
begin
  OldMode := LastMode;
  SaveExit := ExitProc;
  ExitProc := @CleanUp;

  CD_Player.Init;
  CD_Player.Run;
  CD_Player.Done;


end.
