program CDInfo;

Uses CD_Unit, CD_Vars, DOS, CRT;

Type
  TotPlayRec = Record
     Frames,
     Seconds,
     Minutes,
     Nada     : Byte;
  End;

Var
  SaveExit         : Pointer;
  TrackInfo        : Array[1..99] of PAudioTrackInfo;
  I                : Integer;
  Ch               : Char;
  SP, EP           : LongInt;
  LeadOut,
  StartP,
  TotalPlayTime    : LongInt;
  TotPlay          : TotPlayRec;
  Track            : Byte;
  StartTrack,
  EndTrack,
  NumTracks        : Integer;
  Player           : Array[1..100] of Byte;
  PlayTime         : TotPlayRec;


procedure NoTracks;
begin
  WriteLn;
  WriteLn('No tracks on disk');
  WriteLn;
  ExitProc := SaveExit;
end;

procedure Setup;
Begin
  TotalPlayTime := 0;
  LeadOut := AudioDiskInfo.LeadOutTrack;

  StartTrack := AudioDiskInfo.LowestTrack;
  EndTrack := AudioDiskInfo.HighestTrack;
  NumTracks := EndTrack - StartTrack + 1;


  For I := StartTrack to EndTrack DO
      Begin
        Track := I;
        Audio_Track_Info(StartP, Track);
        New(TrackInfo[I]);
        FillChar(TrackInfo[I]^, SizeOf(TrackInfo[I]^), #0);
        TrackInfo[I]^.StartPoint := StartP;
        TrackInfo[I]^.TrackControl := Track;
      End;

  For I := StartTrack to EndTrack - 1 DO
      TrackInfo[I]^.EndPoint := TrackInfo[I+1]^.StartPoint - 1;

  TrackInfo[EndTrack]^.EndPoint := AudioDiskInfo.LeadOutTrack - 1;

  For I := StartTrack to EndTrack DO
        Move(TrackInfo[I]^.EndPoint, TrackInfo[I]^.Frames, 4);

  TrackInfo[StartTrack]^.PlayMin := TrackInfo[StartTrack]^.Minutes;
  TrackInfo[StartTrack]^.PlaySec := TrackInfo[StartTrack]^.Seconds - 2;

  For I := StartTrack + 1 to EndTrack DO
      Begin
        EP := (TrackInfo[I]^.Minutes * 60) + TrackInfo[I]^.Seconds;
        SP := (TrackInfo[I-1]^.Minutes * 60) + TrackInfo[I-1]^.Seconds;
        EP := EP - SP;
        TrackInfo[I]^.PlayMin := EP DIV 60;
        TrackInfo[I]^.PlaySec := EP Mod 60;
      End;

  TotalPlayTime := AudioDiskInfo.LeadOutTrack - TrackInfo[StartTrack]^.StartPoint;
  Move(TotalPlayTime, TotPlay, 4);
end;

{*************************************************************************}

begin


  Audio_Disk_Info;

  If AudioDiskInfo.HighestTrack < 1 THEN
     Begin
       WriteLn('Not a Music CD');
       Exit;
     End
  ELSE
     Setup;

  ClrScr;


  For I := StartTrack to EndTrack DO
      Begin
        WriteLn('Track   : ', I);
        WriteLn('Minutes : ', TrackInfo[I]^.PlayMin);
        WriteLn('Seconds : ', TrackInfo[I]^.PlaySec);
        WriteLn;
        Ch := ReadKey;
      End;

  WriteLn('Total Minutes : ', TotPlay.Minutes);
  WriteLn('Total Seconds : ', TotPlay.Seconds);


  WriteLn;
  WriteLn('Press any key to continue....');
  Ch := ReadKey;



  SP := TrackInfo[1]^.StartPoint;
  EP := TrackInfo[1]^.EndPoint;
  Play_Audio(SP, EP);

end.