title    InitSpeed
; computes machine performance index
;        Michael Day
;        released to public domain by authors 
;        as of 22 April 1989

CODE     segment public 
         assume CS:CODE, DS:CODE
         public InitSpeed

; Outputs sound sample beginning at address Start, and continuing for
; Count bytes.

; function InitSpeed:word;
InitSpeed  proc  far  
         sti                ;insure ints are on
         push   DS          ;save DS 
         mov    AX,0040H    ;BIOS data segment 
         mov    DS,AX       ;into DS 
         mov    DI,6CH      ;offset for lsh of timer 
         mov    AL,[DI]     ;get lsb of timer 
         xor    CX,CX       ;initialize large count 
         xor    DX,DX       ;(longint version) 
         call   Subr        ;loop until timer changes 
         mov    AL,[DI]     ;get new timer value 
         xor    CX,CX       ;initialize large count 
         xor    DX,DX       ;(longint version) 
         call   Subr        ;call delay subr 
         pop    DS          ;restore DS 
         mov    AX,CX       ;count to lsh of dividnd 
         not    AX          ;AX=count for 55 msec 
         mov    CX,55       ;msec per timer tick 
         div    CX          ;compute count for 1 msec 
         ret                ;returns count in AX 
InitSpeed  endp


;-------------------------------------------------
; wait for tick count to happen
Subr:
         cmp    AL,[DI]     ;check if timer changed 
         jnz    SubEnd      ;quit after 1 timer tick 
         loop   subr        ;count and loop 
         inc    DX          ;overflow into dx
         cmp    DX,54       ;check if too far
         jb     subr        ;go for full count
SubEnd:
         ret                ;return from local subr 

CODE     ends  
         end


