program TestTheErrorFix;

(*

  This simple program shows the TP floating point location
  bug.  Note that the error address with the NDP present
  is 0418:360e (which is not valid), and with the NDP
  emulated is 0000:0066, which is the address of the FWAIT
  instruction following the erroneous instruction.
  The TP5FIX87 unit correctly reports the address when the
  NDP is present.  In both cases, the error name is also
  reported, and in both cases at least one address is correct.

15:25:11.93 C:\pascal>set 87=
15:25:11.93 C:\pascal>errortst
 Error 200 Division by zero at 0418:360e
  loaded at 3259, 87 IP=00064
  Runtime error 200 at 0418:360E.
15:25:15.11 C:\pascal>set 87=N
15:25:21.65 C:\pascal>errortst
 Error 200 Division by zero at 0000:0066
  loaded at 3259, 87 IP=dda70
  Runtime error 200 at 0000:0066.
*)


{$E+}
  uses TP5FIX87;

  var
    x,y,z: double;
  begin
    x:=2;
    y:=3;
    z:=(x+1)/(y-3);
end.