{$I- $F+}
Unit Errtrp;
Interface

uses
crt,
dos;

const
ScrSeg:word=$b800;
FGNorm=lightgray;
BGNorm=blue;
FGErr=white;
BGErr=red;

var
SaveInt24 :pointer;
ErrorRetry:boolean;
IOCode    :integer;
version   :integer;

procedure DisplayError(ErrNo:integer);
procedure RuntimeError;
procedure ErrTrap(ErrNo:integer);


Implementation


var
  ExitSave:pointer;
  regs:registers;


{$I crsrst.inc }
(**************************************************************************)

const
 INT59ERROR  : integer  = 0;
 ERRORACTION : byte = 0;
 ERRORTYPE   : byte =0;
 ERRORAREA   : byte =0;
 ERRORRESP   : byte =0;
 ERRORRESULT : integer=0;

type
errmsg         = array [0..89] of string;
ermsgPtr       =^errmsg;

var
Errs:ermsgPTR;

procedure box;
var
 i:integer;
begin
  textcolor(FGErr);
  textbackground(BGErr);
  gotoxy(1,1);
  writeln('  Critical Error  Ŀ');
    for i:=1 to 5 do
  writeln('                                                ');
  write  ('');
end;{box}

function DosVer:integer;
var
 Maj:shortint;
 Min:shortint;
 regs:registers;

begin
 regs.ah:=$30;
 MsDos(Regs);
 Maj:=regs.al;
 Min:=regs.ah;
 DosVer:=Maj;
end;

procedure InitErrs;
begin
new(Errs);
Errs^[0]:=   '             No error occured           ';
Errs^[1]:=    '          Invalid function number       ';
Errs^[2]:=    '              File not found            ';
Errs^[3]:=    '              Path not found            ';
Errs^[4]:=    '            No handle available         ';
Errs^[5]:=    '              Access denied             ';
Errs^[6]:=    '             Invalid handle             ';
Errs^[7]:=    '     Memory control blocks destroyed    ';
Errs^[8]:=    '           Insufficient memory          ';
Errs^[9]:=    '      Invalid memory block address      ';
Errs^[10]:=    '       Invalid SET command string       ';
Errs^[11]:=    '             Invalid format             ';
Errs^[12]:=    '          Invalid access code           ';
Errs^[13]:=    '              Invalid data              ';
Errs^[14]:=    '                Reserved                ';
Errs^[15]:=    '       Invalid drive specification      ';
Errs^[16]:=    '   Attempt to remove current directory  ';
Errs^[17]:=    '             Not same device            ';
Errs^[18]:=    '        No more files to be found       ';
Errs^[19]:=    '          Disk write protected          ';
Errs^[20]:=    '            Unknown unit ID             ';
Errs^[21]:=    '          Disk drive not ready          ';
Errs^[22]:=    '          Command not defined           ';
Errs^[23]:=    '            Disk data error             ';
Errs^[24]:=    '      Bad request structure length      ';
Errs^[25]:=    '             Disk seek error            ';
Errs^[26]:=    '         Unknown disk media type        ';
Errs^[27]:=    '          Disk sector not found         ';
Errs^[28]:=    '          Printer out of paper          ';
Errs^[29]:=    '      Write error - Printer Error?      ';
Errs^[30]:=    '               Read error               ';
Errs^[31]:=    '            General failure             ';
Errs^[32]:=    '         File sharing violation         ';
Errs^[33]:=    '         File locking violation         ';
Errs^[34]:=    '          Improper disk change          ';
Errs^[35]:=    '             No FCB available           ';
Errs^[36]:=    '         Sharing buffer overflow        ';
Errs^[37]:=    '                Reserved                ';
Errs^[38]:=    '                Reserved                ';
Errs^[39]:=    '                Reserved                ';
Errs^[40]:=    '                Reserved                ';
Errs^[41]:=    '                Reserved                ';
Errs^[42]:=    '                Reserved                ';
Errs^[43]:=    '                Reserved                ';
Errs^[44]:=    '                Reserved                ';
Errs^[45]:=    '                Reserved                ';
Errs^[46]:=    '                Reserved                ';
Errs^[47]:=    '                Reserved                ';
Errs^[48]:=    '                Reserved                ';
Errs^[49]:=    '                Reserved                ';
Errs^[50]:=    '      Network request not supported     ';
Errs^[51]:=    '      Remote computer not listening     ';
Errs^[52]:=    '        Duplicate name on network       ';
Errs^[53]:=    '         Network name not found         ';
Errs^[54]:=    '             Network busy               ';
Errs^[55]:=    '      Network device no longer exists   ';
Errs^[56]:=    '      NetBIOS command limit exceeded    ';
Errs^[57]:=    '      Network adapter hardware error    ';
Errs^[58]:=    '      Incorrect response from network   ';
Errs^[59]:=    '        Unexpected network error        ';
Errs^[60]:=    '      Incompatible remote adapter       ';
Errs^[61]:=    '            Print queue full            ';
Errs^[62]:=    '      Not enough space for print file   ';
Errs^[63]:=    '         Print file was deleted         ';
Errs^[64]:=    '        Network name was deleted        ';
Errs^[65]:=    '             Access denied              ';
Errs^[66]:=    '       Network device type incorrect    ';
Errs^[67]:=    '          Network name not found        ';
Errs^[68]:=    '        Network name limit exceeded     ';
Errs^[69]:=    '      NetBIOS session limit exceeded    ';
Errs^[70]:=    '           Temporarily paused           ';
Errs^[71]:=    '       Network request not accepted     ';
Errs^[72]:=    '  Print or disk re-direction is paused  ';
Errs^[73]:=    '                Reserved                ';
Errs^[74]:=    '                Reserved                ';
Errs^[75]:=    '                Reserved                ';
Errs^[76]:=    '                Reserved                ';
Errs^[77]:=    '                Reserved                ';
Errs^[78]:=    '                Reserved                ';
Errs^[79]:=    '                Reserved                ';
Errs^[80]:=    '           File already exists          ';
Errs^[81]:=    '                Reserved                ';
Errs^[82]:=    '              Cannot make               ';
Errs^[83]:=    '     Critical-error interrupt failure   ';
Errs^[84]:=    '          Too many redirections         ';
Errs^[85]:=    '          Duplicate redirection         ';
Errs^[86]:=    '           Duplicate password           ';
Errs^[87]:=    '            Invalid parameter           ';
Errs^[88]:=    '            Network data fault          ';
Errs^[89]:=    '             Undefined Error            ';
end;

procedure CritError(Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP:WORD);
 INTERRUPT;
type
ScrPtr         =^ScrBuff;
ScrBuff        =array [1..4096] of byte;

var
  Display,
  SaveScr    : ScrPtr;

  c         :char;
  ErrorPrompt,
  msg        :string;
  ErrNum     :byte;

  drive,
  area,
  al,ah      :byte;

  deviceattr :^word;
  devicename :^char;
  ch,
  i          :shortint;
  actmsg,
  tmsg,
  amsg,
  dname      :string;
begin
    ah:=hi(ax);
    al:=lo(ax);                            { in case DOS version < 3     }
    ErrNum:=lo(DI)+19;                     { save the error and add      }
    msg:=Errs^[ErrNum];                    { add 19 to convert to        }
                                           { standard DOS error          }
    tmsg:='';
    actmsg:='';                            { we can't suggest a response }

 if (ah and $80)=0 then                    { if a disk error then        }
   begin                                   { get the drive and area      }
     amsg:=' drive '+chr(al+65)+':';
     area:=(ah and 6) shr 1;
     case area of
     0:amsg:=amsg+' dos communications area ';
     1:amsg:=amsg+' disk directory area ';
     2:amsg:=amsg+' files area ';
     end;
   end
else                                       { else if a device error }
   begin                                   { get type of device     }
     deviceattr:=ptr(bp,si+4);
     i:=0;
     if (deviceattr^ and $8000)<>0 then     { if a character device }
       begin                                { like a printer        }
         amsg:='character device';
         ch:=0;
         repeat
         i:=i+1;
         devicename:=ptr(bp,si+$0a+ch);      { get the device name  }
         dname[i]:=devicename^;
         dname[0]:=chr(i);
         inc (ch);
         until (devicename^ = chr(0)) or (ch>7);
       end
    else                                     { else }
      begin                                  { just inform of the error }
        dname:='disk in '+chr(al)+':';
        msg:= ' general failure ' ;
        end;
     amsg:=amsg+' '+dname;
     end;

 inline($FA);                           { Enable interrupts       }
 Display:=ptr(ScrSeg,$0000);            { save the current screen }
 new(SaveScr);
 SaveScr^:=Display^;
 Window(15,10,65,16);                   { make a box to display the}
 textcolor(FGErr);                      { error message            }
 textbackground(BGErr);
 clrscr;
 box;

  if Version >=3 then                     { check the DOS version   }
  begin                                  { major component         }
  regs.ah:=$59;                          { and use DosExtErr since }
  regs.bx:=$00;                          { it is available         }
  MsDos(Regs);
  INT59ERROR:=regs.ax;
  ERRORTYPE:=regs.bh;
  ERRORACTION:=regs.bl;
  ERRORAREA:=regs.ch;
  msg:=Errs^[INT59ERROR];                { get the error information}
(*
  case ERRORAREA of
  1: amsg:='Unknown';
  2: amsg:='Block Device';               { usually disk access error}
  3: amsg:='Network Problem';
  4: amsg:='Serial Device';              { printer or COM problem   }
  5: amsg:='Memory';                     { corrupted memory         }
  end;
*)
  case ERRORTYPE of
  1 : tmsg:='Out of Resource';            { no channels, space       }
  2 : tmsg:='Temporary situation';        { file locked for instance;}
                                          { not an error and will    }
                                          { clear eventually         }
  3 :tmsg:='Authorization Violation';     { permission problem e.g.  }
                                          { write to read only file  }
  4 :tmsg:='Internal Software Error';     { system software bug      }
  5 :tmsg:='Hardware Error';              { serious trouble -- fix   }
                                          { the machine              }
  6 :tmsg:='System Error';                { serious trouble software }
                                          { at fault -- e.g. missing }
                                          { CONFIG file              }
  7 :tmsg:='Program Error';               { inconsistent request     }
                                          { from your program        }
  8 :tmsg:='Not found';                   { as stated                }
  9 :tmsg:='Bad Format';                  { as stated                }
  10:tmsg:='Locked';                      { interlock situation      }
  11:tmsg:='Media Error';                 { CRC error, wrong disk in }
                                          { drive, bad disk cluster  }
  12:tmsg:='Exists';                      { collision with existing  }
                                          { item, e.g. duplicate     }
                                          { device name              }
  13:tmsg:='Unknown Error';
  end;

  case ERRORACTION of
  1: actmsg:='Retry';                     { retry a few times then   }
                                          { give user abort option   }
                                          { if not fixed             }
  2: actmsg:='Delay Retry';               { pause, retry, then give  }
                                          { user abort option        }
  3: actmsg:='User Action';               { ask user to reenter item }
                                          { e.g. bad drive letter or }
                                          { filename used            }
  4:actmsg:='Abort';                      { invoke an orderly shut   }
                                          { down -- close files, etc }
  5:actmsg:='Immediate Exit';             { don't clean up, you may  }
                                          { really screw something up}
  6: actmsg:='Ignore';
  7: actmsg:='Retry';                     { after user intervention: }
  end;                                    { let the user fix it first}

  end;
amsg:=tmsg+amsg;
actmsg:='Suggested Action: '+actmsg;

gotoxy((54-length(msg)) div 2,3);
write(msg);

gotoxy((54-length(amsg)) div 2,4);
write(amsg);

gotoxy((54-length(actmsg)) div 2,6);
write(actmsg);
                                          { display it              }

ErrorPrompt:=' I)gnore R)etry A)bort F)ail ? ';
gotoxy((54-length(ErrorPrompt))div 2,5);
write(ErrorPrompt);
repeat                                     { get the user response  }
c:=readkey;
c:=upcase(c);
until c in ['A','R','I','F'];
Window(1,1,80,25);                         { restore the screen     }
textcolor(FGNorm);
textbackground(BGNorm);
Display^:=SaveScr^;
dispose(SaveScr);
case c of
  'I':begin
        AX:=0;
        ERRORRETRY:=false;
      end;
  'R':begin
        AX:=1;
        ERRORRETRY:=true;
      end;
  'A':begin
        Ax:=2;
        ERRORRETRY:=false;
        cursor(true);
      end;
  'F':begin
        Ax:=3;
        ERRORRETRY:=false;
        cursor(true);
      end;
end;

end;{procedure CritError}

(**************************************************************************)
procedure DisplayError(ErrNo:integer);
var
msg,
exitmsg:string;
begin
    case ErrNo of
    2:exitmsg:='File not found';
    3:exitmsg:='Path not found';
    4:exitmsg:='Too many open files';
    5:exitmsg:='Access denied';
    6:exitmsg:='Invalid file handle';
    12:exitmsg:='Invalid file access code';
    15:exitmsg:='Invalid drive';
    16:exitmsg:='Cannot remove current directory';
    17:exitmsg:='Cannot rename across drives';
    100:exitmsg:='Disk read error';
    101:exitmsg:='Disk write error - Disk Full ?';
    102:exitmsg:='File not assigned';
    103:exitmsg:='File not opened';
    104:exitmsg:='File not open for input';
    105:exitmsg:='File not open for output';
    106:exitmsg:='Invalid numeric format';
    150:exitmsg:='Disk is write protected';
    151:exitmsg:='Unknown unit';
    152:exitmsg:='Drive not ready';
    153:exitmsg:='Unkown command';
    154:exitmsg:='CRC error in data';
    155:exitmsg:='Bad drive request structure length';
    156:exitmsg:='Disk seek error';
    157:exitmsg:='Unknown media type';
    158:exitmsg:='Sector not found';
    159:exitmsg:='Printer out of paper';
    160:exitmsg:='Device write fault';
    161:exitmsg:='Device read fault';
    162:exitmsg:='Hardware failure';
    200:exitmsg:='Division by zero';
    201:exitmsg:='Range check error';
    202:exitmsg:='Stack overflow';
    203:exitmsg:='Heap overflow';
    204:exitmsg:='Invalid pointer operation';
    205:exitmsg:='Floating point overflow';
    206:exitmsg:='Floating point underflow';
    207:exitmsg:='Invalid floating point operation'
    else exitmsg:='Unknown Error # ';
    end;

  msg:=exitmsg;

  textcolor(FGErr);
  textbackground(BGErr);
  gotoxy((50-length(msg)) div 2,3);
  write(msg);

end;
procedure ErrTrap(ErrNo:integer);
type
ScrPtr         =^ScrBuff;
ScrBuff        =array [1..4096] of byte;

var
  Display,
  SaveScr    : ScrPtr;

  c         :char;
  ErrorPrompt,
  msg:string;

begin

 Display:=ptr(ScrSeg,$0000);            { save the current screen }
 new(SaveScr);
 SaveScr^:=Display^;
 Window(15,10,65,16);                   { make a box to display the}
 textcolor(FGErr);                      { error message            }
 textbackground(BGErr);
 clrscr;
 box;

  ErrorRetry:=true;
  DisplayError(ErrNo);

                                          { display it              }

ErrorPrompt:=' I)gnore R)etry A)bort F)ail ? ';
gotoxy((54-length(ErrorPrompt))div 2,5);
write(ErrorPrompt);
repeat                                     { get the user response  }
c:=readkey;
c:=upcase(c);
until c in ['A','R','I','F'];
case c of
  'I':ErrorRetry:=false;
  'R':ErrorRetry:=true;
  'A':begin
        ErrorRetry:=false;
        cursor(true);
      end;
  'F':begin
        ErrorRetry:=false;
        cursor(true);
      end;
  end;
  if ErrorRetry=false then
    begin
      gotoxy(4,4);
      write('If you are unable to correct the error');
      gotoxy(4,5);
      write('please report the error ',#40,Errno,#41,' and      ');
      gotoxy(4,6);
      write('exact circumstances when it occurred to us.');
      Window(1,1,80,25);                         { restore the screen     }
      textcolor(FGNorm);
      textbackground(BGNorm);
      Display^:=SaveScr^;
      dispose(SaveScr);

      ErrorAddr:=nil;
      gotoxy(1,1);
      cursor(true);
      halt;
    end;
Window(1,1,80,25);                         { restore the screen     }
textcolor(FGNorm);
textbackground(BGNorm);
Display^:=SaveScr^;
dispose(SaveScr);

end;

procedure RuntimeError;

type
ScrPtr         =^ScrBuff;
ScrBuff        =array [1..4096] of byte;

var
  Display,
  SaveScr    : ScrPtr;

  c         :char;
  ErrorPrompt,
  msg:string;

begin
  if ErrorAddr<>nil then
    begin
      Display:=ptr(ScrSeg,$0000);            { save the current screen }
      new(SaveScr);
      SaveScr^:=Display^;
      Window(15,10,65,16);                   { make a box to display the}
      textcolor(FGErr);                      { error message            }
      textbackground(BGErr);
      clrscr;
      box;
      gotoxy(15,1);
      write('   Fatal  Error   ');
      DisplayError(ExitCode);
      gotoxy(20,2);
      write('Run time error ',ExitCode);
      gotoxy(4,4);
      write('If you are unable to correct the error');
      gotoxy(4,5);
      write('Please report the error and exact');
      gotoxy(4,6);
      write('circumstances when it occurred to us.');
      gotoxy(4,7);
      write( ' Press a key to continue ');
      ErrorAddr:=nil;

      ExitProc:=ExitSave;
      c:=readkey;
    end;
  Window(1,1,80,25);                         { restore the screen     }
  textcolor(FGNorm);
  textbackground(BGNorm);
  Display^:=SaveScr^;
  dispose(SaveScr);

  cursor(true);
  textcolor(lightgray);
  textbackground(black);

  SetIntVec($24,SaveInt24);
end;
(**************************************************************************)
begin
  InitErrs;
  Version:=DosVer;
  cursor(false);
  GetIntVec($24,SaveInt24);
  SetIntVec($24,@CritError);
  ExitSave:=ExitProc;
  ExitProc:=@RuntimeError;
end.