Program tmWindowTest;

uses
  opcrt,
  opColor,
  opWindow,
  opString,
  tmWindow,
  tmApps;

{--------------------------------------------------------------------------}
procedure testMsgWindow;
var
  win : msgWindow;
  win2,win3 : stackWindow;
begin
  clrScr;

  writeln(memavail);

  if not win.init(5,5,20,23,'Test') then
    halt;


  win.draw;

  write(win.window^,'Hello World');
  writeln(win.window^,' Test');
  writeln(win.window^,'Goodbye.');
  writeln(win.window^,'123456789012345');
  writeln(win.window^,'1234567890123456');
  writeln(win.win,'12345678901234567890');
  writeln(win.window^,'12345');
  writeln(win.win,25,' ',^A,'bottles',^B,' of',^A,' bear',^A^C,' on',^C,' the',^B,' wall ',^A,25-1,' bottles of beer...');


  repeat until keypressed;

  win.done;

  wStack.done;          {restore global stack memory p.4-116}
  writeln(memavail);
end;
{--------------------------------------------------------------------------}
procedure testButton;
var
  b1,b2 : button;
  k,e : word;
begin
  clrScr;

  b1.init(5,5,'Te^St');
  b2.init(5,10,'Test2');

  b1.process;
  k := b1.getLastCommand;
  e := b1.getLastError;

  b2.process;


  b1.select;
  b1.done;

  b2.select;
  b2.done;

  writeln('B1 status = ',k,' ',e);
end;
{--------------------------------------------------------------------------}
procedure testScrollingWin;
  var
    sw : scrollingMsgWindow;
    i,j  : integer;
    s    : string;
    m1,m2 : longint;
  begin
    clrScr;

    m1 := memavail;

    if not sw.init(2,2,screenWidth-3,screenHeight-3,160,50,'Scrolling Window') then
      halt;

    sw.activate;

    for i := 1 to sw.height do
      begin
        s := '';
        j := i;
        while length(s) < 140 do
          begin
            s := s + long2str(j);
            inc(j);
          end;

        fastWrite(s,i,1,yellowOnBlue);
      end;

    sw.deactivate;

    sw.process;

    sw.clear;
    writeln(sw.window^,'This is a test of window writing');
    writeln(sw.window^,^C,'This ',^B,'is another ',^B,'test!',^C);

    sw.process;

    sw.done;
    wStack.done;

    m2 := memavail;
    writeln('memory ',m1,' ',m2,' ',m1-m2);
    waitkey;
  end;
{--------------------------------------------------------------------------}
begin
 testScrollingWin;

 testMsgWindow;
 testButton;

end.