{--------------------------------------------------------------------------}
Unit tmApps;

{
 (C) Tim Mackinnon	 06-JUL-90
 Cad Graphic Design Ltd.
 206 Guigues Ave.
 Ottawa On.
 K1N 5J2

 613 233-7246

 Compuserve [72230,3101]
}

{..........................................................................}
{Object professional code segments which are useful}
{..........................................................................}

interface

uses
  opCmd,
  opWindow;

const
  SpecialExitCommands : ByteSet = [
    ccTab, ccBackTab, ccNextField, ccWordLeft, ccWordRight, ccPrevField,
    ccNextRec, ccPrevRec, ccFirstFld, ccLastFld, ccNested, ccDone,
    ccQuit,ccMouseSel];


procedure enableMouse;
procedure waitkey;
procedure abstract;

procedure currentWinCoords(VAR x1,y1,x2,y2 : byte);

function booleanStr(trueStr,falseStr : string; bool : boolean) : string;
function Extend(S : String; Len : Byte) : String;


{--------------------------------------------------------------------------}
implementation
{--------------------------------------------------------------------------}

uses
  opCrt,
  opString,
  opMouse;

{--------------------------------------------------------------------------}
{Enable the mouse in object professional. }

procedure enableMouse;
  begin
    if mouseInstalled then begin
      with defaultColorSet do
        softMouseCursor($0000,(colorMono(mouseColor,mouseMono) shl 8) + $04);
    end;
  end;
{--------------------------------------------------------------------------}
{Find the x,y coordinates of the current window. }

procedure currentWinCoords;
  begin
    if wStack.topWindow <> nil then
      wStack.topWindow^.coordinates(x1,y1,x2,y2)
    else
      begin
        x1 := 1; y1 := 1;    {adjust this as windows have to start at 1,1 in opro}
        x2 := screenWidth;
        y2 := screenHeight;
      end;
  end;
{--------------------------------------------------------------------------}
procedure waitkey;
  var
    ch : char;
  begin
    ch := readkey;
  end;
{--------------------------------------------------------------------------}
{Return the true string if true etc. }

function booleanStr;
  begin
    if bool then
      booleanStr := trueStr
    else
      booleanStr := falseStr;
  end;
{--------------------------------------------------------------------------}
{-Pad or truncate string to specified length.  Good for databases. Taken
 from Turbo Power fbdmain.in1}

function Extend(S : String; Len : Byte) : String;

var
  SLen : Byte absolute S;
begin
  if SLen >= Len then begin
    SLen := Len;
    Extend := S;
  end
  else
    Extend := Pad(S, Len);
end;
{--------------------------------------------------------------------------}
{Generate a runtime error if abstract method not overridden}

procedure abstract;
  begin
    runError(211);   {signal an abstract error}
  end;

{--------------------------------------------------------------------------}
end.