{--------------------------------------------------------------------------}
{This unit adds some missing string functions to those provided in
 opString}

unit tmString;

interface

uses
  opRoot;

  function OnlyNumeric (s : string) : string;
  function OnlyDecimalNumeric (s : string) : string;

  function trimAllWhite(s : string) : string;
  function trimAllSpaces(s : string) : string;

{-------------------------------------------------------------------------}
implementation

uses
  opString,
  opDate;
{-------------------------------------------------------------------------}

{-------------------------------------------------------------------------}
{take out any hyphens etc. }

function OnlyNumeric;
 var
   i : integer;
   p : string;
 begin
   p := '';

   for i := 1 to length(s) do
     if s[i] in ['0'..'9'] then
       p := p + s[i];

   OnlyNumeric := p;
 end;
{-------------------------------------------------------------------------}
{take out any hyphens etc. but leave in period }

function OnlyDecimalNumeric;
 var
   i : integer;
   p : string;
 begin
   p := '';

   for i := 1 to length(s) do
     if s[i] in ['0'..'9','.'] then
       p := p + s[i];

   OnlyDecimalNumeric := p;
 end;
{-------------------------------------------------------------------------}
{take out any hyphens etc. for entire string}

function trimAllWhite;
 var
   i : integer;
   p : string;
 begin
   p := '';

   for i := 1 to length(s) do
     if (s[i] in ['0'..'9','A'..'Z','a'..'z']) then
       p := p + s[i];

   trimAllWhite := p;
 end;
{-------------------------------------------------------------------------}
{take out any spaces for entire string. }

function trimAllSpaces;
 var
   i : integer;
   p : string;
 begin
   p := '';

   for i := 1 to length(s) do
     if not(s[i] in [' ']) then
       p := p + s[i];

   trimAllSpaces := p;
 end;
{-------------------------------------------------------------------------}
end.
