{$A+,B-,D+,E+,F-,G+,I-,L+,N-,O-,R-,S-,V-,X+}
{$M 16384,0,4096}
Program Test_Timer;

USES tmsTimer, CRT;
CONST Symbol: Array[0..3] of Char= ('\','|','/','-');

VAR T     : tTimer;
    dT    : LongInt;
    Done  : Boolean;
    I	  : LongInt;
BEGIN
I:= 0;
T.Init(100);  { 10 ms }
Writeln('Started at: ',TmsStr(T.TofSet));

Done:= False;
  Repeat
  dT:= T.Interval;
  IF T.TimeOut THEN Inc(I); { Exercise some of timer routines }
  Write('Delay     ',Symbol[I Mod 4],'  ',dT:12,#13);

  { When reading the timer chip the interupts must be disabled to
    freez read the Bios Tics. There is a tricky case of the timer
    wraping arround from 0 to $FFFF during this peroid which if
    not accounted for results in time apperaing to go backwards by
    1 timer tic= 55ms. This has the catostofic side efferct of 24H
    time differance miscalculations!
    By checking for a huge dT this special case can be trapped.
    If the timer routines correct this problem correctly the error
    should never occur. Run test overnight on a 486 wich will have
    many encounters of this special case. The loop shouldn't halt. }

  IF (dT>$FFFF) THEN Done:=True
  UNTIL Done or KeyPressed;

IF Done
  THEN BEGIN
  Sound(400);
  Delay(500);
  NoSound;
  Write(#13,#10,'Neg Delay =  ',dT-864000000:12,#13);
  END
  ELSE Readkey;
Writeln;
Writeln('End after : ',TmsStr(TmsTime));
Writeln('Time spend: ',TmsStr(T.Time));
Writeln('Cycles    : ',I);
END.
