{$S-,R-,V-,I-,B-,F-}

{$IFDEF Ver40}
  {$F-}
{$ELSE}
{$F+}
{$O-}
{$ENDIF}

{$IFDEF Debug}
  {$D+}
{$ENDIF}

{Conditional defines that may affect this unit}
{$I TPDEFINE.INC}

{*********************************************************}
{*                  TPPDMOUS.PAS 5.06                    *}
{*          Copyright (c) Ken Henderson 1989, 1990.      *}
{*                                                       *}
{*                                                       *}
{*                                                       *}
{*********************************************************}

unit TpPdMous;
  {-Mouse support for TpPdMenu.}


interface

uses
  TpCrt,                          {Turbo Professional CRT unit}
  Dos,                            {DOS interface - standard unit}
  TpMouse,                        {Turbo Professional mouse routines}
  TpInline;

var
  MouseWasMoved            : Boolean;
  SaveInt33                : Pointer;
  CmdStringWord            : Word;
  MouseWasX, MouseWasY, MouseIsX, MouseIsY, MouseSenX, MouseSenY, SlowMouseSenX, SlowMouseSenY : Byte;

const
  MStatus                  : ButtonStatus = NoButton;

procedure AllPurposeEventHandler;
  {-Event handler}

procedure InitMouseSettings;
  {-Reinitializes mouse and sets MouseInstalled}

  {==========================================================================}

implementation

var
  MousePosX, MousePosY     : Byte;
  Ch                       : Char;

  procedure AllPurposeEventHandler;
  begin
    MouseWasX := MouseIsX;
    MouseWasY := MouseIsY;
    MouseWhereXY(MouseIsX, MouseIsY, MStatus);
    if MouseIsY > MouseWasY then StuffKey($5000);
    if MouseIsY < MouseWasY then StuffKey($4800);
    if MouseIsX > MouseWasX then StuffKey($4D00);
    if MouseIsX < MouseWasX then StuffKey($4B00);
    if MStatus <> NoButton then
    begin
      case MStatus of
        LeftButton :
        begin {Left button}
                       StuffKey($000D); {Insert <Enter>}
                     end;
        RightButton :
        begin {Right button}
                        StuffKey($001B); {Insert <Esc>}
                      end;
        BothButtons..All3Buttons :
          begin                   {Insert <F1>}
            StuffKey($3B00);
          end;
      end;
    end;
    if (MouseIsX = Succ(MouseXLo)) or (MouseIsX = MouseXHi) or
    (MouseIsY = Succ(MouseYLo)) or (MouseIsY = MouseYHi) then
    begin
      MouseWasX := 40;
      MouseWasY := 12;
      MouseIsX := MouseWasX;
      MouseIsY := MouseWasY;
      MouseGotoXy(MouseWasX, MouseWasY);
    end;
  end;

  procedure InitMouseSettings;
  var
    strnum                   : String;
    num, res                 : Integer;
    MouseCharacter           : Byte;
  begin
    {no need to install exit handler if not installed}
    if MouseInstalled then
    begin
      FullMouseWindow;
      MouseWasX := 40;
      MouseWasY := 12;
      MouseIsX := MouseWasX;
      MouseIsY := MouseWasY;
      MouseSenX := 8;
      MouseSenY := 24;
      SlowMouseSenX := 88;
      SlowMouseSenY := 48;
      MouseGotoXy(MouseWasX, MouseWasY);
      SetMickeyToPixelRatio(SlowMouseSenX, SlowMouseSenY);
      SetMouseEventHandler(AllMouseEvents, @AllPurposeEventHandler);
    end;
  end;

begin
  GetIntVec($33, SaveInt33);      {Save off the mouse interrupt}
  {initialize the mouse if one is installed (sets MouseInstalled)}
  if MouseInstalled then InitMouseSettings;
end.
