{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Tips & Techniques Demo Program               }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

program Print_It;

{$R Print_It}

uses WinTypes, WinProcs, WObjects, Strings, WinPrint;

const
  cm_Print = 100;
  cm_SelPrint = 101;
  cm_ConfigPrint = 102;

type
  PMainWindow = ^TMainWindow;
  TMainWindow = object(TWindow)
    PI: PPrinterInfo;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure SetUpWindow; virtual;
    destructor Done; virtual;
    procedure CMPrint(var Msg: TMessage);
      virtual cm_First + cm_Print;
    procedure CMSelPrint(var Msg: TMessage);
      virtual cm_First + cm_SelPrint;
    procedure CMConfigPrint(var Msg: TMessage);
      virtual cm_First + cm_ConfigPrint;
  end;

constructor TMainWindow.Init(AParent: PWindowsObject; ATitle: PChar);
begin
  TWindow.Init(AParent, ATitle);
  Attr.Menu:=LoadMenu(HInstance, 'MAINMENU');
end;

procedure TMainWindow.SetUpWindow;
begin
  TWindow.SetUpWindow;
  new(PI, init);
end;

destructor TMainWindow.Done;
begin
  TWindow.Done;
  dispose(PI, done);
end;

procedure TMainWindow.CMPrint(var Msg: TMessage);
begin
  with PI^ do
  begin
    StartDoc('HardCopy');
    NewFrame;
    TextOut(PrintDC, 10, 10, 'Printing from PRINT_IT.PAS.', 24);
    Rectangle(PrintDC, 100, 100, 300, 300);
    NewFrame;
    EndDoc;
  end;
end;

procedure TMainWindow.CMSelPrint(var Msg: TMessage);
begin
  PI^.SelectPrinter;
end;

type
  TApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

procedure TMainWindow.CMConfigPrint(var Msg: TMessage);
begin
  PI^.DeviceMode;
end;

procedure TApp.InitMainWindow;
begin
  MainWindow:=new(PMainWindow, Init(nil, 'Print_It'));
end;

var
  App: TApp;
begin
  App.Init('Print_It');
  App.Run;
  App.Done;
end.