{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Tips & Techniques Demo Program               }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}



Program MyBitmapPrinter;

uses WObjects, WinProcs, WinTypes, hCopy;

{$R printbmp}

const
  id_Print = 101;

type
  TMyApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMyWIndow = ^TMyWindow;
  TMyWindow = object(TWindow)
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure GetWindowClass(var AWndClass : TWndClass); virtual;
    procedure PrintIT(var Msg : TMessage); virtual cm_first + id_Print;
  end;

{ TMyApplication }
procedure TMyApplication.InitMainWindow;
begin
   MainWindow:= new(PMyWindow,init(nil,'Print Example'));
end;

{ TMyWindow }
constructor TMyWindow.Init(AParent: PWindowsObject; ATitle: PChar);
begin
  TWindow.Init(AParent, ATitle);
end;

procedure TMyWindow.GetWindowClass(var AWndClass : TWndClass);
begin
  TWindow.GetWindowClass(AWndClass);
  AWndClass.lpszMenuName := 'MyMenu';
end;

procedure TMyWindow.PrintIT(var Msg : TMessage);
var
  hBmp:hBitMap;
begin
  hBmp:= LoadBitmap(hInstance, 'MyBitMap');
  if hBMP<>0 then
  PrintBitmap(HWindow, hBmp);
end;

{ Main }
var
  MyApp: TMyApplication;
begin
  MyApp.Init('MyProgram');
  MyApp.Run;
  MyApp.Done;
end.