{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Tips & Techniques Demo Program               }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

program Center;

{$R Center}

uses WinTypes, WinProcs, WObjects;

type
TApp = object(TApplication)
  procedure InitMainWindow; virtual;
end;

PMyWindow = ^TMyWindow;
TMyWindow = object(TWindow)
  procedure WMLButtonDown(var Message:TMessage);
    virtual wm_LButtonDown;
end;

PMyDialog = ^TMyDialog;
TMyDialog = object(TDlgWindow)
   procedure SetupWindow; virtual;
end;

procedure TApp.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(Nil, 'Center'));
end;

procedure TMyDialog.SetupWindow;
var
  MyRect: TRect;
  X, Y: Integer;
begin
  TDlgWindow.SetupWindow;
  X := GetSystemMetrics(SM_CXScreen) div 2;
  Y := GetSystemMetrics(SM_CYScreen) div 2;
  GetWindowRect(HWindow, MyRect);
  with MyRect do
    SetWindowPos(HWindow, 0, x -  ((Right-Left) div 2),
      y - ((Bottom-Top) div 2), MyRect.Right,  MyRect.Bottom,
    swp_NoSize or swp_NoZOrder);
end;

procedure TMyWindow.WMLButtonDown(var Message: TMessage);
begin
  Application^.ExecDialog(new(PMyDialog, Init(@Self, 'Center_Me')));
end;

var
  App: TApp;
begin
  App.Init('Center');
  App.Run;
  App.Done;
end.
