{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Tips & Techniques Demo Program               }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

program Cursor;

uses WinTypes, WinProcs, WObjects;

type
  TApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    function  GetClassName: PChar; virtual;
    procedure GetWindowClass(var AWndClass: TWndClass); virtual;
  end;

procedure TApp.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(Nil, 'Cross'));
end;


function TMyWindow.GetClassName: PChar;
begin
  GetClassName := 'CrossCursorDemoWindow';
end;


procedure TMyWindow.GetWindowClass(var AWndClass: TWndClass);
begin
  TWindow.GetWindowClass(AWndClass);
  AWndClass.HCursor := LoadCursor(HWindow, idc_Cross);
end;

var
  App: TApp;

begin
  App.Init('Cross');
  App.Run;
  App.Done;
end.
