program testdial;

uses objects,views,app,drivers,menus,dialogs,crt,

     THERM;   {<-------}


type
  Ttest = object(TApplication)
            constructor init;
            procedure InitMenuBar; virtual;
            procedure InitStatusLine; virtual;
            procedure ShowDialog;
            procedure HandleEvent(var Event:TEvent); virtual;
          end;


const
   cmNow = 100;

{**************************************************************************}
procedure Push_Event (Cmd : word);
var
  Put_Event : TEvent;
begin
  with Put_Event do
  begin
    What    := evCommand;
    Command := Cmd;
    InfoPtr := nil;
  end; {with}
  {*------------------------------------------------------*}
  {* put it on the Event Schedule Queue                   *}
  {*------------------------------------------------------*}
  DeskTop^.PutEvent (Put_Event);
end; {Push_Event}


{**************************************************************************}
constructor Ttest.Init;
begin
  TApplication.init;
  Push_Event (cmNow);
end; {init}

{**************************************************************************}
procedure Ttest.InitMenuBar;
  var R:TRect;
  begin
    GetExtent(R);
    R.B.Y := R.A.Y +1;
    MenuBar:= New(PMenuBar, Init(R, NewMenu(
      NewSubMenu('~R~un It',hcNoContext, NewMenu(
        NewItem('~R~un Demo (again)', 'F2', kbF2, cmNow, hcNoContext,
        nil)),
        nil)
      )));
  end;

{**************************************************************************}
procedure Ttest.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y-1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      nil)), nil)));
end;

{**************************************************************************}
procedure Ttest.HandleEvent(var Event: TEvent);
 begin {HandleEvent}
  TApplication.HandleEvent(Event);

  case Event.What of
    evCommand:
      begin
        case Event.Command of
          cmNow: ShowDialog;
        else
          Exit;
        end;
        ClearEvent(Event);
      end;
  end;
end; {HandleEvent}

{**************************************************************************}
procedure Ttest.ShowDialog;
var
  i : integer;
  max : integer;
begin

  i := 1;
  max := 100;
  {*********************************************}
  {* first call with FALSE creates the dialog! *}
  {*********************************************}
  THERM.Thermometer ('Test Thermometer', 0, Max, FALSE);

  {*************************************}
  {* Now call once per processing loop *}
  {*************************************}
  repeat
    THERM.Thermometer ('Therm Processing', i, Max, FALSE);
    INC (i);

    {************************************}
    {* Put your actual processing here! *}
    {* Ill cheat and put a delay        *}
    {************************************}
    CRT.Delay (30);
  until (i = Max);

  {*******************************}
  {* Important: TRUE disposes it *}
  {*******************************}
  THERM.Thermometer ('', 0, 0, TRUE);

end; {showdialog}


{**************************}
var
  test: Ttest;
begin {main app}
  test.init;
  test.run;
  test.done;
end.

