(******************************************************************************

                                UNIT  WRITATTR


-------------------------------------------------------------------------------
Philippe Ranger  (514) 274 4653
First version  26-6-90          Present version  13-7-90
-------------------------------------------------------------------------------
SPECIFICATION
   Defines a class of TFDD, writAttrC, and declares, initalizes and opens one
      instance, wa (text file is wa.t).
   WritAttrC executes standard screen writes except that the following control
      chars are not written but command a change in attribute (permanent until
      changed again):
      ^N = normal;
      ^B = bold;
      ^C = not bold;
      ^U = underline;
      ^V = no underline;
      ^R = reverse;
      ^S = not reverse;
      ^O = blink (on-off);
      ^P = no blink.
   On color screens, underline is blue. Utilities such as PCMag's Undrlin2
      allow regaining the underline instead. Other attributes may be added
      for other colors; this unit is aimed at working with most screens.
   Unit uses Crt. Output can be redirected through
            assign ('', filename); rewrite ('');
      Filename will hold everything written to wa minus the above attribute
      codes. Attribute changes will carry onscreen.
******************************************************************************)

UNIT writAttr;

INTERFACE

USES tfdd;

TYPE
   writAttrC = object (tfddC)
      constructor init
      end;

VAR  wa: writAttrC;

IMPLEMENTATION

USES crt, dos;

{$F+}

PROCEDURE initialize; BEGIN  wa.init  END;


FUNCTION attrWrite (var t: textRec): integer;
(*=============================================================================
PRE t open for output only;
-------------------------------------------------------------------------------
POST See unit specification.
=============================================================================*)

TYPE
   dispAttrT = (Fb, Fg, Fr, Fhi, Bb, Bg, Br, onOff);
   dispAttrE = set of dispAttrT;

VAR
   attr: dispAttrE absolute textAttr;
   i, i0: word;
   s: string;
   s0: byte absolute s;

BEGIN
with t do begin
   attrWrite := 0;
   i0 := 0; i := 0;
   while i < bufPos do begin
      i0 := i;
      while (i < bufPos) and (i - i0 < 255) and (bufPtr^[i] >= ' ') do
         inc(i);
      move (bufPtr^[i0], s[1], i - i0);
      s0 := i - i0;
      write (s);
      if i < bufPos then begin
         case bufPtr^[i] of
            ^N: attr := [Fb, Fg, Fr];
            ^B: attr := attr + [Fhi];
            ^C: attr := attr - [Fhi];
            ^U: attr := attr - [Fg, Fr];
            ^V: attr := attr + [Fg, Fr];
            ^R: begin
               if Fb in attr then attr := attr + [Bb];
               if Fg in attr then attr := attr + [Bg];
               if Fr in attr then attr := attr + [Br];
               attr := attr - [Fb, Fg, Fr]
               end;
            ^S: begin
               if Bb in attr then attr := attr + [Fb];
               if Bg in attr then attr := attr + [Fg];
               if Br in attr then attr := attr + [Fr];
               attr := attr - [Bb, Bg, Br]
               end;
            ^O: attr := attr + [onOff];
            ^P: attr := attr - [onOff];
            else write (bufPtr^[i])
            end;
         inc (i)
         end
      end
   end
END;  (*attrWrite*)


CONSTRUCTOR writAttrC.init;
BEGIN
   tfddC.init;
   textRec(t).inoutFunc := @attrWrite;                           (*on principle*)
   textRec(t).flushFunc := @attrWrite;
              (*Flush seems to be the only function actually called for writes*)
   rewrite (t)
END;


BEGIN INITIALIZE END.
