Unit DosBios;

(* DosBios.Inc *)

(*    05/02/1988     J Tal
                     Rollins Medical/Dental Systems
        
                     Public Domain
*)

{$V-}

Interface

   Uses Dos,Funcs;



   TYPE
      regpack = Dos.Registers;

      dta_date_type = record
                      year,month,day: INTEGER;
                    END;

      dta_time_type = record
                      hour,min,sec: INTEGER;
                   END;

     st255 = string[255];
     scr_buffer_ptr = ^scr_buffer_type;
     scr_buffer_type = ARRAY[1..4004] OF BYTE;


   procedure wget(x,y,w,h: byte; buff_ptr : scr_buffer_ptr);

   procedure wput(x,y,w,h: byte; buff_ptr : scr_buffer_ptr);

   Procedure Scroll_Page_Up(x,y,w,h,lines,attrib: BYTE);

   Procedure Scroll_Page_Dn(x,y,w,h,lines,attrib: BYTE);

   Procedure Put_Cursor(x,y: BYTE);

   Procedure Get_Cursor(VAR x,y: BYTE);

   Procedure Get_Vattrib(VAR vchar,vattrib: byte);

   Procedure Put_Vattrib(vchar,vattrib: byte);

   Function get_Vmode: INTEGER;

   Function get_dos_ver_number : st255;

   Function get_date : st255;

   Function get_time : st255;

   Procedure Get_DTA(VAR DTA_SEG,DTA_OFS: WORD);

   Function Current_Drive : INTEGER;

   Function Get_Cur_Dir(cur_drive: INTEGER) : st255;

   Procedure DirFile(first: INTEGER; search_str: st255; DTA_SEG,DTA_OFS: WORD;
                     VAR found_str: st255; VAR attrib: INTEGER);

   Procedure DelFile(fn: st255);

   Function ShiftState(ss: INTEGER): BOOLEAN;

   Procedure Disk_Free(Drive: WORD; VAR Disk_bytes, avail_bytes: LongInt);

   Function DayOfWeek(dstr: st255) : INTEGER;

   Procedure ReadDTA(VAR disk_time,disk_date: INTEGER; DTA_SEG,DTA_OFS: WORD;
                     VAR DTA_attrib: WORD; VAR dsize: LongInt);

   Procedure Do_DTA_Date(disk_date,disk_time: INTEGER; DTA_SEG,DTA_OFS: WORD;
                      VAR DTA_Date: dta_date_type; VAR dta_time: dta_time_type);

   Procedure Open_File(f:st255; omode: INTEGER; VAR fhandle: INTEGER);

   Procedure Close_File(fhandle: INTEGER);

   Procedure LSeek(fhandle,smode: INTEGER; flen: LongInt);

   Procedure Write_File(fhandle,buf_seg,buf_adr,bytes: INTEGER);

   Procedure SetFileTime(fhandle,time_word,date_word: INTEGER);

   Procedure GetFileTime(fhandle,time_word,date_word: INTEGER);

   Procedure F_Copy(source,dest: st255; disk_time,disk_date: INTEGER; flen: LongInt);

   Function Mem_Free : LongInt;

   Function Mem_Installed : LongInt;



Implementation
{$L Pwindow}

VAR
  RecPack : RegPack;

Procedure WGET;  External;

Procedure WPUT;  External;


Procedure Scroll_Page_Up;
(* x,y,w,h,lines,attrib: BYTE *)
BEGIN
  recpack.ah := $06;
  recpack.al := lines;
  recpack.cl := x-1;   (* x upper left *)
  recpack.ch := y-1;   (* y upper left *)
  recpack.dl := x+w-2; (* x lower right *)
  recpack.dh := y+h-2; (* y lower right *)
  recpack.bh := attrib;
  Intr($10,recpack);
END;

Procedure Scroll_Page_Dn;
(* x,y,w,h,lines,attrib: BYTE *)
BEGIN
  recpack.ah := $07;
  recpack.al := lines;
  recpack.cl := x-1;   (* x upper left *)
  recpack.ch := y-1;   (* y upper left *)
  recpack.dl := x+w-2; (* x lower right *)
  recpack.dh := y+h-2; (* y lower right *)
  recpack.bh := attrib;
  Intr($10,recpack);
END;


Procedure Put_Cursor;
(* (x,y: BYTE); *)
BEGIN
   recpack.ah := $02;  (* position cursor *)
   recpack.dh := y - 1;
   recpack.dl := x - 1;
   recpack.bh := 0;  (* video page *)
   Intr($10,recpack);
END;

Procedure Get_Cursor;
(* (VAR x,y: BYTE); *)
BEGIN
   recpack.ah := $03;  (* position cursor *)
   recpack.bh := 0;    (* video page *)
   Intr($10,recpack);
   y := recpack.dh + 1;
   x := recpack.dl + 1;
END;

Procedure Get_Vattrib;
(* (VAR vchar,vattrib: byte); *)
BEGIN
   recpack.ah := $08;  (* read attrib, char *)
   recpack.bh := 0;    (* page numbert *)
   Intr($10,recpack);
   vchar := recpack.al;
   vattrib := recpack.ah;
END;


Procedure Put_Vattrib;
(* (vchar,vattrib: byte); *)
BEGIN
   recpack.ah := $09;  (* write  attrib, char *)
   recpack.bh := 0;    (* video page *)
   recpack.cx := 1;    (* 1 char to write *)
   recpack.al := vchar;
   recpack.bl := vattrib;
   Intr($10,recpack);
END;


Function get_Vmode;
(* INTEGER *)
BEGIN
  recpack.ax := $0F00;
  Intr($10,recpack);
  get_Vmode := recpack.ax mod 256;
END; (* get_Vmode *)

  { ------------------- }

Function get_dos_ver_number;
(* st255 *)
VAR
  mnrn,mjrn: INTEGER;
begin
  recpack.ax := $3000;   (* get dos ver number *)
  msdos(recpack);
  mnrn := recpack.ax shr 8;
  mjrn := recpack.ax mod 256;
  get_dos_ver_number := fns(mjrn) + '.' + fns(mnrn);
end;

  { ------------------- }

Function get_date;
(* st255 *)
var
  month,day : string[2];
  year      : string[4];
  dx,cx     : integer;
  daynum    : INTEGER;
begin
  recpack.ax := $2a00;   (* get dos date *)
  msdos(recpack);
  with recpack do
  begin
    str(cx,year);
    str(dx mod 256,day);
    str(dx shr 8,month);
    daynum := ax mod 256;
  end;
  get_date := fnzero(month,2) + '/' + fnzero(day,2) + '/' + fnzero(year,2);
end;

  { ------------------- }

Function get_time;
(* st255 *)
var
  hour,min,sec : string[2];
begin
  recpack.ax := $2c00;   (* get dos time *)
  str(recpack.cx shr 8,hour);
  str(recpack.cx mod 256,min);
  str(recpack.dx shr 8,sec);
  get_time := fnzero(hour,2) + ':' + fnzero(min,2) + ':' + fnzero(sec,2);
end;

  { ------------------- }

Procedure Get_DTA;
(* (VAR DTA_SEG,DTA_OFS: WORD); *)
BEGIN
   (* get dta *)
   recpack.AX := $2F00;
   MSDOS(recpack);
   DTA_SEG := recpack.ES;
   DTA_OFS := recpack.BX;
END; (* GET_DTA *)

  { ------------------- }

Function Current_Drive;
(* Integer *)
BEGIN
   recpack.AX := $1900;
   MsDos(recpack);
   current_drive := (recpack.ax mod 256);
END;  
 
  { ------------------- }

Function Get_Cur_Dir;
(* (cur_drive: INTEGER) : st255; *)
VAR
   user_memory: st255;
   i: INTEGER;
BEGIN
   recpack.AX := $4700;
   recpack.DS := seg(user_memory);
   recpack.SI := ofs(user_memory)+1;
   recpack.DX := cur_drive;
   MSDOS(recpack);
   IF (recpack.flags and 1) = 1 THEN begin
     user_memory := 'ERROR';
   end
   ELSE begin
     i := 1;
     while user_memory[i] <> chr(0) DO begin
        i := i + 1;
     END;
     user_memory[0] := chr(i-1);
   END;
   Get_Cur_Dir := user_memory;
END;

  { ------------------- }

Procedure DirFile;
(*  (first: INTEGER; search_str: st255; DTA_SEG,DTA_OFS: WORD; 
     VAR found_str: st255; VAR attrib: INTEGER); *)
VAR i,b: INTEGER;
    fname: st255;
BEGIN
  fname := search_str + chr(0);
  found_str := '';
  IF first = 1 THEN begin

     (* search first *)
     recpack.AX := $4E00;  (* find first matching *)
     recpack.CX := attrib;
     recpack.DS := Seg(fname[1]);
     recpack.DX := Ofs(fname[1]);
     MSDOS(recpack);
     IF (recpack.flags AND 1) <> 1 THEN begin
       attrib := MEM[DTA_SEG:DTA_OFS+21];
       i := DTA_OFS + 30;
       b := MEM[DTA_SEG:i];
       WHILE (i < DTA_OFS+42) AND (b <> 0) DO begin
         found_str := found_str + CHR(b);
         i := i + 1;
         b := MEM[DTA_SEG:i];
       END;
     end
     ELSE begin
       Found_str := 'EOF';
     END;

  end
  ELSE BEGIN
     recpack.AX := $4F00;  (* find next matching *)
     recpack.AX := recpack.AX XOR 1;  (* turn carry off *)
     MSDOS(recpack);
     IF (recpack.flags AND 1) <> 1 THEN begin
       attrib := MEM[DTA_SEG:DTA_OFS+21];
       i := DTA_OFS + 30;
       b := MEM[DTA_SEG:i];
       WHILE (i < DTA_OFS+42) AND (b <> 0) DO begin
         found_str := found_str + CHR(b);
         i := i + 1;
         b := MEM[DTA_SEG:i];
       END;
     end
     ELSE BEGIN
        found_str := 'EOF';
     END;
  END;
END;  (* DirFile *)

  { ------------------- }

Procedure DelFile;
(* (fn: st255); *)
VAR
  fname: st255;
BEGIN
  fname := fn + CHR(0);
  recpack.AX := $4100;
  recpack.DS := Seg(fname[1]);
  recpack.DX := Ofs(fname[1]);
  MSDOS(recpack);
  IF (recpack.flags AND 1) = 1 THEN begin
   (* error deleting *)
    WriteLn('Error :  ',fn);
  END;
END;

  { ------------------- }

Function ShiftState;
(* (ss: INTEGER): BOOLEAN; *)
BEGIN
  recpack.AX := $0200;
  Intr($16,recpack);
  ShiftState := ((recpack.ax mod 256) and ss) = ss;
END;

  { ------------------- }

Procedure Disk_Free;
(* (Drive: WORD; VAR Disk_bytes, avail_bytes: LongInt); *)
VAR
  Avail_Clusters,Clusters_Drive,Bytes_Sector,Sectors_Cluster: LongInt;
BEGIN
  recpack.AX := $3600;
  recpack.DX := Drive;
  MsDos(recpack);
  IF (RecPack.flags and 1) = 1 then begin
    disk_bytes := -1;
    avail_bytes := -1;
  end
  ELSE begin
    Avail_Clusters := recpack.BX;
    Clusters_Drive := recpack.DX;
      Bytes_Sector := recpack.CX;
   Sectors_Cluster := recpack.AX;
   avail_bytes := Avail_Clusters * Sectors_Cluster * Bytes_Sector;
   disk_bytes := clusters_drive * sectors_cluster * bytes_sector;
  END;

END;

  { ------------------- }

Function DayOfWeek;
(* (dstr: st255) : INTEGER; *)
VAR month_num,
     week_day,
     year_num,
     x3,x4,x5,
     x6,x7,x8: INTEGER;
BEGIN
    month_num := fnval(copy(dstr,1,2));
    week_day  := fnval(copy(dstr,4,2));
    year_num  := fnval(copy(dstr,7,4));

    x4 := year_num - trunc(year_num / 28) * 28;
    if x4 = 0
      then
        x4 := 28;
    x5 := trunc((x4 - 1) / 4);
    x6 := x4 - 1 - x5 * 4;
    x4 := x5 * 5 - trunc(x5 * 5 / 7) * 7;
    x5 := x4 + x6 - 7;
    if x5 < 0
     then
       x5 := x4 + x6;
    x4 := (month_num - 1) * 30;
    x6 := trunc((month_num - 1) / 2);
    x7 := month_num - 1 - x6 * 2;
    x8 := x4 + x6 + x7;
    if (x6 > 3) and (x7 = 0)
      then
        x8 := x8 + 1;

    if x6 <> 0
      then
        begin
          if year_num <> trunc(year_num / 4) * 4
           then
             x4 := week_day + x8 - 2
           else
             x4 := week_day + x8 - 1;
        end
      else
        x4 := week_day + x8;

    year_num := x4 - trunc(x4 / 7) * 7;
    if year_num = 0
      then
        year_num := 7;
    year_num := year_num - 1;
    week_day := year_num + x5 - 7;
    if week_day < 0
      then
        week_day := year_num + x5;
    week_day := week_day + 1;

    DayOfWeek := week_day;
END;

  { ------------------- }

Procedure ReadDTA;
(*  (VAR disk_time,disk_date: INTEGER; DTA_SEG,DTA_OFS: WORD;
     VAR DTA_attrib : WORD; dsize: LongInt); *)
VAR
  i: INTEGER;
  ds: ARRAY[1..4] OF LongInt;
BEGIN
   disk_time := MEM[DTA_SEG:DTA_OFS+22]+MEM[DTA_SEG:DTA_OFS+23]*256;
   disk_date := MEM[DTA_SEG:DTA_OFS+24]+MEM[DTA_SEG:DTA_OFS+25]*256;
   DTA_attrib := MEM[DTA_SEG:DTA_OFS+21];
   FOR i := 26 to 29 DO begin
     ds[i-25] := MEM[DTA_SEG:DTA_OFS+i];
   END;
   dsize := (ds[1] + ds[2]*256) + (ds[3]+ds[4]*256) * 65536;
END;

  { ------------------- }

Procedure Do_DTA_Date;
(*  (disk_date,disk_time: INTEGER; DTA_SEG,DTA_OFS: WORD;
     VAR DTA_Date: dta_date_type; VAR dta_time: dta_time_type); *)
BEGIN
  DTA_date.year := (disk_date shr 9) + 1980;
  DTA_date.month := (disk_date shr 5) and 15;
  DTA_date.day := disk_date and 31;
  DTA_time.hour := (disk_time shr 11);
  DTA_time.min  := (disk_time shr 5) and 63;
END;  

(*  week_day := DayOfWeek(fns_z(DTA_date.month)+'/'+fns_z(DTA_date.day)+'/'+fns(DTA_date.year)); *)

  { ------------------- }

Procedure Open_File;
(*  (f:st255; omode: INTEGER; VAR fhandle: INTEGER); *)
VAR
  fname: st255;
BEGIN
    fname := f+chr(0);
    Recpack.AX := $3D00 + omode;
    Recpack.DX := OFS(fname)+1;  (* skip [0] *)
    Recpack.DS := SEG(fname);
    MsDos(Dos.Registers(RecPack));
    IF (RecPack.flags AND 1) <> 1 THEN begin
       fhandle := RecPack.AX;
    end
    ELSE begin
       fhandle := -1;
       WriteLn('error opening file ',f,'  = ',recpack.ax);
    END;
END; (* Open_File *)

  { ------------------- }

Procedure Close_File;
(*  (fhandle: INTEGER); *)
BEGIN
    RecPack.AX := $3E00;
    RecPack.BX := fhandle;
    MsDos(Dos.Registers(RecPack));
END; (* Close_File *)

  { ------------------- }

Procedure LSeek;
(*  (fhandle,smode: INTEGER; flen: LongInt); *)
BEGIN
    RecPack.AX := $4200 + smode;
    RecPack.CX := flen div 65536;
    RecPack.DX := flen mod 65536;
    RecPack.BX := fhandle;
    MsDos(Dos.Registers(RecPack));
END; (* LSeek *)

  { ------------------- }

Procedure Write_File;
(*  (fhandle,buf_seg,buf_adr,bytes: INTEGER); *)
BEGIN
    RecPack.AX := $4000;
    RecPack.BX := fhandle;
    RecPack.CX := bytes;
    RecPack.DX := Word_Int(buf_adr);
    RecPack.DS := Word_Int(buf_seg);
    MsDos(Dos.Registers(RecPack));
END; (* Write_File *)

  { ------------------- }

Procedure SetFileTime;
(* (fhandle,time_word,date_word: INTEGER); *)
BEGIN
  recpack.ax := $5701;
  recpack.bx := fhandle;
  recpack.cx := time_word;
  recpack.dx := date_word;
  MsDos(recpack);
END;  (* SetFileTime *)

  { ------------------- }

Procedure GetFileTime;
(*  (fhandle,time_word,date_word: INTEGER); *)
BEGIN
  recpack.ax := $5700;
  recpack.bx := fhandle;
  MsDos(recpack);
  time_word := recpack.cx;
  date_word := recpack.dx;
END; (* GetFileTime *)

  { ------------------- }

Procedure F_Copy;
(*  (source,dest: st255; disk_time,disk_date: INTEGER; flen: LongInt); *)
CONST
  BufSize = 1024;
VAR
  a,b: FILE;
  Buffer: ARRAY[1..BufSize] OF BYTE;
  RecsRead: INTEGER;
  fhandle,date_word,time_word: INTEGER;
BEGIN
  Assign(a,source);
  Assign(b,dest);
  Reset(a);
  Rewrite(b);
  REPEAT
    BlockRead(a,Buffer,BufSize DIV 128,RecsRead);
    BlockWrite(b,Buffer,RecsRead);
  UNTIL RecsRead = 0;
  Close(a);
  Close(b);

  Open_File(dest,2,fhandle);
  IF fhandle <> -1 THEN begin
    Lseek(fhandle,0,flen);
    IF (RecPack.flags AND 1) <> 1 THEN begin
       Write_File(fhandle,-1,0,0);
       SetFileTime(fhandle,disk_time,disk_date);
       Close_File(fhandle);
    end
    ELSE begin
      Close_File(fhandle);
    END;
  END;
END; (* Fcopy *)


Function Mem_Free;
(*  : LongInt; *)
BEGIN
  recpack.AX := $4800;
  recpack.BX := $FFFF;
  MsDos(RecPack);
  Mem_Free := recpack.BX * 16;
END;

Function Mem_Installed;
(*  : LongInt; *)
VAR
  kblocks : LongInt;
BEGIN
  Intr($12,RecPack);
  kblocks := RecPack.ax;
  Mem_Installed := kblocks * 1024;
END;


END.

