 UNIT:  HELPFILE.PAS
PATCH:  Add "Alt-F1" for previous help screen.
NOTES:  This patch, along with SHAZAM II, allows Turbo Vision programs
        to recall the last 20 help screens.



Add the lines marked with {!!}, plus "Push" and "Pop" procedures.
-----------------------------------------------------------------------
   {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
   Global - add after "CHelpWindow" palette
   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
CONST
   MaxHelp                   = 20 ;    {!!}             { max screens }
VAR
   StackHelp                 : array [ 1..MaxHelp ] of
                               integer ;          {!!} { screen stack }
   {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
   Add BEFORE "THelpViewer.HandleEvent ( ) ;"
   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
procedure PushRef ( Element : integer ) ;                          {!!}
var
   i                         : integer ;
begin
    for i := MaxHelp downto 2 do
        StackHelp [ i ]      := StackHelp [ i - 1 ] ;
    StackHelp [ 1 ]          := Element ;
end ;

function PopRef : integer ;                                        {!!}
var
   i                         : integer ;
begin
   for i := 1 to ( MaxHelp - 1 ) do
       StackHelp [ i ]       := StackHelp [ i + 1 ] ;
   StackHelp [ MaxHelp ]     := 0 ;
   PopRef                    := StackHelp [ 1 ] ;
end ;
   {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
   Add to "THelpViewer.HandleEvent ( ) ;"
   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
begin
   ...
   evKeyDown :
   ...
      kbEnter :
      ...
         Topic^.GetCrossRef ( Selected , KeyPoint , KeyLength , KeyRef ) ;
         SwitchToTopic ( KeyRef ) ;
         PushRef ( KeyRef ) ;                    {!!} {push new screen}
      ...
      kbAltF1 : SwitchToTopic ( PopRef ) ;        {!!} {pop old screen}
   ...
   evMouseDown :
      begin
         ...
         if Event.Double then
         begin                                                     {!!}
            SwitchToTopic ( KeyRef ) ;
            PushRef ( KeyRef ) ;                                   {!!}
         end ;                                                     {!!}
      end ;
end ;
   {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
   Add at end of "THelpWindow.Init ( ) ;"
   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
begin
   ...
   PushRef ( Context ) ;                                           {!!}
end ;
   {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
   Add to UNIT initialization
   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
BEGIN
   FillChar ( StackHelp , SizeOf ( StackHelp ) , #0 ) ;            {!!}
END .
-----------------------------------------------------------------------
