{$I compiler }
{$O-}
UNIT ExecProc;INTERFACE USES Overlay,Dos,
                             Memory,Objects,Buffers;
   {*******************************************************************
   EXECPROC.PAS, Version 2.1   Copyright (c) 1991,92 Johnathan J. Stein
                                          All Rights Reserved WorldWide
                                           STEIN RESEARCH & ENGINEERING
                                                    Post Office Box 346
                                                   Perrysburg, OH 43552
                                                     Voice 419-666-7103
                                                     Fax   419-874-4922
   Only for use by Licensed Users of SHAZAM.       CompuServe 76576,470
   *******************************************************************}
   {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
   Automate use of procedure pointers.
   [X] ExecPROC.Exec defaults to normal exec if SWAP fails
   [X] ExecPROC.Exec recovers overlay space via SHAZAM "Remap"

   Related:  see "function VisionExec..." in GENERAL.PAS
   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
   {===================================================================
   So we can call EXECSWAP without USES complications.
   ===================================================================}
TYPE
   TInitExecSwap             = function ( P : pointer ;
                                          S : string ) : boolean ;
   TExecWithSwap             = function ( S1 ,
                                          S2 : string ) : word ;
   TShutDownExecSwap         = procedure ;
VAR
   InitExecSwap              : TInitExecSwap ;         
   ExecWithSwap              : TExecWithSwap ;         
   ShutDownExecSwap          : TShutDownExecSwap ;     
CONST
   SwapFileName              : string = 'SWAP.$$$' ;
   UseExecSwap               : boolean = TRUE ;
   UseEMSSwap                : boolean = TRUE ;

function BuffersInUse        : boolean ;
function OverlaysInUse       : boolean ;
function RemapInUse          : boolean ;
function Exec                ( Path , CmdLine : string ) : word ;

IMPLEMENTATION

   {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

   MEMORY - information

   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
   {===================================================================

   BUFFERS - test for special heap management

   ===================================================================}
function BuffersInUse : boolean ;
begin
   BuffersInUse              := ( PtrRec ( HeapEnd ).Seg <> BufHeapEnd ) and
                                ( BufHeapEnd <> 0 ) ;
end ;
   {===================================================================

   OVERLAYS - test for presence of overlays

   ===================================================================}
function OverlaysInUse : boolean ;
begin
   OverlaysInUse             := OvrGetBuf <> 0 ;
end ;
   {===================================================================

   REMAP - test for overlay buffer at top of memory

   ===================================================================}
function RemapInUse : boolean ;
begin
   RemapInUse                := PtrRec ( HeapOrg ).Seg < OvrHeapEnd ;
end ;
   {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

   EXEC - DosError holds result.  Function returns DosExitCode of child
          process.  If SHAZAM RemapMemory is active, then non-swap EXEC
          recovers overlay heap.

   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
   {===================================================================

   SWAP

   ===================================================================}
function SwapOK ( Path , CmdLine : string ) : word ;
var
   AvailPtr                  : pointer ;
begin
   SwapFileName              := FExpand ( SwapFileName ) ;
   SwapOK                    := $FFFF ;
   if not UseExecSwap then EXIT ;
   if @InitExecSwap = NIL then EXIT ;
   if BuffersInUse then
      AvailPtr               := Ptr ( BufHeapPtr , 0 )
   else
      AvailPtr               := HeapPtr ;
   if not InitExecSwap ( AvailPtr , SwapFileName ) then EXIT ;
   SwapVectors ;
   OvrClearBuf ;
   DosError                  := WORD ( ExecWithSwap ( Path , CmdLine ) ) ;
   SwapVectors ;
   SwapOK                    := DOS.DosExitCode ;
   ShutdownExecSwap ;
end ;
   {===================================================================

   EXEC - returns "DosExitCode".

   ===================================================================}
function Exec ( Path , CmdLine : string ) : word ;
var
   AvailPtr                  : pointer ;
   EndPtr                    : pointer ;
   TempDosExitCode           : word ;
begin
   DosError                  := 0 ;
   TempDosExitCode           := SwapOK ( Path , CmdLine ) ;
   if TempDosExitCode <> $FFFF then
   begin
      Exec                   := TempDosExitCode ;
      EXIT ;
   end ;
   {- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   AvailPtr = UNUSED MEMORY
   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}
   if BuffersInUse then
      AvailPtr               := Ptr ( BufHeapPtr , 0 )
   else
      AvailPtr               := HeapPtr ;
   {- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   EndPtr = Top Of Memory
   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}
   if OverlaysInUse and RemapInUse then
      EndPtr                 := Ptr ( OvrHeapEnd , 0 )
   else
      if BuffersInUse then
         EndPtr              := Ptr ( BufHeapEnd , 0 )
      else
         EndPtr              := HeapEnd ;
   SetMemTop ( AvailPtr ) ;
   SwapVectors ;
   OvrClearBuf ;
   DOS.Exec ( Path , CmdLine ) ;
   TempDosExitCode           := DOS.DosExitCode ;
   Exec                      := TempDosExitCode ;
   SwapVectors ;
   {- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   Restore memory allocation
   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}
   SetMemTop ( EndPtr ) ;
end ;
   {===================================================================
   The EXECSWAP unit MUST assign addresses to procedures.  If it is NOT
   used, this unit will maximize memory available anyway.  Also useful
   when EXECSWAP is used, but cannot create swap file (such as running
   on a write-protected floppy.)
   ===================================================================}
procedure InstallExec ;
begin
   FillChar ( InitExecSwap , SizeOf ( InitExecSwap ) , #0 ) ;
   FillChar ( ExecWithSwap , SizeOf ( ExecWithSwap ) , #0 ) ;
   FillChar ( ShutDownExecSwap , SizeOf ( ShutDownExecSwap ) , #0 ) ;
end ;
   {^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
   INITIALIZATION
   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^}
BEGIN
   InstallExec ;
END.
