{*************************************************************
 * Superclassing DLL for Borland Pascal                      *
 * =====================================                     *
 *                                                           *
 * by Uwe Richter, based on SUPERCLS.EXE in the MSL library  *
 * MRU: 5.10.1994                                            *
 *                                                           *
 * See SuperCls.Pas for more information                     *
 *************************************************************}

library SuperEd;

uses WinTypes,WinProcs,Strings;

var  lpOldEditFunc:Tfarproc;

{This new window function receives all messages for SuperclassEdit-
 controls and sends all message to the original window function
 except wm_char messages with invalid characters. This allows to
 create useful custom classes easily.}

function SuperclassWinFn(HWindow: HWnd; Message: Word; wParam: Word;
  lParam: Longint): Longint; export;
  var oldinst:thandle;
  begin
    {The following sequence installs the input filter.}
    if (message=wm_char) and
       (not (char(wparam) in ['a'..'z','A'..'Z','0'..'9',#8])) then
      begin
        messagebeep(0);
        SuperclassWinFn:=0;
      end else
    SuperclassWinFn:=CallWindowProc(lpOldEditFunc,hwindow,
       message,wparam,lparam);
  end;

exports SuperclassWinFn index 1;

var Class: TWndClass;
begin
  GetClassInfo(0,'EDIT',class);
  lpOldEditFunc:=class.lpfnWndProc;
  with Class do
  begin
    lpszClassName := 'SuperclassEdit';
    lpfnWndProc   := TFarProc(@SuperclassWinFn);
    style         := style or cs_GlobalClass;
    hInstance     := system.hInstance;
  end;
  if not RegisterClass(Class) then PostQuitMessage(0);
end.