{*************************************************************
 * Superclassing demo for Borland Pascal                     *
 * =====================================                     *
 *                                                           *
 * (c) by Uwe Richter                                        *
 *                                                           *
 * This demo demonstrates superclassing to create new global *
 * Window classes by slightly changing the built in classes. *
 * A good example is an edit control filtering its input.    *
 * This program runs a dialog with 'SuperclassEdit' controls.*
 * The SuperEd.Dll contains code for superclassing transla-  *
 * ted from the original C code.                             *
 * This is not a complete control source, the RWS interface  *
 * has to be added. If you have any comments or hints send   *
 * them to CIS 100136,1715.                                  *
 *                                                           *
 * MRU: 5.10.1994                                            *
 *************************************************************}


{$R supercls.RES}

uses  WinTypes, WinProcs, Win31, Objects, OWindows, ODialogs;

const DLLName = 'SUPERED.DLL';

const
  em_DLLNotFound = 1;

type
  PApp = ^TApp;
  TApp = object(TApplication)
    Lib: THandle;
    constructor Init(AName: PChar);
    destructor  Done; virtual;
    procedure   InitMainWindow; virtual;
    procedure   Error(ErrorCode: Integer); virtual;
  end;

constructor TApp.Init(AName: PChar);
  var w:word;
  begin
  { Loading the DLL registers the superclassed edit control.
    Tell Windows not to display a 'DLL not found' error
    dialog if the LoadLibrary function fails.  We'll handle
    the error and inform the user ourselves.
    Note that even though this SEM_ constant is defined and
    documented only in Windows 3.1, it actually works in
    Windows 3.0 as well... }
    w:=SetErrorMode(SEM_NoOpenFileErrorBox);
    Lib := LoadLibrary(DLLName);
    SetErrorMode(w);
    if Lib < 32 then
      begin
        Status := em_DLLNotFound
      end else
    TApplication.Init(AName);
end;

destructor TApp.Done;
begin
  TApplication.Done;
  FreeLibrary(Lib);
end;

procedure TApp.InitMainWindow;
begin
  MainWindow:=New(PDialog,Init(nil,MakeIntResource(301)));
end;

procedure TApp.Error(ErrorCode: Integer);
begin
  case ErrorCode of
    em_DLLNotFound:
      MessageBox(0,DLLName+' not found. Please compile SUPERED.PAS ' +
        'before executing this application.', 'Fatal error',
        mb_Ok or mb_IconStop);
  else
    TApplication.Error(ErrorCode);
  end;
end;

var App:TApp;

begin
  App.Init('Superclass demo');
  App.Run;
  App.Done;
end.
