{-----------------------------------------------------------------------------}
program TStrObj;                                         { Test MpStrObj Unit }
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------}

uses
  Crt,
  MpStrObj;

{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------}

Var
  aString                    : StringObject;
  pString                    : StringObjectPointer;

{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------}
procedure PauseIt;
begin

  GoToXY(1,25);
  Write(' Press ENTER to continue.');
  Readln;
  ClrScr;

end;
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------}
procedure Printit;
begin

  Writeln ( ' aString object is "',aString.Show,'"'^J^M' aString length is ', aString.Len,' bytes.',^J^M );

end;
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------}
begin

  ClrScr;
  Writeln('                                  Testing MpStrObj');
  Writeln;

  New (pString);
  pString^.Assign ( ' This is a dynamic string on the heap.');
  Writeln ( ' The value of the dynamic string on the heap is as follows:');
  Writeln ( pString^.Show );
  Writeln;

  aString.Assign('This is a string.');
  Writeln ( ' aString.Assign executed... ');
  PrintIt;

  aString.PadString ( 23 );
  Writeln( ' aString.PadStr ( 23 ); ');
  PrintIt;

  aString.InsertNewChars ( 10, ' nice' );
  Writeln ( ' aString.InsertNewChars ( 10, '' nice'' ); ');
  PrintIt;

  pString^.InsertNewChars ( 11, ' nice');
  Writeln ( ' The value of the dynamic string on the heap is as follows:');
  Writeln ( pString^.Show );
  Writeln;

  PauseIt;

  aString.DeleteChars ( 10, 5 );
  Writeln ( ' aString.DeleteChars ( 10, 5 ); ');
  PrintIt;

  aString.MakeUpperCase;
  Writeln ( ' aString.MakeUpperCase; ');
  PrintIt;

  aString.Assign ('     String w/leading spaces.');
  Writeln ( ' aString.Assign (''      String w/leading spaces.''); ');
  PrintIt;

  aString.StripLeadingSpaces;
  Writeln ( ' aString.StripLeadingSpaces; ');
  PrintIt;

  Writeln ( ' aString.CountOccurencesOfChar ( False, ''S'' ); ');
  Writeln(  ' The count is ', aString.CountOccurencesOfChar (False, 'S' ));
  PrintIt;

  PauseIt;
  aString.ReplaceAll ('w/leading', 'with leading' );
  Writeln ( ' aString.ReplaceAll (''w/leading'', ''with leading'' ); ');
  PrintIt;

  Writeln( ' Testing aString.PositionWhere method: ');
  Writeln( ' The word '' LEADING '' starts at ',aString.PositionWhere ( ' LEADING '), '.' );

  Writeln;
  Writeln(' Testing aString.ConstructStringOf ( ''-'', 40 ); ');
  aString.ConstructStringOf ( '-', 40 );
  PrintIt;

  Dispose ( pString );
  Writeln(' Got rid of dynamic string.');
  Writeln;

  aString.Assign('              ');
  Writeln(' aString initialized to ', aString.Len, ' spaces.');
  Writeln(' Executing aString.StripLeadingSpaces method. ');
  aString.StripLeadingSpaces;
  PrintIt;

  Writeln ( ' -*- -*- -*- END OF TEST -*- -*- -*- ');
  PauseIt;

end.
{-----------------------------------------------------------------------------}