{$A+,B-,D+,E+,F-,I-,L+,N-,O-,R-,S+,V+}
{$DEFINE TPRO5}

UNIT StrObj;

   {Linked list holds strings.}


INTERFACE {section}

USES
   {$IFDEF TPRO5}
       TpString,
   {$ENDIF}
   Objects;


TYPE
   StrObjectPtr = ^StrObject;
   StrObject
    = OBJECT(Node)
      TheStrPtr : POINTER;

      CONSTRUCTOR Init(NewStr : STRING);
      DESTRUCTOR  Done; VIRTUAL;

      FUNCTION  GetString : STRING;
      PROCEDURE ChangeString(NewStr : STRING);
      FUNCTION  SelfPtr : StrObjectPtr;
      END;


IMPLEMENTATION {section}


{$IFDEF TPRO5}
{============================================================================}
CONSTRUCTOR StrObject.Init(NewStr : STRING);

   {Initialize the StrObject.}

BEGIN {StrObject.Init}
TheStrPtr := StringToHeap(NewStr)
END; {StrObject.Init}
{============================================================================}
{$ELSE}
{============================================================================}
CONSTRUCTOR StrObject.Init(NewStr : STRING);

   {Initialize the StrObject.  ...I originally used SUCC(LENGTH(NewStr)) to
determine the size of the true string array, but I forgot that SUCC returns
a value of the same type as the variable you sent it.  That's bad news if you
try to put a 255-char string on the heap!  Think about it.}

VAR
   TrueStrSize : WORD;

BEGIN {StrObject.Init}
TrueStrSize := (LENGTH(NewStr) + 1); {must account for 0th byte!}

GETMEM({VAR} TheStrPtr,TrueStrSize);
MOVE(NewStr,TheStrPtr^,TrueStrSize)
END; {StrObject.Init}
{============================================================================}
{$ENDIF}

{$IFDEF TPRO5}
{============================================================================}
DESTRUCTOR  StrObject.Done;

   {De-initialize the StrObject.}

BEGIN {StrObject.Done}
DisposeString(TheStrPtr)
END; {StrObject.Done}
{============================================================================}
{$ELSE}
{============================================================================}
DESTRUCTOR  StrObject.Done;

   {De-initialize the StrObject.  See my comments in the Init routine!}

VAR
   TrueStrSize : WORD;

BEGIN {StrObject.Done}
TrueStrSize := (BYTE(TheStrPtr^) + 1);
FREEMEM(TheStrPtr,TrueStrSize)
END; {StrObject.Done}
{============================================================================}
{$ENDIF}

{$IFDEF TPRO5}
{============================================================================}
FUNCTION  StrObject.GetString : STRING;

   {Return the Str from the object.}

BEGIN {GetString}
GetString := StringFromHeap(TheStrPtr)
END; {GetString}
{============================================================================}
{$ELSE}
{============================================================================}
FUNCTION  StrObject.GetString : STRING;

   {Return the Str from the object.}

BEGIN {GetString}
GetString := STRING(TheStrPtr^)
END; {GetString}
{============================================================================}
{$ENDIF}

{$IFDEF TPRO5}
{============================================================================}
PROCEDURE StrObject.ChangeString(NewStr : STRING);

   {Changes the Str in the object to the NewStr.  This is much faster than
calling Done() and New().}

BEGIN {ChangeString}
DisposeString(TheStrPtr);
TheStrPtr := StringToHeap(NewStr)
END; {ChangeString}
{============================================================================}
{$ELSE}
{============================================================================}
PROCEDURE StrObject.ChangeString(NewStr : STRING);

   {Changes the Str in the object to the NewStr.}

BEGIN {ChangeString}
Done;
Init(NewStr)
END; {ChangeString}
{============================================================================}
{$ENDIF}

{============================================================================}
FUNCTION    StrObject.SelfPtr : StrObjectPtr;

   {Returns a pointer to this object.}

BEGIN {SelfPtr}
SelfPtr := @Self
END; {SelfPtr}
{============================================================================}


END. {StrObj}
