{ ========================================================================== }
{ Strg61b-.pas - String Processing Routines - Interface   ver 6.1b, 06-17-91 }
{                                                                            }
{ (Partial source code)                                                      }
{ These routines process strings, characters, and all types of numbers.      }
{ Several combinations of operations have been provided that are extremely   }
{ fast for case, classification, comparison, conversions, copy, count,       }
{ delete, format, justification, membership, parse, replace, search, sort,   }
{ tabbing, ASCIIZ, many with match/ignore case and many more - 111 routines. }
{  Copyright (C) 1989-1991 James H. LeMay                                    }
{ ========================================================================== }

{ For IEEE reals, set $N+.  For runtime selection of 80x87 and software,     }
{ also use $E+.  (Note that use of $E+ will link Turbo's 12k emulator lib if }
{ a procedure is called.)  These directives must also be reflected in the    }
{ main program as well.  This is so you can test everything in the unit.     }

{$A-,D-,E+,I-,L-,N+,R-,S-,V-}   { For IEEE }

{ If you have the source code and have SYS60.TPU or later, set the following }
{ conditional define by deleting the space in front of the '$'.  It will     }
{ then ignore the substitute routines for Delete, Copy, and Pos which are    }
{ duplicates. }

{ $Define SysTpu      }
{^ delete this space. }


UNIT Strg;

INTERFACE

var
  AscSrcPtr:          pointer;    { For StrAsc  }
  AscDestPtr:         pointer;    { For AscStr  }
  LnSrcPtr:           pointer;    { For StrLn   }
  LnDestPtr:          pointer;    { For LnStr   }
  CmpIndex1:          integer;    { For StrCmp  }
  CmpIndex2:          integer;    { For StrCmp  }
  ReplIndex,ReplToDo: byte;       { For StrRepl }
  ReplOverFlow:       boolean;    { For StrRepl }


{ -- String Operations (5) -- }

procedure StrUpr  (VAR S: string);
procedure StrLwr  (VAR S: string);
procedure StrRev  (VAR S: string);
procedure StrSort (VAR S: string);
procedure StrRoll (VAR S: string; Count: integer);


{ -- String Insert/Delete (8) -- }

procedure StrIns  (VAR Dest: string; S: string; DestIndex,MaxLen: byte);
procedure ChrPadC (VAR S: string; Fill: char; Field: byte);
procedure ChrPadL (VAR S: string; Fill: char; Field: byte);
procedure ChrPadR (VAR S: string; Fill: char; Field: byte);
procedure ChrDel  (VAR S: string; Find: char);
procedure ChrDelL (VAR S: string; Find: char);
procedure ChrDelR (VAR S: string; Find: char);
procedure StrCut  (VAR S: string; MaxLen: byte);


{ -- String Placement (7) -- }

procedure StrCat  (VAR Dest: string; S: string; MaxLen: byte);
procedure StrCatX (VAR Dest: string; S: string; indeX,Count,MaxLen: byte);
procedure StrCopy (VAR Dest: string; S: string; Index,Count: byte);
procedure StrOvr  (VAR Dest: string; S: string; DestIndex: byte);
procedure StrMove (VAR Dest: string; S: string);
procedure StrPoke (VAR Dest; S: string);
procedure StrPeek (VAR Dest: string; VAR Source; Count: byte);


{ -- String Pattern (3) -- }

procedure StrFill (VAR S: string; Fill: string; Count,MaxLen: byte);
procedure ChrFill (VAR S: string; Fill: char;   Count: byte);
procedure StrEnum (VAR S: string; First,Last: char);


{ -- String Position (12) -- }

function  StrPosL  (S,Find: string; Nth: byte):          byte;
function  StrPosLI (S,Find: string; Nth: byte):          byte;
function  StrPosR  (S,Find: string; Nth: byte):          byte;
function  StrPosRI (S,Find: string; Nth: byte):          byte;
function  StrPosX  (S,Find: string; indeX: byte):        byte;
function  StrPosXI (S,Find: string; indeX: byte):        byte;

function  ChrPosL  (S: string; Find: char; Nth: byte):   byte;
function  ChrPosLI (S: string; Find: char; Nth: byte):   byte;
function  ChrPosR  (S: string; Find: char; Nth: byte):   byte;
function  ChrPosRI (S: string; Find: char; Nth: byte):   byte;
function  ChrPosX  (S: string; Find: char; indeX: byte): byte;
function  ChrPosXI (S: string; Find: char; indeX: byte): byte;


{ -- String Count (4) -- }

function  StrQty   (S,Find: string):        byte;
function  StrQtyI  (S,Find: string):        byte;
function  ChrQty   (S: string; Find: char): byte;
function  ChrQtyI  (S: string; Find: char): byte;


{ -- String Comparison (2) -- }

function  StrCmp   (S1,S2: string; Index1,Index2,MaxLen: byte): shortint;
function  StrCmpI  (S1,S2: string; Index1,Index2,MaxLen: byte): shortint;


{ -- String Find and Replace Operations (4) -- }

procedure ChrRepl  (VAR S: string; Find,Repl: char; Index,Qty: byte);
procedure ChrReplI (VAR S: string; Find,Repl: char; Index,Qty: byte);
procedure StrRepl  (VAR S: string; Find,Repl: string; Index,Qty,MaxLen: byte);
procedure StrReplI (VAR S: string; Find,Repl: string; Index,Qty,MaxLen: byte);


{ -- String Member/Non-member (3) -- }

function  StrBrk   (S,Breaks:  string; Index: byte): byte;
function  StrSpn   (S,Members: string; Index: byte): byte;
procedure StrMemb  (VAR Dest: string; S: string);


{ -- String Parsing routines (11) -- }

function  WrdQty   (S: string):              byte;
function  WrdPosL  (S: string; Nth: byte):   byte;
function  WrdPosR  (S: string; Nth: byte):   byte;
function  WrdPosLX (S: string; indeX: byte): byte;
function  WrdPosRX (S: string; indeX: byte): byte;
procedure WrdL     (VAR Dest: string; S: string; Nth: byte);
procedure WrdR     (VAR Dest: string; S: string; Nth: byte);
procedure WrdLX    (VAR Dest: string; S: string; indeX: byte);
procedure WrdRX    (VAR Dest: string; S: string; indeX: byte);
procedure WrdToken (VAR Dest: string; S,Delims: string; VAR Index: byte);
procedure WrdParse (VAR Dest: string; S,Delims: string; VAR Index: byte);


{ -- String Conversions (10) -- }

function  StrHex (Num: longint; Field: byte):    string;
function  StrBin (Num: longint; Field: byte):    string;
function  ValBin (S: string; VAR Code: integer): longint;
function  ValHex (S: string; VAR Code: integer): longint;

procedure StrDeTab (VAR Dest: string; S: string; TabSpaces: byte);
procedure StrReTab (VAR Dest: string; S: string; TabSpaces: byte);

procedure AscStr (VAR AscDest; S: string);
procedure LnStr  (VAR LnDest;  S: string);
procedure StrAsc (VAR Dest: string; VAR AscSrc; MaxLen: byte);
procedure StrLn  (VAR Dest: string; VAR LnSrc;  MaxLen: byte);


{ -- Automatic and FASTER replacement for Pascal standard routines (3) -- }

{$ifndef SysTpu }
procedure Delete (VAR S: string; Index,Count: integer);
function  Copy   (    S: string; Index,Count: integer): string;
function  Pos    (Find,S: string): byte;
{$endif }


{ -- String Justification (3) -- }

function  StrJL  (S: string; Field: byte): string;
function  StrJC  (S: string; Field: byte): string;
function  StrJR  (S: string; Field: byte): string;


{ ** Function forms of the standard STR procedure ** }
{ -- String Formatting (17) -- }

function  StrL   (L: longint):                       string;
function  StrLF  (L: longint; Field: integer):       string;
function  StrR   (R: real):                          string;
function  StrRF  (R: real; Field: integer):          string;
function  StrRFD (R: real; Field,Decimals: integer): string;


{ -- IEEE reals -- }

{$ifopt N+ }
function  StrS   (S: single):                            string;
function  StrSF  (S: single; Field: integer):            string;
function  StrSFD (S: single; Field,Decimals: integer):   string;
function  StrD   (D: double):                            string;
function  StrDF  (D: double; Field: integer):            string;
function  StrDFD (D: double; Field,Decimals: integer):   string;
function  StrE   (E: extended):                          string;
function  StrEF  (E: extended; Field: integer):          string;
function  StrEFD (E: extended; Field,Decimals: integer): string;
function  StrC   (C: comp):                              string;
function  StrCF  (C: comp; Field: integer):              string;
function  StrCFD (C: comp; Field,Decimals: integer):     string;
{$endif N+ }


{ -- Character case functions. (2) -- }

function  LoCase (C: char): char;
function  UpCase (C: char): char;


{ -- Character classification functions. (17) -- }

function  IsAlNum  (C: char): boolean;
function  IsAlpha  (C: char): boolean;
function  IsASCII  (C: char): boolean;
function  IsCntrl  (C: char): boolean;
function  IsDigit  (C: char): boolean;
function  IsDos    (C: char): boolean;
function  IsFile   (C: char): boolean;
function  IsGraph  (C: char): boolean;
function  IsLower  (C: char): boolean;
function  IsPath   (C: char): boolean;
function  IsPrint  (C: char): boolean;
function  IsPunct  (C: char): boolean;
function  IsReal   (C: char): boolean;
function  IsSigned (C: char): boolean;
function  IsSpace  (C: char): boolean;
function  IsUpper  (C: char): boolean;
function  IsXDigit (C: char): boolean;


{ 90 unique / 111 total routines }


IMPLEMENTATION
 {...}
END.
