program SL_Test3; {demonstrate use of multiple rows status line}
uses
  OpCrt,
  StatLine,
  OpMacro,
  OpString,
  OpKey,
  OpMouse;

   var
     SL : StatusLine;
     W  : word;
     S  : String;
     Special : boolean;

   const
     FA : FlexAttrs = ($17,$1f,$1e,$70);

  function SampleReadKey    : Word;
  { return value of key pressed }
  var
    Count : Word;
    LastX,
    LastY : byte;
  begin
    While not KeyOrButtonPressed do;
    if MouseButtonPressed(LeftButton,Count,LastX,LastY) then
      SampleReadKey := SL.GetKey(LastY,LastX,ReadkeyOrButton)
    else
      SampleReadKey := ReadKeyOrButton;
  end; {SampleReadKey}

begin
    if not MouseInstalled then exit;
    TextAttr := $20;
    clrscr;
    if not SL.Init(ScreenHeight-2,ScreenHeight,FA) then exit;

    with SL do
     if AddTopic(^A'F1'^A'-Help ',F1) and
       AddTopic(^A'F2'^A'-File ',F2) and
       AddTopic(^A'F3'^A'-Browse ',F3) and
       AddTopic(^A'F4'^A'-Shell ',F4) and
       AddTopic(^A'F5'^A'-Zoom Win ',F5) and
       AddTopic(^A'F6'^A'-Next Window ',F6) and
       AddTopic(^A'ShF6'^A'-Previous Win ',ShF6) and
       AddTopic(^A'F7'^A'-Begin Block ',F7) and
       AddTopic(^A'F8'^A'-End Block ',F8) and
       AddTopic(^A'F9'^A'-Compile ',F9) and
       AddTopic(^A'F10'^A'-Menu ',F10) and
       AddTopic(^A'CtrlF1'^A'-Topic Help ',CtrlF1) and
       AddTopic(^A'CtrlF2'^A'-Resume  ',CtrlF2) and
       AddTopic(^A'Alt1'^A'-Macro 1 ',Alt1) and
       AddTopic(^A'Alt2'^A'-Macro 2 ',Alt2) and
       AddTopic(^A'Alt3'^A'-Macro 3 ',Alt3) and
       AddTopic(^A'Alt4'^A'-Macro 4 ',Alt4) and
       AddTopic(^A'AltX'^A'-Exit ',AltX ) and
       AddTopic(^A'*'^A'-ESC ',Esc) and
       AddTopic(^A'E'^A'nter ',Enter) then begin

     Draw;
     EnableEventHandling;
     ShowMouse;
     FastCenter('Click on Status line to test - ESC to quit',10,$71);
     repeat
       W := SampleReadKey;
       KeyToString(W,S,Special);
       FastCenter(center(s,20),1,$02);
     until W = ESC;
     HideMouse;
     Hide;
     Done;
  end;
  TextAttr := $17;
  clrscr;
end.
