 program StatusDialogDemo;  {posted by Steve Schafer on BPascal forum}
                            {code for TP6; to convert to BP7 or TP7, }
                            {follow instructions in the code below.  }
 uses
   Crt,Objects,Drivers,Views,Dialogs,App;

 type
   PDemo = ^TDemo;
   TDemo = object (TApplication)
     constructor Init;
     end;

   PStatusDialog = ^TStatusDialog;
   TStatusDialog = object (TDialog)
     Message,Value: PStaticText;
     constructor Init;
     procedure Update (Status: Word; AValue: Word); virtual;
     end;

 constructor TDemo.Init;

 var
   D: PStatusDialog;
   I: Integer;
   E: TEvent;

 begin
 TApplication.Init; {for BP7 or TP7, use Inherited Init}
 D := New (PStatusDialog,Init);
 Desktop^.Insert (D);
 for I := 1 to 10 do
   begin
   D^.Update (cmValid,I * 10);
   if CtrlBreakHit then
     begin
     CtrlBreakHit := False;
     GetEvent (E);  { eat the Ctrl-Break }
     D^.Update (cmCancel,I * 10);
     repeat GetEvent (E) until (E.What = evKeyDown)
       or (E.What = evMouseDown);
     Desktop^.Delete (D);
     Dispose (D,Done);
     Exit;
     end;
   Delay (1000);  { simulate processing }
   end;
 D^.Update (cmOK,100);
 repeat GetEvent (E) until (E.What = evKeyDown)
   or (E.What = evMouseDown);
 Desktop^.Delete (D);
 Dispose (D,Done);
 end;

 constructor TStatusDialog.Init;

 var
   R: TRect;

 begin
 R.Assign (20,6,60,12);
 TDialog.Init(R,'Processing...');  {for BP7 or TP7, use Inherited Init}
 Flags := Flags and not wfClose;
 R.Assign (10,2,30,3);
 Insert (New (PStaticText,Init (R,'Completed record xxx')));
 R.Assign (27,2,30,3);
 Value := New (PStaticText,Init (R,'  0'));
 Insert (Value);
 R.Assign (2,4,38,5);
 Message := New (PStaticText,Init (R,
   '     Press Ctrl-Break to cancel     '));
 Insert (Message);
 end;

 procedure TStatusDialog.Update (Status: Word; AValue: Word);

 var
   ValStr: String[3];

 begin
 case Status of
   cmCancel: begin
     DisposeStr (Message^.Text);
     Message^.Text := NewStr ('     Cancelled - press any key      ');
     Message^.DrawView;
     end;
   cmOK: begin
     DisposeStr (Message^.Text);
     Message^.Text := NewStr ('     Completed - press any key      ');
     Message^.DrawView;
     end;
   end;
 Str (AValue:3,ValStr);
 DisposeStr (Value^.Text);
 Value^.Text := NewStr (ValStr);
 Value^.DrawView;
 end;

 var
   Demo: TDemo;

 begin
 Demo.Init;
 Demo.Run;
 Demo.Done;
 end.
