program time_demo;

uses
   crt,stat;
const
     num12 = 12;                       { number of data points }
     num7  = 5;
var
   x,auto  : single_array_pointer;     { point to dynamic arrays }
   j       : word;
   r,se    : single;
   mean,
   small,y_est,
   large,diff,
   sd      : single;

begin
{ create dynamic arrays}
     create_single_array(num12,x);   { create x dynamic array }
     create_single_array(num7,auto); { create auto correlation dynamic array }

{ put data into the arrays}
     x^[1] := 60.0;
     x^[2] := 60.0;
     x^[3] := 90.0;
     x^[4] := 120.0;
     x^[5] := 140.0;
     x^[6] := 130.0;
     x^[7] := 135.0;
     x^[8] := 150.0;
     x^[9] := 145.0;
     x^[10] := 170.0;
     x^[11] := 185.0;
     x^[12] := 160.0;

{ clear screen and print header}
     clrscr;
     writeln('            mean        sd     small    large     time series example');
     writeln('           ------     ------   ------   ------');
{ get some stats }
     elem_stat(num12,x,small,large,mean,sd);
     writeln('x data',mean:10:2,sd:10:2,small:10:2,large:10:2);
{ remove the average from data }
     remove_avg(num12,x,mean);
{ get more stats }
     elem_stat(num12,x,small,large,mean,sd);
     writeln('x data',mean:10:2,sd:10:2,small:10:2,large:10:2);
{ auto correlate the data }
     autocor(num12,x,num7,auto);
     for j := 1 to num7 do
         writeln('lag ',(j-1):3,auto^[j]:10:3);
{ moving average data }
     for j := 1 to num12 do
          writeln(movavg(num12,x,2,j):10:3,x^[j]:10:3);
end.