{$A+,B-,D-,E-,F+,I+,L-,N-,O-,R-,S-,V+}
{$M 16384,0,655360}
Program SpyBoot;
{ SPYBOOT Network Remote Opertaions.  Order SPYTSR to reboot.
  This program is:
  Copyright (c) 1989 by Edwin T. Floyd
  All rights reserved

  Noncommercial use encouraged; direct commercial inquires and problem reports
  to the author:

  Edwin T. Floyd [76067,747]
  #9 Adams Park Court
  Columbus, GA 31909
  404-322-0076 (home)
  404-576-3305 (work)
}
Uses Multi, NetBios, SpySup;

Var
  Adapter : Byte;
  SpyLsn : Byte;
  SessionUp : Boolean;
  MyName : NetNameType;
  CallName : NetNameType;

Procedure SendBootRequest;
Var
  BootReq : RequestType;
  BootNct : TaskNctType;
  Err : Byte;
Begin
  With BootNct, BootReq Do Begin
    NetSetAdapter(Nct, Adapter, NetNoWait, NetTaskPost);
    Count := 0;
    Req := Boot;
    NetSend(Nct, SpyLsn, BootReq, SizeOf(BootReq) - SizeOf(Key));
    Err := NetWaitError(BootNct, 2000);
    If Err = 0 Then
      WriteLn('SPYTSR ordered to reboot: ', Copy(CallName, 1, 15))
    Else Begin
      WriteLn('Unable to send boot request ', Err);
      If NetReturnAction(Nct) = SessionDead Then
        SessionUp := False;
    End;
    NetShutdown;
    If SessionUp Then Begin
      NetHangup(Nct, SpyLsn);
      Err := NetWaitError(BootNct, 500);
    End;
  End;
  NetShutdown;
  WriteLn('SPYBoot Terminated');
  StopAll(0);
End;

Procedure InitSpyBoot;
Var
  i, j : Integer;
  NameNct : TaskNctType;
  Status : NetAdapterStatusType;
  Err : Byte;
  s : String[2];
Begin
  SessionUp := False;
  If (ParamCount < 1) Or (ParamStr(1) = '') Then Begin
    WriteLn('Run like this: SPYBOOT <name>');
    StopAll(1);
  End Else Begin
    CallName := ParamStr(1);
    For i := 1 To Length(CallName) Do CallName[i] := UpCase(CallName[i]);
    While Length(CallName) < 16 Do
      Insert(' ', CallName, Succ(Length(CallName)));
    CallName[16] := #$EF;
  End;
  If ParamCount > 1 Then Begin
    s := ParamStr(2);
    Val(s, i, j);
    If (i >= 0) And (i < 3) Then Adapter := i Else Begin
      WriteLn('Adapter must be 0..3, "', ParamStr(2), '" specified');
      StopAll(2);
    End;
  End Else Adapter := 0;
  If Not NetAdapterPresent(Adapter) Then Begin
    WriteLn('Adapter ', Adapter, ' not found');
    StopAll(3);
  End;
  With NameNct Do Begin
    NetSetAdapter(Nct, Adapter, NetNoWait, NetTaskPost);
    WriteLn('Getting Unit Name for adapter ', Adapter);
    NetAdapterStatus(Nct, Status, '*');
    Err := NetWaitError(NameNct, 1000);
    If Err <> 0 Then Begin
      WriteLn('Unable to acquire local adapter Unit Name, error ', Err);
      StopAll(4);
    End Else Begin
      MyName[0] := #16;
      FillChar(MyName[1], 10, 0);
      Move(Status.UnitId, MyName[11], 6);
    End;
    WriteLn('Calling ', Copy(CallName, 1, 15));
    NetCall(Nct, CallName, MyName, CallRto, CallSto);
    Err := NetWaitError(NameNct, 1000);
    If Err <> 0 Then Begin
      WriteLn('Unable to connect to ', Copy(CallName, 1, 15),
        ', error ', Err);
      StopAll(5);
    End;
    SpyLsn := NetLsn(Nct);
    SessionUp := True;
  End;
  WriteLn('Connected to ', Copy(CallName, 1, 15));
End;

Begin
  WriteLn('SPYBOOT Version 1.3 Starting');
  InitSpyBoot;
  SendBootRequest;
End.