{$A+,B-,D-,E-,F+,I-,L-,N-,O-,R-,S-,V+}
Unit MultiTsr;
{ This unit links the TSR and MULTI units.  }
Interface Uses TSR, MULTI;
Const
  MaxTicksToWait = 1200;  { Maximum number of ticks to wait in IdleRoutine }

Implementation
Var
  OldDispatchHook : HookRoutineType;
  SmallWaitCount : Byte;

Procedure TsrIdle(Timeout : LongInt);
Begin
  If Timeout < 7 Then Begin
    If Timeout < SmallWaitCount Then Dec(SmallWaitCount, Timeout)
    Else Begin
      SmallWaitCount := 6;
      TsrWait(1);
    End;
  End Else Begin
    Timeout := Timeout Div 6;
    If Timeout > MaxTicksToWait Then Timeout := MaxTicksToWait;
    TsrWait(Timeout);
  End;
End;

Procedure WakeHook(Task : TaskType; Entry : DispatchHookType);
Begin
  If Entry = HookWake Then WakeBackground;
  OldDispatchHook(Task, Entry);
End;

Procedure MultiTsrExit;
Begin
  RemoveTSR;
End;

Begin
  SmallWaitCount := 6;
  IdleRoutine := TsrIdle;
  OldDispatchHook := DispatchHook;
  DispatchHook := WakeHook;
  ExitProc := @MultiTsrExit;
End.