
                                                        3/5/89

        SORT -- merge and sort multiple files, by J. W. Rider

        SYNTAX:

              SORT [options] [<unsorted-file-spec> ... ]

        DESCRIPTION:

                This utility is intended to replace the SORT
        function that comes with MS-DOS.  The command syntax is
        upward compatible with the MS-DOS SORT.  In addition,
        this SORT is capable of ignoring the case of alphabetic
        characters, sorting numerically, and sorting files too
        large to be sorted by the MS-DOS SORT.

                Options can be preceded by either "/" (MS-DOS
        standard) or "-" (UNIX standard).  Available options
        include the following two options that are syntax
        compatible with the MSDOS version:

                R  -- reverses the sense of the sort.

                +# -- sorts each line based upon characters
                      beginning in column #.

        The following additional options are available:

                +# -- a second number denotes the last column of
                      the key field.  The "+" character for
                      either the first or second number is
                      optional.

                B  -- ignore leading blanks in field.

                C  -- ignore case (i.e., "a" = "A" ).

                D  -- ignore non-alphanumerics in comparisons.

                F  -- use "awk" fields instead of columns in
                      determining key.

                H  -- display a help message instead of sorting
                      input.

                K  -- output only the sort keys, not the whole
                      line (useful for determining what you are
                      actually sorting against).

                N  -- sort lines numerically instead of
                      alphabetically.

                Tc -- Use the character 'c' instead of tabs or
                      spaces to delimit fields when '/F' is
                      effective.  Multiple '/Tc' options can
                      be used.  If you want to include spaces and
                      tabs as field delimiters, use '/T ' with
                      a blank after the switch. (This has the
                      effect of making each individual space or
                      tab define a new field.  Two spaces

              Copyright 1988, 1989, by J. W. Rider





        SORT                      2                     SORT

                      together would define a null field between
                      them.)

                U  -- eliminate multiple copies of identical
                      lines.

                If the "unsorted-file-spec" name is missing or is
        "-" then lines are read from standard input.

                Sorted lines are written to standard output.
        This is redirectable under DOS.

                Some files are too large to be sorted in memory
        at one time.  In this case, SORT provides a partial
        ordering that can be improved with subsequent SORT
        efforts.  Here is an example of a "two-stage" sort:

           C>SORT BIGFILE | SORT >BIGSORT
           SORT: Output may not be completely sorted.

        (The warning comes from the first stage of the sort.  The
        lack of a second warning indicates that the output was
        correctly sorted in the second stage.)

        On a relatively slow machine with available memory
        limited to 200K bytes, a two-stage sort was able to
        completely order a 300K byte file in about 10 minutes.
        When memory was freed to 450K, the same file was sorted
        in a single stage in about five minutes.

        EXAMPLES:

        To sort the contents of "file1" and put the sorted lines
        into "file2":

                        SORT file1 >file2

        To merge the contents of two files sorted on the second
        comma-delimited field:

              SORT -f -t, -2 -3 file1 file2 >file3

        To combine all basic program files in the current
        directory, maintaining line number order:

                     SORT -n *.bas >outfile

        Classically, SORT has been used to reorder the display of
        directory filenames (DIR).  This is accomplished by:

                           DIR | SORT

        To sort the directory on the first letter of the
        extension, use:

                         DIR | SORT -10


              Copyright 1988, 1989, by J. W. Rider





        SORT                      3                     SORT

        To sort the directory on the size of the file:

                         DIR | SORT -13

        To sort the directory on the minute that each file was
        lasted changed:

                      DIR | SORT -f -t: -2

        BUGS:
                Attempting to overwrite an input file with the
        sorted lines may destroy your data.  Do not use "SORT a b
        >a" or "SORT a b >b".

                Sorting numerically against lines that do not
        contain numbers may yield unexpected results.

                Sorting numerically is limited to values that can
        be expressed as "real" data types within the context of
        the Borland Turbo Pascal (version 5) compiler.

                The original order of lines with the same key
        may not be preserved.  This may have some impact on the
        ability of SORT to find a previous copy of a line in the
        sorting process.

                While this "SORT" is syntax compatible with
        MS-DOS, it is not compatible with an earlier version
        where the output file could be named on the command line
        with the input files.  No data will be lost because of
        the confusion.  However, sorted data will not be saved
        where you expect it to be saved.


























              Copyright 1988, 1989, by J. W. Rider

