(* ---------------------------------- *)
(* StrIO                              *)
(* Copyright (c) 1994 by Dado Colussi *)
(* All rights reserved                *)
(* ---------------------------------- *)


UNIT StrIO;


INTERFACE


FUNCTION  Strip(str : String) : String;
PROCEDURE UpStr(VAR str : String);
FUNCTION  LowCase(ch : Char) : Char;
PROCEDURE LowStr(VAR str : String);
FUNCTION  Int2Str(i : Longint) : String;
FUNCTION  Str2Int(str : String) : Longint;


IMPLEMENTATION


USES

  Keyboard;


(*
  Removes sapce (ASCII 32) characters from the beginning and the end of
  the string.
*)
FUNCTION Strip(str : String) : String;
BEGIN
  WHILE (str[0] <> NUL) AND (str[1] = SP) DO
    Delete(str, 1, 1);
  WHILE (str[0] <> NUL) AND (str[Byte(str[0])] = SP) DO
    Delete(str, Byte(str[0]), 1);
  Strip := str;
END; (* Strip *)

PROCEDURE UpStr(VAR str : String);
VAR
  i     : Byte;

BEGIN
  FOR i := 1 TO Byte(str[0]) DO
    str[i] := UpCase(str[i]);
END; (* UpStr *)

FUNCTION LowCase(ch : Char) : CHAR;
BEGIN
  (*
    Characters used in Scandinavia must be interpreted correctly!
  *)
  CASE Ch OF
    '[' : LowCase := '{';       (* A" -> a" *)
    ']' : LowCase := '}';       (* A' -> a' *)
    '\' : LowCase := '|';       (* O" -> o" *)
    'A'..'Z' : LowCase := Char(Byte(ch) + 32);
  ELSE
    LowCase := ch;
  END; (* CASE Statement *)
END; (* LowCase *)

PROCEDURE LowStr(VAR str : String);
VAR
  i     : Byte;

BEGIN
  FOR i := 1 TO Byte(str[0]) DO
    str[i] := LowCase(str[i]);
END; (* LowStr *)

(*
  Converts an integer number to its string representation
*)
FUNCTION Int2Str(i : Longint) : String;
VAR
  tmp   : String;

BEGIN
  Str(i, tmp);
  Int2Str := tmp;
END; (* Int2Str *)

(*
  Converts the string value to its numeric representation
*)
FUNCTION  Str2Int(str : String) : Longint;
VAR
  value         : Longint;
  error_code    : Integer;

BEGIN
  Val(str, value, error_code);
  IF error_code <> 0 THEN
    value := 0;
  Str2Int := value;
END; (* Str2Int *)

END. (* StrIO *)

