PROGRAM SeeMem;

 {$M 24756,0,655360}

 Uses Dos;

 {
  Version 2.00 - December 17, 1991
  SeeMem displays a Memory Map of all resident programs,
   device drivers, environment blocks, and other resident data.

  Usage:  SEEMEM  [/n] [/?]  to show all Memory Control Blocks (MCBs)

  Author: Rick Housh
          5811 W. 85th Terrace
          Overland Park, KS 66207
          Compuserve 72466,212
          GEnie R.HOUSH

   Language: Turbo Pascal 6.0

   History
   10/18/91  -  Beta version 1.00B released to public domain
   10/24/91  -  Fixed logic flaw in error detection in use of Proc
                  QueryFreeMemXMS - XMSerrors $A0 and $A1
                  are result codes, not real errors.
             -  Fixed minor bug in display where exactly one screenfull
                  for Conventional and Upper memory.  Rearranged
                  output - placed "NO EMS" and "NO XMS" messages on
                  last page of display.
             -  Assigned new minor version number - 1.01B
   11/02/91  -  Added display of standard extended memory amount
                  total/used/remaining and XMS extended memory amount
                  total/used/remaining/largestblock
             -  Fixed minor problem displaying XMS error returns
             -  Fixed minor problem checking for link of UMB to Conventional
                  and DOS = UMB in CONFIG.SYS
             -  Patched executable to work with more than 640k
             -  Assigned new minor version number - 1.02B
   11/21/91  -  Added summary display of location of command shell
             -  Changed detection of location of DOS=High to location
                  of current disk buffer where possible; If running
                  under DOS 5.xx DOS furnished DOS location
             -  Added support for DR-DOS 6.0 (Signs on as DOS 3.31)
             -  Changed algorithm to detect whether UMB's are linked
                  through pointers to Conventional memory (CNV link)
                  MS-DOS and DR-DOS and QuarterDeck patch top of
                  memory one segment lower than before installation,
                  with the resulting MCB having a 'Z' ID byte, and
                  pointing to MCB controlling UMB's (I think).
             -  Added support for 4DOS command shell
                  (May work for Norton Utility's NDOS?)
             -  Added detection of location of command shell
                  i.e. Conventional Memory, UMB, HMA, and
                  display of command shell name, where possible
             -  Added automatic detection of output redirection, and
                  force page breaking off if redirected to anything other
                  than standard output
             -  Assigned new version number - 1.50
   12/17/91  -  Added additional support for DR-DOS 6.0 and 4DOS 4.0
             -  Detects additional DR-DOS UMB owner segments
                  8 = DOS configuration
                  7 = Reserved from UMB pool for video, etc.
                  6 = Used by UMB Device Driver (not DOS)
             -  Detects and displays locality of DOS (Conventional or HMA)
                  and SHELL (Conventional or UMB)
             -  Detects and displays free XMS handles, XMS and UMB memory
                  as Total-Used-Available-Largest Available Block
             -  Detects and displays UMB usage as Reserved-HiLoaded-
                  System Loaded and Self-Loaded (Program loads itself high)
             -  Added automatic command line redirection detection, and
                  automatic shift to non-pause mode when redirected to
                  other than CON device
             -  Assigned new version number - 2.00

 }


TYPE
  String3    = String [3];
  HexStr4    = String [4];
  TypeBlock  = String [9];
  String80   = String [80];
  IDChars    = SET OF Byte;
  DoubleWord = Array[0..1] of Word;
  NopeYep    = Array[False..True] of String3;

  TxtRec =
   RECORD
     Handle    : Word;              { We don't need the full DOS.TPU rec }
     Mode      : Word;              { Just these two, for raw - cooked }
   END;

  UMBSegStruc =
   RECORD
     UMBSeg    : Word;
     UMBSize   : Word
   END;

  MCBStruc =
    RECORD
      IDchar   : Byte;                 {'M' ($4D) or 'Z' ($5A)}
      OwnerSeg : Word;                 {0=available,8=DOS else real owner}
      Size     : Word;                 {16-byte pgphs, excluding this one}
      Misc     : ARRAY [1..3] OF Byte; {unused by SeeMem }
      ProgName : ARRAY [1..8] OF Char  {only furnished by DOS > 3}
    END;

  PSPStruc =
    RECORD
      StopCode    : Word;                     { INT 20h or 27h $CD20/$CD27}
      Misc        : ARRAY [3..$16] OF Byte;   { Unused by SeeMem }
      ParentTag   : Word;                     { Reserved by SeeMem }
      Stuff       : ARRAY [$19..$2C] OF Byte; { Unused by SeeMem }
      Environment : Word
    END;


CONST
  Space = #32;
  CR    = #13;
  LF    = #10;
  Tab   =  #9;
  BS    =  #8;
  NewLine = #13#10;
  PrgNameStr        = 'SeeMem';
  PrgDateStr        = 'Dec 1991';
  PrgVerStr         = '2.00';
  NoOrYes           : NopeYep   = (' NO','YES');
  M_or_Z            : IDChars = [$4D, $5A];
  DosName           : TypeBlock = '[MS-DOS] ';
  CmdPrgName        : String[9] = '[COMMAND]';

VAR
  Ch                         : Char;
  MemSegStr                  : HexStr4;
  PreviewStr                 : String80;
  CmdStr                     : PathStr;
  DosVerStr                  : String;
  CookMode, DosMinorVer,
  LineNum, DosVerNum,
  XMSerror, DosLocus,
  _4DOSLevel,
  ByteCounter, HandleCount   : Byte;
  TotalExtMem,XMSAvail,
  nonXMSExtendMem, HMAUsed,
  PageFrame, Cols, Rows,
  OurEnvSize, MasterPSP,
  FirstMCB, SecondMCB,
  Segment, TempSeg,
  MaxXMSMem, TableOfs,
  TableSeg, TopCnvMem,
  DosLoadSeg, XMSResult,
  XMSVersion, XMSRevision,
  _4DosVer, _4DosPSP,
  XMSFreeHandles,
  XMSLargest, ShellPSP        : Word;
  UMBLargest, UMBTotFree,
  UMBTotal, UMBResUse,
  UMBDevUse, UMBSysUse,
  Lowermax, TmpLongInt        : LongInt;
  isXMS, isHMA, isUMB,
  isEMS, isUMBdriver, isAT,
  UMBlinked, isUMBDOS,
  isDRDOS,  is4Dos,
  isRedirected,
  Finished, Upper, Paging     : Boolean;
  ThisMCB                     : ^MCBStruc;
  UMBstruct                   : UMBSegStruc;
  XMM_Control                 : DoubleWord;
  OutputRec,
  ConRec                      : ^TxtRec;

FUNCTION ExistXMS : Boolean; assembler;
    asm
         xor     cx,cx                          { Use cx for ret value }
         mov     ax,4300h                       { DOS test for XMS func }
         int     2Fh                            { Through multiplex int }
         cmp     al,80h                         { $80 means DOES exist  }
         jne     @1                             { So, exit - cx = 0 }
         mov     ax,4310h                       { Else get Vector w/DOS }
         int     2Fh                            { Through multiplex INT }
         mov     Word Ptr [XMM_Control],bx      { Offset in BX }
         mov     Word Ptr [XMM_Control + 2],es  { Seg in ES }
         inc     cx                             { cx = 1 = True }
    @1:  xchg    ax,cx                          { Put cx in ax for return }
    end; { asm }
   { Function ExistXMS }


PROCEDURE UMBalloc640k; assembler;
    asm
         xor     dx,dx              { Use dx to zero out things }
         mov     XMSResult,dx       { Default Failure        }
         mov     XMSError,80h       { Default not implemented}
         cmp     isXMS,dl           { If NO XMSdriver won't work }
         jz      @1                 { so exit }
         dec     dx                 { else, attempt alloc 0FFFFh }
         mov     ax,1000h           { impossible large block of UMB's }
         Call    [XMM_Control]      { through driver }
         mov     XMSResult,ax       { set Result }
         mov     XMSError,bl        { and Error  }
    @1:
    end; { asm }
  { Procedure UMBalloc640k }


FUNCTION ExistUMBdriver : Boolean; assembler;
    asm
         xor     ax,ax              { Default to False }
         cmp     isXMS,al           { If NO XMS driver }
         jz      @1                 { just exit }
         call    UMBalloc640k       { else test for UMB Driver }
         cmp     XMSError,80h       { Is it implemented? }
         jz      @1                 { If not just exit }
         mov     ax,1               { Else Return True }
    @1:
    end;
   { Function ExistUMBdriver }


FUNCTION ExistUMBmem : Boolean; assembler;
{ Attempts to allocate an impossibly large UMB.  On failure ax     }
{ contains 0, bl indicates UMB's unimplemented if $80, or $bx      }
{ on other error.  No provision made for success here. Impossible  }
{ to succeed.  Note that the UMB manager doesn't necessarily depend}
{ on existence of XMS manager, but if there is no control call     }
{ vector there is no way to call this UMB function.                }
    asm
         xor     cx,cx              { Default to False }
         cmp     isXMS,cl           { If NO XMS driver }
         jz      @1                 { then exit }
         call    UMBalloc640k       { else test for UMB driver, if Driver }
         cmp     XMSError,0AEh      { BUT all UMB's used up }
         jb      @1                 { then exit, else }
         mov     cx,1               { return True }
    @1:  xchg    ax,cx              { Switch ax with cx for return }
    end;  { Assembler Function ExistUMBmem }


FUNCTION DOSequalUMB : Boolean; assembler;
    asm                             { DOS 5 can detect DOS UMB ownership}
         xor     cx,cx              { Use cx for return }
         cmp     DosVerNum,5        { If not at least DOS 5 then exit }
         jb      @1                 { with return of False (0) }
         mov     ax,5802h           { Get current UMB State }
         int     21h                { AL=00 NOT linked to DOS control }
                                    { AL=01 ARE linked to DOS control }
         cbw                        { Get rid of AH }
         push    ax                 { Save Current State }
         mov     ax,5803h           { Attempt Set UMB's Linked }
         mov     bx,1               { to DOS control }
         int     21h
         pop     bx                 { Restore prior state }
         jc      @1                 { If carry, not DOS's }
         mov     ax,5803h           { UMB State }
         int     21h
         inc     cx                 { Set to True }
    @1:  xchg    cx,ax              { Switch cx-ax for return }
    end; { asm }
  { Function DosEqualUMB }


FUNCTION ExistEMS: Boolean; assembler;
    CONST
      EMName           : Array[0..7] of CHAR = 'EMMXXXX0';
    asm
         mov     ax,3567h           { Get Vector for EMS interrupt 67h }
         int     21h
         mov     di,10              { Point to device driver name }
         mov     cx,8               { for 8 bytes }
         lea     si,EMName          { compare with constant name }
         cld                        { in forward direction }
         xor     ax,ax              { Default to False }
         repz    cmpsb              { Compare strings }
         jnz     @1                 { If strings NOT equal, exit False }
         inc     ax                 { Else set to True }
     @1:                            { and exit }
     end; { asm }
    { Function ExistEMS }


FUNCTION isXMSok : Boolean; assembler;
{ Used by other XMS functions to make certain XMS is implemented   }
{ before making a far call to the control vector of the XMS driver }
    asm
         mov     ax,1               { Default return to True }
         mov     XMSResult,ax       { Default to Success }
         mov     XMSError,ah        { and NO Error }
         cmp     isXMS,ah           { If IS XMS Driver }
         jnz     @1                 { then just exit }
         dec     al                 { Else Return False }
         mov     XMSResult,ax       { Set Failure }
         mov     XMSError,80h       { and "unimplemented" }
     @1:
     end;
  { Function isXMSok }


PROCEDURE GetXMSversionAndHMAstatus; assembler;
{ Sets Words XMSVersion and XMSRevision and Boolean isHMA }
{ XMSVersion and XMSRevision are in BCD }
    asm
         xor     ax,ax              { isHMA will start False }
         xor     bx,bx              { Initialize 0 version }
         xor     dx,dx              { and 0 Revision }
         cmp     isXMS,al           { If NO XMS then }
         jz      @1                 { Set as initialized, else }
                                    { ax=0=XMS function zero }
         call    [XMM_Control]      { Call Control vector }
     @1: mov     isHMA,dl           { dl has HMA state }
         mov     XMSVersion,ax      { ax has version # }
         mov     XMSRevision,bx     { bx has revision # }
     end; { asm }
   { Procedure GetXMSversionAndHMAstatus }


PROCEDURE GetMemHMA(Malloc : Word); assembler;
{ Attempts to allocate HMA memory }
    asm
         call    isXMSok            { Check if all ok }
         or      al,al              { If False }
         jz      @1                 { Just Exit, Else }
         mov     dx,Malloc          { # of HMA bytes to request }
         mov     ax,0100h           { XMS function 1 }
         call    [XMM_Control]      { Call Control vector }
         mov     XMSResult,ax       { Result }
         cmp     bl,80h             { Any bl lower than 80h no error }
         jb      @1
         mov     XMSError,bl        { Set error }
    @1:
    end; { asm }
   { Procedure GetMemHMA }


PROCEDURE ReleaseMemHMA; assembler;
{ Attempts to release HMA if allocated }
    asm
         call    isXMSok            { Check if all ok }
         or      al,al              { If False }
         jz      @1                 { Just Exit, Else }
         mov     ax,0200h           { Release HMA Function }
         call    [XMM_Control]      { Through Driver }
         mov     XMSResult,ax       { Copy to Result }
         cmp     bl,80h             { If NO error }
         jb      @1                 { exit, else }
         mov     XMSError,bl        { Update error return first }
    @1:                             { then exit }
    end; { asm }
   { Procedure ReleaseMemHMA }


PROCEDURE QueryA20; assembler;
{ XMSResult = 1 if A20 is physically enabled, else 0 }
    asm
         call    isXMSok            { Check if all ok }
         or      al,al              { If False }
         jz      @1                 { Just Exit, Else }
         mov     ax,0700h           { Query A20 line func }
         call    [XMM_Control]      { through driver }
         mov     XMSResult,ax       { Update result }
         mov     XMSError,bl        { and Error }
    @1:                             { and exit }
    end; { asm }
   { Procedure QueryA20 }


PROCEDURE QueryFreeMemXMS; assembler;
{ XMSResult = total free Extended Memory in kilobytes }
{ XMSError = $80 if unimplemented, else allocation error code }
    asm
         call    isXMSok            { Check if all ok }
         or      al,al              { If False }
         jz      @exit              { Just Exit, Else }
         mov     XMSLargest,0       { Default to zero size }
         mov     XMSResult,0        { and result too }
         mov     ax,0800h           { Function 8 }
         call    [XMM_Control]
         mov     XMSResult,dx       { dx has total free }
         mov     XMSLargest,ax      { ax has largest free block }
         cmp     bl,80h             { if No error }
         jb      @next              { get free handles }
         mov     XMSError,bl        { else set error }
         jmp     @exit              { then exit }
    @next:
         mov     ax,0E00h           { Function 14 }
         mov     dx,0               { use handle 0 }
         call    [XMM_Control]
         mov     XMSError,bl        { set error code }
         cmp     ax,0               { if NOT error }
         jnz     @exit              { get free handles }
         mov     XMSError,0         { else set error }
         xor     bh,bh              { zero bh }
         mov     XMSFreeHandles,bx  { set number of free handles }
    @exit:
    end; { asm }
   { Procedure QueryFreeMemXMS }


PROCEDURE RelUpperMemBlockUMB(RelUMBSeg: Word); assembler;
    asm
         call    isXMSok            { Check if all ok }
         or      al,al              { If False }
         jz      @1                 { Just Exit, Else }
         mov     ax,1100h           { Release UMB block func }
         mov     dx,RelUMBSeg       { Segment of block to release }
         call    [XMM_Control]      { Through driver }
         mov     XMSResult,ax       { Copy result from ax }
         cmp     bl,7Fh             { If error return 80h or greater }
         ja      @1                 { Is result not error so return }
         mov     XMSError,bl        { Else update error return }
    @1:
    end; { asm }
   { Procedure RelUpperMemBlockUMB }


FUNCTION Get2EVector : Word; assembler;
    asm
         mov     ax,352Eh           { Get vector for INT 2Eh }
         int     21h
         mov     ax,es              { Return Segment in ax }
    end; { asm }
  { Function Get2EVector }


FUNCTION GetKey : Char;  assembler;
    asm
    @1:  mov     ah,6               { First clear                }
         mov     dl,-1              { keyboard buffer            }
         int     21h
         jnz     @1                 { repeat until buffer empty  }
    @2:  mov     ah,7
         int     21h                { Get one key                }
         or      al,al              { If first byte is 0         }
         jz      @2                 { get another key            }
                                    { else, return key in al     }
    end; { asm }
    { Function GetKey }


FUNCTION GetDosVersion : Word; assembler;
    asm
         mov     ax,3000h           { Get version function }
         int     21h                { Returns version in ax }
         xor     dh,dh              { Return DosLocus in dh }
         push    ax                 { Save Version }
         cmp     al,5               { If it's NOT DOS 5.0 }
         jb      @exit              { return result }
         mov     ax,3306h           { else DOS 5.0 }
         int     21h                { returns location of DOS itself }
    @exit:
         pop     ax                 { return DOS version in AX }
         mov     DosLocus,dh        { and set location through dh }
    end; { asm }
    { Function GetDosVersion }

FUNCTION Wrd2Hex(BinNum : Word):  HexStr4; assembler;
{binary word to hex string}
  CONST
  HexChars : Array[0..15] of Char = '0123456789ABCDEF';
    asm
         cld                        { Set forward direction }
         mov     dx,BinNum          { dx will hold incoming parm }
         les     di,@Result         { di points to output }
         lea     si,HexChars        { si points to index of chars }
         mov     cl,4               { cl holds Shift Count }
         mov     al,cl              { Put length (4) in byte 0 }
         xor     bh,bh              { 0 to bh }
         stosb
         mov     bl,dh              { Get high byte in word in bl }
         shr     bl,cl              { and SHR 4 }
         mov     al,[si + bx]       { Put HexChar[bx] into al }
         stosb                      { and add to front of string }
         mov     bl,dh              { Get high byte to bl again }
         and     bl,15              { AND with 15 }
         mov     al,[si + bx]       { then repeat storage to string }
         stosb
         mov     bl,dl              { This time work on low byte }
         shr     bl,cl
         mov     al,[si + bx]
         stosb
         mov     bl,dl
         and     bl,15
         mov     al,[si + bx]
         stosb
    end;
    { Function Wrd2Hex }

FUNCTION Spaces(b : Byte) : String; assembler;
{Returns a number of spaces as a string}
    asm
         cld
         les     di,@Result         { Point es:di at Return string }
         mov     al,b               { Number of spaces to al }
         stosb                      { Store length in Result[0] }
         cbw                        { Make a Word }
         mov     cx,ax              { to count # of spaces }
         jcxz    @exit              { if cx = 0 then exit }
         mov     al,32              { put space into al }
    @looper:
         stosb                      { else store spaces }
         loop    @looper            { for cx times }
    @exit:
    end;

FUNCTION IntToStr(I : LongInt) : String;
  var
    s : String;
  BEGIN
    str(I,s);
    IntToStr := s;
  END;

PROCEDURE Bottomline(str : String80);

  VAR
    Y        : Byte;
    C        : Char;


  BEGIN
    Write(#13' - More - ',str);
    C := Getkey;
    Write(CR);
    Write(Spaces(Cols),CR);
    LineNum := 1;
  END; { Procedure BottomLine }


PROCEDURE BlankLine;
  BEGIN
    WriteLn;
    Inc(LineNum)
  END;  { Procedure BlankLine }


PROCEDURE GiveHelp;
  BEGIN
    WriteLn;
    WriteLn('SEEMEM by Rick Housh, Version ',PrgVerStr,', ',PrgDateStr);
    WriteLn('Memory Control Block Mapping Program, Displays status of');
    WriteLn('Conventional (CNV), Extended (EXT), Expanded (EMM),');
    WriteLn('Upper (UMB), High (HMA) and XMS',NewLine);
    WriteLn('Usage:  SEEMEM  [/n] [/?]');
    WriteLn('  /n defeats pausing at each screenful');
    WriteLn('  /? displays this help',NewLine);
    WriteLn('Redirectable, e.g. SEEMEM /N > PRN');
    WriteLn('  Prints output without pauses');
    Halt(0);
  END; { Procedure GiveHelp }


PROCEDURE DisplayThisMCB;  {Each Memory Control Block}
                           {is cooked and displayed  }
                           {by this PROCEDURE.}
  TYPE
    Tags      = SET OF Byte;

  CONST
    EnvironmentBlock  : TypeBlock = 'Env''ment ';
    SysEnvBlock       : TypeBlock = 'Sys-Envmt';
    SysShellBlock     : TypeBlock = 'Sys-Shell';
    ProgramBlock      : TypeBlock = 'Process  ';
    SystemBlock       : TypeBlock = 'Data     ';
    DeviceBlock       : TypeBlock = 'Device   ';
    ConfigBlock       : TypeBlock = 'Config   ';
    ReserveBlock      : TypeBlock = 'Reserved ';
    XMSDriverName     : TypeBlock = 'XMS-Ctrl ';
    UnknownName       : TypeBlock = '[Unknown]';

  VAR
    Ch, Last        : Char;
    Bytes, Subbytes : Longint;
    Substr          : String3;
    Envsize,
    LoopCt          : Word;
    EnvmtMCB        : ^MCBStruc;
    PspMCB          : ^PSPStruc;
    Count           : Byte;


  PROCEDURE WriteProgName;
    TYPE
      String128 = String [128];
    VAR
      Ctr             : Byte;
      Ch1             : Char;
      ProgNameStr     : String128;
      OwnersMCB       : ^MCBStruc;

    BEGIN
      OwnersMCB := Ptr(ThisMCB^.OwnerSeg - 1, 0);
      Write('      ');
      { First, IF MCB is NOT an Environment }
      IF (ThisMCB^.OwnerSeg <> EnvmtMCB^.OwnerSeg) THEN
        BEGIN
          IF  (DosVerNum < 4) AND (NOT isDRDOS) THEN
            BEGIN
              WriteLn(UnknownName);    { If NOT environment No name }
              Inc(LineNum);            { anywhere if DOS < 4.xx     }
            END
          ELSE      { So, if DOS 4 ++  IF MCB Seg > 0 but less than DOS PSP }
            BEGIN   { say DOS owns it }

              IF (ThisMCB^.OwnerSeg <= MasterPSP) AND (ThisMCB^.OwnerSeg > 0)
                  THEN Write(DosName)
              ELSE                   { Still IF DOS = 4 ++ }
                BEGIN
                   Ctr := 1;
                   WHILE (OwnersMCB^.ProgName[Ctr] <> #0) AND (Ctr < 9) DO
                     BEGIN
                       Write(OwnersMCB^.ProgName[Ctr]);
                       Inc(Ctr)
                     END;
                END;
                BlankLine;
          END
        END
      ELSE       { This MCB IS an environment! }
        BEGIN
          IF (DosVerNum < 3) THEN
                                   { DOS version 1.xx or 2.xx }
            BEGIN                  { So say 'unknown' }
              WriteLn(UnknownName);
              Inc(LineNum);
            END                    { DOS IS 3.X  and IS environment }
          ELSE                     { So get name from Environment }
            BEGIN
              Envsize := EnvmtMCB^.Size SHL 4; {multiply by 16}
              LoopCt := 0;
              Ch1 := Char(Mem[PspMCB^.Environment: LoopCt]);
              REPEAT
                Last := Ch1;       {pass through environment variables}
                Inc(LoopCt);
                Ch1 := Char(Mem[PspMCB^.Environment: LoopCt]);
                    { Loop through environment to end }
                    { End of environment block = 0,0 }
              UNTIL (LoopCt > Envsize) OR ((Ch1 = #0) AND (Last = #0));
              Inc(LoopCt);
              Ch1 := Char(Mem[PspMCB^.Environment: LoopCt]);
              IF (LoopCt >= Envsize) OR (Ch1 <> #1) THEN

                       { IF NO valid name follows environment THEN }
                       { If DOS = 4 ++ still can get name from MCB }
                BEGIN                      { So, do that }
                  IF (DosVerNum > 3) OR (isDRDOS) THEN
                    BEGIN
                      Ctr := 1;
                      WHILE (ThisMCB^.ProgName[Ctr] <> #0) AND (Ctr < 9) DO
                        BEGIN
                          Ch1 := ThisMCB^.ProgName[Ctr];
                          IF NOT (Ch1 in [#33,#35,#38,#45,
                                         '0'..'9','@'..'Z',#123,#125])
                             THEN Ch1 := '.';
                          Write(Ch1);
                          Inc(Ctr);
                        END;
                    END
                END           { Otherwise, IF a valid name IS in the }
              ELSE            { Environment display it for ANY DOS > 2}
                BEGIN
                  ProgNameStr := '';
                            {skip signature 1 (Or # of Strings to follow)}
                  Inc(LoopCt,2);
                  Ch1 := Char(Mem[PspMCB^.Environment: LoopCt]);
                  REPEAT
                    ProgNameStr := ProgNameStr + Ch1;
                    Inc(LoopCt);
                    Ch1 := Char(Mem[PspMCB^.Environment: LoopCt])
                  UNTIL (LoopCt > Envsize) OR (Ch1 = #0);
                  IF Pos(#0,ProgNameStr) <> 0 THEN
                     ProgNameStr[0] := Chr(Pos(#0,ProgNameStr)-1);
                  LoopCt := 1;
                  WHILE LoopCt <> 0 DO
                    BEGIN
                      LoopCt := Pos('\',ProgNameStr);
                      Delete(ProgNameStr,1,LoopCt);
                    END;
                  Write(ProgNameStr);
                END;
                BlankLine;
            END
        END;
    END;    { Nested Procedure WriteProgName }


  BEGIN  { DisplayThisMCB }
    ThisMCB  := Ptr(Segment,0);
    PspMCB   := Ptr(ThisMCB^.OwnerSeg, 0);
    EnvmtMCB := Ptr(PspMCB^.Environment - 1, 0);   {MCB of environment}
    IF (LineNum > Rows) AND Paging THEN Bottomline('');
    WHILE NOT (ThisMCB^.IDchar IN M_or_Z) DO
      BEGIN
        Segment := Segment + 16;
        ThisMCB := Ptr(Segment, 0);
      END ;
    Finished := (ThisMCB^.IDchar = $5A);
    Bytes := LongInt(ThisMCB^.Size) SHL 4;            {size of MCB in bytes}
    IF Upper THEN
      BEGIN
         UMBTotal := 16 + UMBTotal + Bytes;
         IF (ThisMCB^.OwnerSeg > 7) AND (ThisMCB^.OwnerSeg < FirstMCB)
            THEN UMBSysUse := 16 + UMBSysUse + Bytes
           ELSE
         IF ThisMCB^.OwnerSeg = 7 THEN UMBResUse := 16 + UMBResUse + Bytes
           ELSE
         IF ThisMCB^.OwnerSeg = 6 THEN UMBDevUse := 16 + UMBDevUse + Bytes
           ELSE
         IF ThisMCB^.OwnerSeg = 0 THEN
           BEGIN
             UMBTotFree := 16 + UMBTotFree + Bytes;
             IF (Bytes > UMBLargest) THEN UMBLargest := 16 + Bytes;
           END;
      END;
    IF Bytes > $400 THEN Subbytes := Bytes MOD $400
      ELSE Subbytes := Bytes;
    Subbytes := Subbytes SHR 7;
    SubStr := IntToStr(Subbytes);
    SubStr[0] := #1;
    IF Substr = Space THEN Substr := '0';
    IF (Substr = '0') AND (Subbytes > 49) THEN Substr := '1';
    If MemSegStr = '' THEN MemSegStr := Wrd2Hex(Segment);
    Write(MemSegStr: 5, (Bytes SHR 10): 6, '.', Substr, 'k',
          Bytes: 9, Wrd2Hex(ThisMCB^.OwnerSeg): 8,'   ');
    IF ThisMCB^.OwnerSeg = 0 THEN
      BEGIN
        Write('Available      ');
        IF bytes > 15 THEN WriteLn(DosName) ELSE
          WriteLn('[unusable]');
        Inc(LineNum);
      END
    ELSE
      BEGIN
        IF ((MasterPSP = 0) OR (MasterPSP > ThisMCB^.OwnerSeg))
           AND (ThisMCB^.OwnerSeg > MasterPSP)
             THEN MasterPSP := ThisMCB^.OwnerSeg;
        IF ((PspMCB^.StopCode <> $20CD)
             AND (PspMCB^.StopCode <> $27CD)) THEN
          BEGIN                                     {Not a process}
             IF Seg(ThisMCB^) = Pred(XMM_Control[1]) THEN
               Write(XMSDriverName) ELSE
             IF ThisMCB^.OwnerSeg = MasterPSP THEN
               BEGIN
                 IF isDRDOS THEN Write(ConfigBlock) ELSE
                 IF ((DosVerNum > 3) AND (ThisMCB^.ProgName[1] = 'S')) THEN
                   BEGIN
                    IF (ThisMCB^.ProgName[2] = 'C') THEN Write(ReserveBlock)
                       ELSE
                    IF (ThisMCB^.ProgName[2] = 'D') THEN Write(ConfigBlock)
                   END
                     ELSE Write(SystemBlock);
               END
             ELSE
               IF NOT isDRDOS THEN
                 BEGIN
                   IF (ThisMCB^.OwnerSeg < SecondMCB) THEN
                   Write(ReserveBlock) ELSE Write(DeviceBlock);
                 END
               ELSE
                 BEGIN
                   Count := Byte(ThisMCB^.OwnerSeg);
                   IF (Count < Pred(MasterPSP)) THEN
                        BEGIN
                           Write('XMS Block      ');
                           Count := 1;
                           WHILE (ThisMCB^.ProgName[Count] <> #0) AND
                              (Count < 9) DO
                            BEGIN
                               Write(ThisMCB^.ProgName[Count]);
                               Inc(Count)
                            END;
                            BlankLine;
                            Exit;
                        END
                      ELSE IF (ThisMCB^.OwnerSeg = Pred(MasterPSP))
                        THEN Write(ReserveBlock)
                     ELSE Write(DeviceBlock);
                 END;
             IF NOT Upper THEN
               BEGIN
                 Write('      <',DosName,DosVerStr);
                 IF isDRDOS THEN Write(' (',DosVerNum,'.',DosMinorVer,')')
                   ELSE Write(' kernel');
                 WriteLn('>');
                 Inc(LineNum);
               END
             ELSE IF ThisMCB^.OwnerSeg = FirstMCB THEN
               BEGIN
                 WriteLn('      ',DosName);
                 Inc(LineNum);
               END
             ELSE WriteProgName;
        END
      ELSE
        IF (ThisMCB^.OwnerSeg = Succ(Segment)) THEN
          BEGIN
              IF ThisMCB^.OwnerSeg = ShellPsp THEN
                BEGIN
                  Write(SysShellBlock);
                  Write('      ',CmdPrgName);
                  IF is4DOS THEN
                    BEGIN
                       Write(lo(_4DosVer):2,'.');
                       IF hi(_4DosVer) < 10 THEN Write('0');
                       Write(hi(_4DosVer));
                     END;
                  BlankLine;
                END
                  ELSE
                BEGIN
                  Write(ProgramBlock);
                  WriteProgname;
                END;
          END
        ELSE
          BEGIN
            IF ThisMCB^.OwnerSeg = ShellPsp THEN
              BEGIN
                Write(SysEnvBlock);
                WriteLn('      ',CmdPrgName);
                Inc(LineNum);
              END
          ELSE
            BEGIN
              Write(EnvironmentBlock);
              WriteProgName;
            END;
          END;
      END
  END; { Procedure DisplayThisMCB }


PROCEDURE DisplayEMSinfo;

  TYPE
    EMShandlerecord =
      RECORD
        Handlenumber: Word;
        Numberofpages: Word;
      END;

    EMSHardware =
      RECORD
        PhysicalPageSize     : Word;
        AlternateMappingRegs : Word;
        MappingContextSize   : Word;
        DMARegSets           : Word;
        DMABehavior          : Word
      END;

  VAR
     EMMversion,
     Index, EMSErr       : Byte;
     FreePages,
     EMSmaxhandles,
     EMSsize, EMSleft    : Word;
     NonVolatile         : Boolean;
     Hardware            : EMSHardware;
     EmsHandles          : ARRAY [0..255] OF EMShandlerecord;
     EmsHandleName       : ARRAY [1..8] OF Char;

  PROCEDURE ErrorMessage(ErrNum : Word; FuncNum : String3);
    BEGIN
      BlankLine;
      Write(' EMS error ',ErrNum,' in function ',FuncNum,' -');
      IF ErrNum IN [$80,$81]  THEN
        BEGIN
          Inc(LineNum);
          CASE ErrNum of
            $80 : Write(' Software error -');
            $81 : Write(' Hardware malfunction -');
          END; { Case }
        END;
      Write(' EMS info NOT available');
      BlankLine;
    END; { Nested Procedure ErrorMessage }

  BEGIN { DisplayEMSinfo }
      IF NOT Paging THEN BlankLine;
      FOR ByteCounter := 0 TO 255 DO   { Init Array of Records }
        BEGIN
          EmsHandles[ByteCounter].Handlenumber := ByteCounter;
          EmsHandles[ByteCounter].Numberofpages := 0;
        END;

      WITH Hardware DO                 { Init Hardware Record }
        BEGIN
          PhysicalPageSize     := 1024;
          AlternateMappingRegs := 0;
          MappingContextSize   := 0;
          DMARegSets           := 0;
          DMABehavior          := 0
        END;

      EMSsize := 0;                 { Set Defaults for EMS stuff }
      EMSleft := 0;
      PageFrame := 0;
      EMMversion := 0;
      EMSmaxhandles := 255;
      asm
         mov     ah,46h             { Get EMM version ( v. 3.0 call) }
         int     67h
         mov     EMSErr,ah          { Save Result in ah }
         or      ah,ah              { <> 0 means error }
         jnz     @1                 { So exit }
         mov     EMMversion,al      { Else version is in al }
      @1:
      end; { asm }
      IF (EMSErr <> 0) THEN
        BEGIN
           ErrorMessage(EMSErr,'46h');
           Exit;
         END;
      asm
         mov     ah,41h             { Get Page Frame Segment }
         int     67h
         mov     EMSErr,ah          { Store Error }
         or      ah,ah              { Check for Error }
         jnz     @1                 { If IS error, exit }
         mov     PageFrame,bx       { Else Store Segment }
      @1:
      end; { asm }
      IF (EMSErr <> 0) THEN
        BEGIN
           ErrorMessage(EMSErr,'41h');
           Exit;
         END;
      asm
         mov     ah,42h             { Get total & avail pages }
         int     67h
         mov     EMSErr,ah          { Store Error }
         or      ah,ah              { Check for Error }
         jnz     @1                 { If IS error, exit }
         mov     EMSleft,bx         { Else store free pages }
         mov     EMSsize,dx         { And total pages }
      @1:
      end; { asm }
      IF (EMSErr <> 0) THEN
        BEGIN
           ErrorMessage(EMSErr,'42h');
           Exit;
         END;
      IF EMMversion > $39 THEN      { EMS v. 4 ++ calls }
      BEGIN
        NonVolatile := False;       { Default to volatile only }
        asm
           mov     ah,52h           { Get non-volatility support }
           mov     al,2             { Subfunction 2 }
           int     67h
           mov     EMSErr,ah        { Save error }
           or      ah,ah            { Check error }
           jz      @1               { Exit if No Error }
           mov     NonVolatile,al   { Else move to boolean }
        @1:
        end; { asm }
        IF (EMSErr <> 0) THEN
          BEGIN
             ErrorMessage(EMSErr,'52h');
             Exit;
           END;
        asm
           push    ss               { Hardware rec is local, on stack }
           pop     es               { So, point es to stack }
           lea     di,Hardware      { Point di to offset Hardware record }
           mov     ax,5900h         { Put info in Hardware record }
           int     67h
           mov     EMSErr,ah        { and store error }
        end; { asm }
        IF (EMSErr <> 0) THEN
          BEGIN
             ErrorMessage(EMSErr,'59h');
             Exit;
           END;
        asm
           mov     ax,5901h         { Get unallocated raw page count }
           int     67h
           mov     EMSErr,ah        { Store error }
           or      ah,ah            { Check for error }
           jnz     @1               { If error, exit, else }
           mov     EMSsize,dx       { Store Total Raw Pages }
           mov     EMSleft,bx       { Store Free Raw Pages }
        @1:
        end; { asm }
        IF (EMSErr <> 0) THEN
          BEGIN
             ErrorMessage(EMSErr,'59h');
             Exit;
           END;
        asm
           mov      ax,5402h        { Get Handle Count }
           int      67h
           mov      EMSErr,ah       { Store error }
           or       ah,ah           { Check for error }
           jnz      @1              { If IS error, exit, else }
           mov      EMSmaxhandles,bx { store handle count }
        @1:
        end; { asm }
        IF (EMSErr <> 0) THEN
          BEGIN
             ErrorMessage(EMSErr,'59h');
             Exit;
           END;
      END;
      IF EMMversion > $39 THEN Write('     ');
      Write(' EMS ver. ', EMMversion SHR 4, '.', EMMversion AND 15);
      Write(' - Page Frame Segment ', Wrd2Hex(PageFrame): 4,' - EMS Size ',
            LongInt(EMSsize * (Hardware.PhysicalPageSize DIV 64)):6, 'k');
      IF EMMversion < $40 THEN
        BEGIN
           WriteLn(  ' - Max Handles ',EMSmaxhandles: 3);
           Inc(LineNum);
         END
      ELSE
        BEGIN
          WriteLn;
          WriteLn('       Nonvolatile Handles (Warm Boot Survival) ',
                'supported: ',NoOrYes[NonVolatile]);

          WriteLn('   Mapping Register Sets = ',
                  Hardware.AlternateMappingRegs:2,
                ' : DMA Channels = ',Hardware.DMARegSets:2,
                ' : Maximum Handles = ',EMSmaxhandles:3);
          Inc(LineNum,3);
        END;
      asm
         push    ss                 { EmsHandles is on Stack }
         pop     es                 { So point es to Stack }
         lea     di,EmsHandles      { di gets offset of EmsHandles }
         mov     ah,4Dh             { Get Pages - All Handles }
         int     67h                { es:si (EmsHandles) is filled }
         mov     EMSErr,ah          { Store error }
         or      ah,ah              { If NO error }
         jz      @1                 { exit, else }
         xor     bl,bl              { Set count to 0 }
      @1:
        mov  HandleCount,bl
      end; { asm }
      IF (EMSErr <> 0) THEN
        BEGIN
           ErrorMessage(EMSErr,'4Dh');
           Exit;
        END;

      FreePages := EMSmaxhandles - HandleCount;
      BlankLine;
      Write('         Handle   Pages  Page Size-<<KB>>-',
            'Memory       Name');
      BlankLine;
      FOR HandleCount := 0 TO Pred(HandleCount) DO
        BEGIN
          Write(Spaces(8), EmsHandles[HandleCount].Handlenumber: 4,
                Spaces(6), EmsHandles[HandleCount].Numberofpages: 4,
                Spaces(5), Hardware.PhysicalPageSize DIV 64:4,
                Spaces(8), Longint(EmsHandles[HandleCount].
                Numberofpages * (Hardware.PhysicalPageSize DIV 64)): 8,
                '   -   ');

          IF EMMversion < $40 THEN  { EMS versions below 4.0 }
            Write('[NoName]')  ELSE
            BEGIN                   { Version 4.0 or above }
              asm
                 push    ss                    { Address ss as es }
                 pop     es                    { es:di points to record}
                 lea     di,EmsHandleName      { Offset of Name Array }
                 mov     al,HandleCount        { Get counter }
                 cbw                           { make it a word }
                 mov     dx,ax                 { into dx }
                 mov     ax,5300h              { Get handle name to es:di}
                 int     67h
                 mov     EMSErr,ah             { Save any error }
              end; { asm }
              IF EMSErr <> 0 THEN EmsHandleName[1] := #0;
              IF (EmsHandles[HandleCount].Handlenumber = 0) THEN
                  Write('[System]')
                ELSE
                  IF EmsHandleName[1] = #0 THEN
                    Write('[NoName]')
                ELSE
                  BEGIN
                  Index := 1;
                    WHILE (EmsHandleName[Index] <> #0) AND (Index < 9) DO
                    BEGIN
                      Write(EmsHandleName[Index]);
                      Inc(Index);
                    END;
                  END;
            END;                             { End of EMS 4 + name stuff }
            BlankLine;
            IF Paging AND (LineNum > Rows) THEN Bottomline('');
        END;

      Write('         ');
      FOR ByteCounter := 1 TO 40 DO Write('-');
      BlankLine;
      IF EMMversion > $39 THEN Inc(FreePages);
      WriteLn('   Free ', FreePages: 4,Spaces(6), EMSleft: 4,
              Spaces(17),EMSleft * (Hardware.PhysicalPageSize DIV 64): 8);
      Inc(LineNum);
  END; { Procedure DisplayEMSinfo }


PROCEDURE DisplayUMBinfo;
  BEGIN
    Write('       UMB = Implemented          -      ',
       NoOrYes[isUMB]);
    BlankLine;
    IF isUMB THEN
      BEGIN
        Write('       UMB = Device Driver        -      ',
          NoOrYes[isUMBdriver]);
        BlankLine;
        Write('       UMB = CNV Link             -      ',
          NoOrYes[UMBlinked]);
        BlankLine;
        Write('       DOS = UMB                  -      ',
          NoOrYes[isUMBDOS]);
        BlankLine;
      END;
  END;


PROCEDURE DisplayXMSinfo;
  BEGIN
    IF NOT Paging THEN BlankLine;
    Write('   XMS version ');
    Write(Hi(XMSversion), '.', Lo(XMSversion));
    Write('  -  Revision ');
    Write(Hi(XMSrevision), '.', Lo(XMSrevision));
    Write('  -  XMM Control Vector ');
    WriteLn(Wrd2Hex(Xmm_control[1]), ':', Wrd2Hex(Xmm_control[0]));
    Inc(LineNum);
    QueryFreeMemXMS;
    IF XMSerror in [$80,$8E,$8F] THEN
      BEGIN
        XMSresult := 0;
        XMSlargest := 0;
        Inc(Linenum);
      END;
    XMSavail := XMSresult;
    IF XMSerror in [$A0,$A1] THEN Inc(LineNum);
    CASE XMSerror of
       $80:  WriteLn('   XMS Memory NOT Implemented');
       $8E:  WriteLn(#7'   General XMS driver error');
       $8F:  WriteLn(#7'   Unrecoverable XMS driver error');
       $A0:  WriteLn('   All XMS Memory is already allocated');
       $A1:  WriteLn('   All XMS Handles are already allocated');
      END; {Case}
    BlankLine;
    IF XMSerror <> $80 THEN
      BEGIN
        Write('       A20 = Line Enabled         -      ');
        QueryA20;
        IF XMSerror > $7F THEN WriteLn(#7'Error ',XMSerror)
          ELSE Writeln(NoOrYes[XMSresult <> 0]);
        Inc(LineNum);
      END;
    Write('       HMA = Implemented          -      ',
              NoOrYes[isHMA]);
    BlankLine;
    Write('       HMA = In Use               -      ');
    IF IsHMA THEN
      BEGIN
        GetMemHMA($FFFF);
        Write(NoOrYes[XMSResult <> 1]);
        IF XMSResult = 1 THEN
          BEGIN
            ReleaseMemHMA;
            IF XMSresult = 0 THEN
              BEGIN
                Write(' Cannot Release HMA ');
                Blankline;
              END;
          END
        ELSE IF XMSerror = $81 THEN
          Write(' - VDISK Detected - ')
        ELSE IF XMSerror = $93 THEN Write(' - is NOT allocated')
        ELSE IF XMSerror <> $91 THEN  Write(#7'  Unknown XMS Error');
      END;
    BlankLine;
    DisplayUMBinfo;
    Write('       DOS = HIGH                 -      ',
          NoOrYes[DosLocus=16]);
    BlankLine;
    BlankLine;
  END; { Procedure Display XMSinfo }


PROCEDURE GetParms;  assembler;
{ Special for SeeMem }
    asm
         push    ds                 { Save Data Segment }
         cld                        { Set direction forward }
         mov     Paging,1           { Default Paging to True }
         mov     ax,PrefixSeg       { Set }
         mov     ds,ax              { Point Data Segment PSP }
         mov     es,ax              { also Extra Segment }
         mov     di,80h             { di and si point to }
         mov     si,di              { Command Line length byte }
         lodsb                      { move length to al }
         cbw                        { and convert to word }
         stosb                      { just to advance pointer }
         xchg    cx,ax              { cx gets length }
         jcxz    @exit              { if 0 then exit }
    @uploop1:
         lodsb                      { Else get next byte }
         cmp     al,'a'             { and upcase it }
         jb      @uploop2
         cmp     al,'z'
         ja      @uploop2
         sub     al,32
    @uploop2:                       { until }
         stosb                      { at end of cmd line length }
         loop    @uploop1
         mov     si,80h             { Start over with }
         lodsb                      { cmd line length }
         cbw                        { Convert to word }
         xchg    cx,ax              { into cx }
    @cloop1:                        { and continuing }
         lodsw                      { by reading word }
         dec     si                 { Back up one byte }
         xchg    ah,al              { reverse order }
         cmp     ax,'/H'            { Is it Help? }
         jz      @help              { Then give it }
         cmp     ax,'/?'            { Other help cmd? }
         jz      @help              { Then give it }
         cmp     ax,'/N'            { "/N"O paging? }
         jz      @next1             { Then set boolean }
         loop    @cloop1            { else get another }
         jmp     @exit              { Until through }
    @help:
         pop     ds                 { Restore Data Segment }
         jmp     GiveHelp           { Terminate with help }
    @next1:
         pop     ds                 { Restore Data Segment }
         mov     Paging,0           { Set Paging False }
         push    ds                 { Save Data Segment }
    @exit:
         pop     ds                 { Exit, Restoring Data Segment }
    end;

PROCEDURE ChkFor4Dos; assembler;
  asm
         xor     bx,bx
         mov     is4DOS,bl
         mov     _4DosLevel,bl
         mov     _4DosVer,bx
         mov     _4DosPSP,bx
         mov     ax,0D44Dh
         mov     bx,0
         int     2fh
         cmp     ax,44DDh
         jnz     @exit
         mov     is4DOS,1
         mov     _4DosVer,bx
         mov     _4DosPSP,cx
         mov     _4DosLevel,dl
  @exit:
  end;

PROCEDURE Initialize;
  VAR
    TmpStr : String[5];
    Ctr    : Byte;
  BEGIN
    XMM_Control[0]  := 0;
    XMM_Control[1]  := 0;
    XMSResult       := 1;
    XMSError        := 0;
    isXMS           := ExistXMS;
    isUMBdriver     := ExistUMBdriver;
    isUMB           := ExistUMBmem;
    GetXMSversionAndHMAStatus;
    isEMS           := ExistEMS;
    TempSeg         := 0;
    MasterPSP       := 0;
    Upper           := False;
    isAT            := False;
    isDRDOS         := False;
    UMBlinked       := False;
    is4DOS          := False;
    FirstMCB        := 0;
    SecondMCB       := 0;
    nonXMSExtendMem := 0;
    maxXMSmem       := 0;
    XMSavail        := 0;
    XMSFreeHandles  := 0;
    TotalExtMem     := 0;
    UMBTotFree      := 0;
    UMBTotal        := -16;
    UMBLargest      := 0;
    UMBResUse       := 0;
    UMBDevUse       := 0;
    UMBSysUse       := 0;
    Cols            := MemW[$0040: $004A];
    Rows            := MemW[$0040:$004C];
    IF (Cols = 80) and (Rows > 9600) THEN Rows := 9600;
    IF Cols > 80 THEN
      BEGIN
       IF Rows > 10240 THEN Rows := 11616
         ELSE
       IF Rows > 6600 THEN Rows := 6600;
      END;
    Rows := (Rows Shr 1) div Cols; {Screen regen / columns}
    Rows := Pred(Rows);
    TopCnvMem       := MemW[PrefixSeg:2];  { Last conventional in PSP:0002 }
    ShellPSP        := Get2Evector;        { INT 2Eh in command.com }
    DosVerNum       := Lo(GetDosVersion); {major version number, e.g., 3.X}
    DosMinorVer     := Hi(GetDosVersion); {minor ver. no., e.g. x.30 }
    DosVerStr := IntToStr(DosVerNum) + '.' + IntToStr(DosMinorVer);
    For Ctr := 1 to Length(DosVerStr) DO IF DosVerStr[Ctr] = ' '
      THEN  DosVerStr[Ctr] := '0';
    ChkFor4Dos;
    IF is4DOS THEN
      BEGIN
        ShellPSP := _4DosPSP;
        CmdPrgName := '[4DOS]   ';
        CmdStr := GetEnv('COMSPEC');
        FOR Ctr := 1 to Length(CmdStr) do CmdStr[Ctr] := UpCase(CmdStr[Ctr]);
        IF (Pos('NDOS',CmdStr) <> 0) THEN CmdPrgName := '[NDOS]   ';
      END;

    IF (NOT is4DOS) AND (DosVerNum > 4) THEN
      BEGIN
        asm
             push    ds
             mov     ax,5500h
             int     2Fh
             jc      @exit
             mov     ax,ds
             pop     ds
             push    ds
             mov     ShellPSP,ax
        @exit:
             pop     ds
        end; { asm }
      END;

    { If ExistUMBmem does not report any UMBs, may still be some }
    { which DOS can use, but with no device driver function   }
    { Only possible with DOS 5 ++ So use DOS 5 ++ function to }
    { Attempt to change DOS UMB link state - only possible if }
    { DOS owns some UMB's, so...                                }

    isUMBDOS := DOSequalUMB;

    IF NOT isUMB THEN isUMB := isUMBdriver;
                                       { If DOS has it they're there, }
                                       { even with no device driver }
    isDRDOS := GetEnv('OS') = 'DRDOS';  { Environment holds DR-DOS }
    IF isDRDOS THEN                     { Indicators }
      BEGIN
        DosName := '[DR-DOS] ';
        DosVerStr := GetEnv('VER');
      END;

    asm                             { DOS function returns a pointer}
         mov     ah,52h             { to the DOS 'list of lists' }
         int     21h                { in es:bx - DOS's first MCB }
         mov     TableSeg,es        { List's Segment in es, Save it }
         mov     TableOfs,bx        { Save offset }
    end; { asm }

    FirstMCB  := MemW[TableSeg:TableOfs - 2];

    TmpLongInt := TableSeg;
                              { What is DOS = High? If DOS 3 or 4 }
                              { we'll decide based on location of }
                              { current disk buffer in HMA or not }
                              { DOS 2 has no DOS=HIGH; DOS 5 can tell us }
                              { directly, and did, from GetDosVersion}

    TmpLongInt := MemW[TableSeg:TableOfs - 6];
    IF DosVerNum = 2 THEN TmpLongInt := MemW[TableSeg:TableOfs + $15];
    IF  (DosVerNum in [3..4])
         AND  (DosLocus < 16) THEN   { Get segment of current disk buffer}
      BEGIN
        IF (NOT isDRDOS) THEN TmpLongInt := MemW[TableSeg:TableOfs - 6]
          ELSE
        TmpLongInt := MemW[TableSeg:TableOfs + $14];
      END;
    IF (DosVerNum < 5) AND (DosLocus = 16) THEN TmpLongInt := $FFFF;

    IF TmpLongInt > $FFFF then DosLoadSeg := $FFFF
      ELSE DosLoadSeg := TmpLongInt;
    IF DosLoadSeg = $FFFF THEN DosLocus := 16;

    asm
         mov     ax,0C000h          { Test for > PC XT }
         push    es                 { save used registers }
         push    bx
         push    bp
         int     15h                { call rom function }
         pop     bp                 { restore registers }
         pop     bx
         pop     es
         jc      @1                 { if carry XT or lower }
         mov     isAT,1             { else is an AT or later }
         mov     ax,8800h           { so get regular extended size in k's}
         int     15h                { using rom }
         jc      @1                 { if error, exit }
         mov     nonXMSExtendMem,ax { else save extended size }
    @1:
    end; { asm }

    IF isAT THEN
      BEGIN
        IF DosVerNum > 3 THEN TotalExtMem := MemW[TableSeg:TableOfs + $45]
                                                  {Total extended memory }
                                                  {at es:bx + 45h in DOS }
                                                  {ver 4 and higher }
        ELSE
          BEGIN                                 { If Dos version < 4 }
            Port[$70] := $18;                   { then must get from ROM }
            TotalExtMem := Port[$71] shl 8;
            Port[$70] := $17;
            TotalExtMem := TotalExtMem + Port[$71];
          END;
        MaxXMSmem := TotalExtMem - nonXMSextendMem;
      END; { If isAT }
    MasterPSP := MemW[FirstMCB:0001];  { PSP of 1st MCB points to 8 }
    Segment := FirstMCB;               { Start here }
  END; { Procedure Initialize }

Function GetRawMode : Byte; assembler;
    asm
         mov     bx,1               { Handle for StdOut   }
         mov     ax,4400h           { IOCTL func GetDevInfo }
         int     21h
         jc      @exit              { Carry on error }
         mov     al,dl              { Save Mode }
         cbw                        { Change to word for return }
    @exit:
    end;
    { Procedure GetRawMode }

PROCEDURE SetRawMode(Hdl : Byte;OnOff : Boolean); assembler;
    asm
         mov     bl,Hdl             { Assign File Handle }
         xor     bh,bh              { Make it a byte }
         cmp     bl,1               { If NOT StdOut }
         jnz     @setit             { Just Set It }
         mov     dl,CookMode        { Else, Get old stdout cooked state }
         cmp     OnOff,0            { Get Incoming OnOff request }
         jz      @setit             { No?  Then restore old state }
         or      dl,20h             { Else, set raw mode - bit 5 }
    @setit:
         xor     dh,dh              { dh must be 0 }
         mov     ax,4401h           { with IOCTL func 1 }
         int     21h                { Set device info }
    end;
    { Procedure SetRawMode }

BEGIN {SeeMem}
  GetParms;
  Initialize;
  CookMode := GetRawMode;             { Get IOCTL mode of StdOut }
  If (CookMode AND 1) = 1 THEN isRedirected := False
    ELSE isRedirected := True;
  IF isRedirected AND Paging THEN Paging := False;
  OutputRec := @Output;               { By setting record pointer to file }
  SetRawMode(OutputRec^.Handle,True); { Set it to Raw }

  Write('  MCB         Size         Owner    ');
  WriteLn('(',PrgNameStr,' Version ',PrgVerStr,' ',PrgDateStr,')');
  WriteLn('Segment    Kilo   Bytes   Segment     Type       ',
          '    Owner Name');
  WriteLn('-------  ------- -------  ------- -------------',
          '  ----------------------');
  LineNum := 4;

  MemSegStr := '';
  REPEAT
    TempSeg := Segment;
    DisplayThisMCB;                         { Show each MCB in turn }
    MemSegStr := '';
    Segment := Segment + ThisMCB^.Size + 1; { Next MCB is length + 1 }
    IF (SecondMCB = 0) AND (Segment > FirstMCB) THEN SecondMCB := Segment;
  UNTIL (ThisMCB^.IDchar = $5A) OR (Segment >= TopCnvMem); {last one is 'Z'}

  Segment  := TopCnvMem;
  MemSegStr := Wrd2Hex(Pred(Segment));
  Lowermax := 1 + Segment - Succ(TempSeg);
  Lowermax := Lowermax SHL 4;

  { END OF CONVENTIONAL MEMORY }
  Write(' ',MemSegStr);
  WriteLn('   =======Last Conventional (CNV) Memory Segment=======');
  Inc(LineNum);

  IF isUMB THEN Upper := True;

  IF Segment MOD 16 = 0 THEN MemSegStr := '' ELSE
      MemSegStr := Wrd2Hex(Succ(Segment));
  IF NOT (Mem[TopCnvMem:0] in [$4D,$5A])
       AND (Mem[Pred(TopCnvMem):0] in [$4D,$5A]) AND isUMB THEN
    BEGIN
      Segment := Pred(TopCnvMem);
      MemSegStr := Wrd2Hex(TopCnvMem);
      DisplayThisMCB;
      Segment := TopCnvMem;
      Segment := Segment + MemW[Pred(Segment): 003];
      IF DosVerNum < 5 THEN UMBlinked := True;
      MemSegStr := '';
    END;

  IF IsUMB THEN
     BEGIN                                { Work Upper Memory Blocks}
       REPEAT
         Finished := False;
         DisplayThisMCB;                    {Look at each MCB}
         MemSegStr := '';
         Segment := Segment + ThisMCB^.Size + 1;
       UNTIL Finished;
     END;

  IF (LineNum <= Rows) THEN BlankLine;

  IF Paging THEN
    BEGIN
      PreviewStr := 'Conventional';
      IF isUMB THEN PreviewStr := PreviewStr + ' & UMB';
      PreviewStr := PreviewStr + ' Summary';
      IF IsXMS THEN PreviewStr := 'XMS Extended Memory - '+ PreviewStr;
      If (LineNum > 1) THEN
        BEGIN
          WHILE (LineNum <= Rows) DO BlankLine;
          If isEMS THEN BottomLine('Expanded Memory - ' + PreviewStr)
            ELSE
          Bottomline(PreviewStr);
        END;
    END;

  IF IsEMS THEN
  BEGIN
    DisplayEMSinfo;
    IF Paging THEN
      BEGIN
        WHILE (LineNum <= Rows) DO BlankLine;
        BottomLine(PreviewStr);
      END;
  END;

  IF Paging AND (LineNum > 1) THEN
    BEGIN
      WHILE (LineNum <= Rows) DO BlankLine;
      BottomLine(PreviewStr);
    END;

  IF IsXMS THEN DisplayXMSinfo ELSE
    BEGIN
      BlankLine;
      Write('           CNV  -  UMB  Memory Summary Information');
      BlankLine;
      BlankLine;
      DisplayUMBinfo;
      BlankLine;
    END;

  Write('       SHELL Location                    ');
  IF ShellPSP > $FFFE THEN Write('HMA')
    ELSE IF ShellPSP > $EFFF THEN Write('ROM')
    ELSE IF ShellPSP > TopCnvMem THEN Write('UMB')
    ELSE Write('CNV');
    Write(' - ',Wrd2Hex(ShellPSP));
  IF (DosVerNum > 3) or isDRDOS THEN
    BEGIN
      Write(' - [');
      ByteCounter := 0;
      Repeat
        Ch := Chr(Mem[ShellPSP -1:8 + ByteCounter]);
        IF Ch in ['0'..'9','A'..'Z'] THEN Write(Ch) ELSE IF Ch <> #0 THEN
          Write('.');
        Inc(ByteCounter);
      Until (Ch = #0) OR (ByteCounter = 8);
      Write(']');
    END
      ELSE Write(' - ',CmdPrgName);
  Blankline;
  Write('       DOS Location  (Disk Buffers)      ');
  IF (DosVerNum > 1) OR (DosLocus > 0) THEN
    BEGIN
      IF DosLocus = 8 THEN Write('ROM')
        ELSE
      IF DosLocus = 16 THEN Write('HMA - ',Wrd2Hex(DosLoadSeg),' - ')
        ELSE Write('CNV - ',Wrd2Hex(DosLoadSeg),' - ');
      Write(DosName,' [',DosVerStr,']');
      BlankLine;
      IF (DosVerNum > 4) AND (DosLocus = 16) AND (NOT isDRDOS) THEN
        BEGIN
          Write('       DOS HMA Usage               ');
          HMAUsed := $FFFF;         { Set impossible space in HMA }
          asm
            mov  ax,4A01h           { Get HMA Free Space }
            int  2Fh                { With multiplex interrupt }
            jc   @1                 { Exit if error }
            mov  HMAUsed,di         { else di points to offset of free HMA}
          @1:
          end; { asm }
          IF HMAUsed = $FFFF THEN Write('Error in INT 2F, AX=4A01h')
            ELSE Write(HMAUsed:5,' bytes');
          Blankline;
        END;
    END
  ELSE
    BEGIN
      Write('CNV');
      BlankLine;
    END;

  Blankline;

  IF isAT THEN
    BEGIN
      TotalExtMem := TotalExtMem - MaxXMSMem;

      IF isXMS THEN
        BEGIN
          Write('   XMS Free Memory Handles                ',
                 XMSFreeHandles:6);
          BlankLine;
          Write('   XMS Memory  (Total-Used-Avail-Largest) ',
                MaxXMSMem:6,'k - ',
                (MaxXMSMem-XMSavail):6,'k - ',XMSavail:6,'k - ',
                XMSlargest:6,'k');
          BlankLine;

        END;
    END;

  IF isUMB THEN
    BEGIN
      IF isDRDOS AND (Pos('6.',DosVerStr) <> 0) then
        BEGIN
          Write('   UMB Memory  (Total-Used-Avail-Largest) ',
               UMBTotal:6,'  - ',
               UMBTotal - UMBTotFree:6,'  - ',
               UMBTotFree:6, '  - ',
               UMBLargest:6);
          BlankLine;
          Write('   UMB Use (Resv-HiLoad-SysLoad-SelfLoad) ',
               UMBResUse:6,'  - ',
               UMBTotal - (UMBSysUse + UMBDevUse
                 + UMBResUse + UMBTotFree):6,'  - ',
               UMBSysUse:6,'  - ',
               UMBDevUse:6);
        END
      ELSE
      Write('   UMB Memory  (Total-Used-Avail-Largest) ',
               UMBTotal:6,'  - ',
               (UMBTotal - UMBTotFree):6,'  - ',
               UMBTotFree:6, '  - ',
               UMBLargest:6);
      BlankLine;
      Write('   Std Extended Memory (Total-Used-Avail) ',
               TotalExtMem:6,'k - ',
               TotalExtMem-nonXMSExtendMem:6,'k - ',
               nonXMSExtendMem:6, 'k');
      BlankLine;
    END;

  BlankLine;
  WriteLn('   Available Conventional (CNV) Memory ',
    Lowermax: 7, ' bytes');
  Inc(LineNum);
  OurEnvSize := (MemW[(MemW[Prefixseg: $2C]) - 1: 3]) SHL 4;
  WriteLn('           + Current Environment       ',
    OurEnvSize: 7, ' bytes');
  Inc(LineNum);
  WriteLn(Spaces(27),'Total       ',
    (Lowermax + OurEnvSize):7, ' bytes  (',
     (Lowermax + OurEnvSize) DIV 1024,'.',
     ((Lowermax + OurEnvSize) MOD 1024) DIV 100,'k)');
  Inc(LineNum);
  IF NOT isEMS THEN
    BEGIN
      BlankLine;
      Write('  EMS driver NOT installed or NOT working');
      BlankLine;
    END;
  IF  NOT IsXMS THEN
    BEGIN
      BlankLine;
      Write('  XMS driver NOT installed or NOT working');
      BlankLine;
    END;
  IF Paging THEN WHILE (LineNum < Rows) DO BlankLine;
  SetRawMode(1,False);
END { Program SeeMem }.
