{----------------------------------------------------------------------------
                        Turbo ScrEdit Skeleton v.1.0

                       for Turbo Pascal 3.0, 4.0, 5.0

Refer to SKELETON.DOC for a complete discussion on the contents and usage
of this file.

----------------------------------------------------------------------------}

{---**Version**---}

{---**Buffers**---}


{----**User Variables**----}

Var
    Load_Screen_No      : Integer;
    Demo_Screen_Pointer : Byte;
    Demo_Mode,
    Demo_Current_Screen : Integer;
    Demo_Message        : String [80];



{----** Example of loading and displaying screens**----}

Procedure Load_Screen;
Begin
S_Num := 0;
Repeat
    Demo_Screen_Pointer := Demo_Screen_Pointer + 1;
    Case Demo_Screen_Pointer of

{---**Screens**---}

    Else
        Demo_Screen_Pointer := 0;
    End;{Case Of}
Until S_Num > 0;
End;


Procedure Initialize_Program;
Begin
S_Init;{<== YOU MUST ALWAYS CALL S_INIT BEFORE USING TURBO SCREDIT PROCEDURES}
{---**ScreenFileName**---};

{---**InitRoutines**---}

{----**System Switches**----}

S_Sound      := True;
S_Freq       := 300;
S_Dur        := 100;
S_ShowStatus := True;
S_Cursor     := S_Normal;
S_Point      := 0;
S_Msg        := '';

{----** 1st Example Code **----}

Demo_Screen_Pointer := 0;
Demo_Mode           := 1;
Load_Screen;

End;


Procedure Process_Screen_File;
Begin


{----** Demo mode 2 **----}

If  Demo_Mode = 2 Then
    Repeat
        S_Point := S_Point + 1;
        While (S_Point = 0) Or (S_Field^.S_Type[S_Point] > 9) Do
            Begin
            S_Point := S_Point + 1;
            If  S_Point > S_Indx^.S_Count[S_Num] Then
                S_Point := 0;
            End;
        If  S_Msg = '' Then
            Begin
            Str(S_point:3,S_Msg);
            S_Msg := 'Field <' + S_Msg+ '>';
            End;
        S_READFIELD;
        S_Msg := '';
    Until (S_Alt) Or (S_Ctrl) Or (S_Fkey) Or (S_Enter);


{----** Demo mode 0 or 1 **----}

If  (Demo_Mode <> 2) Then
    S_ReadScreen;


{----** Example code for demonstration mode **----}

If  (S_F1) And (Demo_Mode > 0) Then
    Begin
    S_Msg := 'Press any key to load the next screen';
    S_ReadKey;
    Load_Screen;
    End;

{----**Special Key Testing**----}

If  S_Ch > #00 Then
    S_Msg := '<' + S_Ch + '> '
Else
    Begin
    S_Msg        := '';
    S_Msg := '';
    End;

If  S_Shift Then
    Begin
    If  S_LeftShift Then
        S_Msg := '<Left Shift>' + S_Msg;
    If  S_RightShift Then
        S_Msg := '<Right Shift>' + S_Msg;
    End;

If  S_Alt then
    S_Msg := '< Alt  >' + S_Msg;

If  S_Ctrl then
    S_Msg := '< Ctrl >' + S_Msg;

If  S_Esc   Then
    S_Msg := '<Escape>' + S_Msg;

If  S_ENTER then
    S_Msg := '<Enter >'  + S_Msg;

If  S_Fkey Then
    Begin
    If  S_F1 Then
        S_Msg := S_Msg + 'F1key ';
    If  S_F2 Then
        S_Msg := S_Msg + 'F2key ';
    If  S_F3 Then
        S_Msg := S_Msg + 'F3key ';
    If  S_F4 Then
        S_Msg := S_Msg + 'F4key ';
    If  S_F5 Then
        S_Msg := S_Msg + 'F5key ';
    If  S_F6 Then
        S_Msg := S_Msg + 'F6key ';
    If  S_F7 Then
        S_Msg := S_Msg + 'F7key ';
    If  S_F8 Then
        S_Msg := S_Msg + 'F8key ';
    If  S_F9 Then
        S_Msg := S_Msg + 'F9key ';
    If  S_F10 Then
        S_Msg := S_Msg + 'F10key ';
    If  S_Esc Then
        S_Msg := S_Msg + 'Escape Key ';
    If  S_Home Then
        S_Msg := S_Msg + 'Home ';
    If  S_Up Then
        S_Msg := S_Msg + 'Up Arrow ';
    If  S_PgUp Then
        S_Msg := S_Msg + 'Page Up ';
    If  S_Left Then
        S_Msg := S_Msg + 'Left ';
    If  S_Right Then
        S_Msg := S_Msg + 'Right ';
    If  S_End Then
        S_Msg := S_Msg + 'End ';
    If  S_Down Then
        S_Msg := S_Msg + 'Down Arrow ';
    If  S_PgDn Then
        S_Msg := S_Msg + 'Pagedn ';
    If  S_Ins Then
        S_Msg := S_Msg + 'Insert key ';
    If  S_Del Then
        S_Msg := S_Msg + 'Delete ';
    If  S_Tab Then
        S_Msg := S_Msg + 'Tab ';
    End;

End;

Begin
Initialize_Program;
Repeat
    Process_Screen_File;
Until S_Esc;

{----** Closing the Screen file **----};
S_CloseScreenFile;
End.
