{$U-,C-}
Const
S_LineSize     : Integer   = 160;
S_Zeros        : String[8] = '00000000';

Type
S_Cursors = (S_Bold,S_Off,S_Normal,S_GetCursor);
S_RecType = (S_Index,S_Data,S_Fields,S_FieldRanges,S_Work);
S_Str80   = String[80];

S_Rec =
   Record
   Case S_RecordType:S_RecType of
       S_Index:  {Total Bytes 3457}
           (S_Name         : Array[1..128] of String[16];
            S_Number       : Array[1..128] of Byte;
            S_RecordNumber : Array[1..128] of Integer;
            S_FieldsRecNo  : Array[1..128] of Integer;
            S_RangeRecNo   : Array[1..128] of Integer;
            S_First        : Array[1..128] of Byte;
            S_Count        : Array[1..128] of Byte;
            S_CompiledInd  : Array[1..128] of Byte;
            S_RangeRecNext : Integer;
            S_RangeLineNext: Integer;
            S_sFiled       : Integer);
       S_Data:   {Total Bytes 3840 + 1}
           (S_Video        : Array[1..3840]of Char;
            S_WorkArray    : Array[1..80,1..2] of Char;);
       S_Fields: {Total Bytes 4225}
           (S_FieldName    : Array[1..128] of String[16];
            S_Row          : Array[1..128] of Byte;
            S_Col          : Array[1..128] of Byte;
            S_Len          : Array[1..128] of Byte;
            S_Type         : Array[1..128] of Byte;
            S_Prev         : Array[1..128] of Byte;
            S_Next         : Array[1..128] of Byte;
            S_DataLen      : Array[1..128] of Byte;
            S_NormalBG     : Array[1..128] of Byte;
            S_NormalFG     : Array[1..128] of Byte;
            S_PromptBG     : Array[1..128] of Byte;
            S_PromptFG     : Array[1..128] of Byte;
            S_DisplayBG    : Array[1..128] of Byte;
            S_DisplayFG    : Array[1..128] of Byte;
            S_RangeNextRec : Array[1..128] of Integer;
            S_RangeNextLine: Array[1..128] of Byte);
       S_FieldRanges: {Total Bytes 3608 + 1}
           (S_RangeList    : Array[1..51] of String[78];
            S_RangeRec     : Array[1..51] of Integer;
            S_RangeLine    : Array[1..51] of Byte);
       End;

S_RecPointer      = ^S_Rec;
WorkAreaType      = Array[1..4096] of byte;
WorkAreaPtr       = ^WorkAreaType;
FieldPointerType  = Array[1..128] of integer;
FieldPointer      = ^FieldPointerType;
BufferPointerType = Array[1..128] of WorkAreaPtr;
BufferPointer     = ^BufferPointerType;

Var
S_File        : File of S_Rec;
S_Indx        : S_RecPointer;
S_Record      : S_RecPointer;
S_Field       : S_RecPointer;
S_WorkArea    : WorkAreaPtr;
S_FieldPtr    : FieldPointer;
S_BuffPtr     : BufferPointer;
S_Cursor      : S_Cursors;
S_CursorOld   : Integer;
S_WorkStr,
S_Msg,
S_EditStr,
S_NewStr,
S_Blanks,
S_Padding,
S_EditAttrib,
S_WorkAttrib,
S_NormAttrib  : S_Str80;
S_StatusLine,
S_StatusAttrib :String[40];
S_StAttrWork   :String[20];
S_Cnt,
S_RecNo,
S_ValidateField,
S_ValidateLine,
S_Fg,
S_Bg,
S_Str_Pos,
S_Attrib,
S_MessBg,
S_MessFg,
S_NormBg,
S_NormFg,
S_Num,
S_Count,
S_FieldCounter,
S_FirstField,
S_Direction,
S_Max_Dig,
S_Max_Dec,
S_PointHold,
S_Point,
S_RegCH,
S_RegCL,
S_Freq,
S_Dur,
S_Seg,
S_Ofs  : Integer;
S_BW,
S_Sound,
S_Sound_Hold,
S_ChangeScreen,
S_NumLock,
S_Mono,
S_Fkey,
S_Shift,
S_Alt,
S_Ctrl,
S_ESC,
S_F1,
S_F2,
S_F3,
S_F4,
S_F5,
S_F6,
S_F7,
S_F8,
S_F9,
S_F10,
S_Enter,
S_BkSp,
S_Home,
S_Up,
S_PgUp,
S_Left,
S_Right,
S_End,
S_Down,
S_PgDn,
S_Ins,
S_Del,
S_Tab,
S_Upcase,
S_Validate_Finished,
S_ScreenValid,
S_Wait,
S_ShowStatus,
S_ScrollLock,
S_Caps,
S_LeftShift,
S_RightShift,
S_InsertMode,
S_LeftArrow,
S_RightArrow,
S_InsertKey,
S_DeleteKey,
S_BackSpace   : Boolean;
S_Ins_Str     : String[1];
S_AttribHold,
S_CharHold,
S_Ch2,
S_Ch          : Char;
S_Ch_Num      : Byte Absolute S_Ch;
S_Reverse     : Byte;
S_NumLockBit  : Integer absolute $40:$17;
S_VideoPort   : Integer absolute $40:$63;

{Variables used in validation procedures}

S_Skip,
S_Matched,
S_Done,
S_EndLine,
S_InIf : Boolean;
S_CompMin,
S_CompMax,
S_CurStr  : S_Str80;
S_NextRec,
S_NextLine,
S_Result,
S_FieldNo,
S_Str_Ptr  : Integer;
S_Numeric,
S_CompMin_Numeric,
S_CompMax_Numeric  :Real;

Procedure S_Init; Forward;
Procedure S_ResetKeyFlags; Forward;
Procedure S_DisplayMessage(Var BackG,ForG : Integer; Message: S_Str80); Forward;
Procedure S_Write(Row,Col,Lgth : Integer; Lines,attribs : S_Str80);Forward;
Procedure S_PutScrMem(var Source, Dest; Len : integer);Forward;
Procedure S_GetScrMem(var Source, Dest; Len : integer);Forward;
Procedure S_Beep(Freq,Dur:Integer);Forward;
Procedure S_CloseScreenFile;Forward;
Procedure S_SetCursor(Switch:S_Cursors);
Type
S_RegDef = Record
   S_Cpu_Al,S_Cpu_Ah,
   S_Cpu_Bl,S_Cpu_Bh:Byte;
             S_Cpu_Cx,
             S_Cpu_Bp,
             S_Cpu_Si,
             S_Cpu_Di,
             S_Cpu_Ds,
             S_Cpu_Es,
             S_Cpu_Flags:Integer;
    End;
Var
S_Regs : S_RegDef;

Begin
FillChar(S_Regs,SizeOf(S_Regs),00);
S_Regs.S_Cpu_AH := 1;
S_Regs.S_Cpu_Bh := 0;

Case Switch of
    S_Normal    : S_Regs.S_Cpu_Cx := S_CursorOld;
    S_Off       : S_Regs.S_Cpu_CX := 4096;
    S_Bold      : S_Regs.S_Cpu_CX := 15;
    S_GetCursor : S_Regs.S_Cpu_AH := 3;
End;{Case}

Intr($10,S_Regs);

If  Switch = S_GetCursor Then
    S_CursorOld := S_Regs.S_Cpu_Cx;
End;



Procedure S_GetKey;
Begin
S_ResetKeyFlags;

If  S_Wait Then
    S_DisplayMessage(S_MessBg,S_MessFg,S_Msg);

While Not KeyPressed Do
    Begin
    S_Cnt        := 0;
    S_LeftShift  := False;
    S_RightShift := False;
    S_Shift      := False;
    S_Ctrl       := False;
    S_Alt        := False;
    S_ScrollLock := False;
    S_NumLock    := False;
    S_Caps       := False;
    S_InsertMode := False;
    If  ((S_NumLockBit and 2)=2) Then
        Begin
        S_Cnt       := S_Cnt + 1;
        S_LeftShift := True;
        S_Shift     := True;
        End;
    If  ((S_NumLockBit and 1)=1) Then
        Begin
        S_Cnt        := S_Cnt + 1;
        S_RightShift := True;
        S_Shift      := True;
        End;
    If  ((S_NumLockBit And 4)=4) Then
        Begin
        S_Cnt  := S_Cnt + 1;
        S_Ctrl := True;
        End;
    If  ((S_NumLockBit And 8)=8) Then
        Begin
        S_Cnt  := S_Cnt + 1;
        S_Alt  := True;
        End;
    If  ((S_NumLockBit And 16)=16) Then
        S_ScrollLock := True;
    If  ((S_NumLockBit and 32)=32) then
        S_NumLock := True;
    If  ((S_NumLockBit And 64)=64) Then
        S_Caps := True;
    If  ((S_NumLockBit And 128)=128) Then
        S_InsertMode := True;

    If  (S_ShowStatus)   And
        (S_Wait = False) Then
        Begin
        FillChar(S_StatusAttrib,41,02);
        S_StatusAttrib[0] := #40;
        If  S_InsertMode Then
            Move(S_StAttrWork[1],S_StatusAttrib[1],8);
        If  S_Caps Then
            Move(S_StAttrWork[1],S_StatusAttrib[10],6);
        If  S_NumLock Then
            Move(S_StAttrWork[1],S_StatusAttrib[17],10);
        If  S_ScrollLock Then
            Move(S_StAttrWork[1],S_StatusAttrib[28],13);
        S_Write(25,21,40,S_StatusLine,S_StatusAttrib);
        End;
    If  S_Cnt > 1 Then
        Begin
        S_Fkey := True;
        Exit;
        End;
    End;

S_Wait := False;
Read(Kbd,S_Ch);

If  S_Msg > '' Then
    Begin
    S_Msg := '';
    S_DisplayMessage(S_MessBg,S_MessFg,S_Msg);
    End;

If  S_Shift = True Then
    Begin
    If  (S_Ch_Num = 27) And (KeyPressed) Then
        Begin
        Read(Kbd,S_Ch);
        S_Fkey  := True;
        Case S_Ch_Num of
            84 : S_F1   := True;
            85 : S_F2   := True;
            86 : S_F3   := True;
            87 : S_F4   := True;
            88 : S_F5   := True;
            89 : S_F6   := True;
            90 : S_F7   := True;
            91 : S_F8   := True;
            92 : S_F9   := True;
            93 : S_F10  := True;
            15 : Begin
                 S_Tab  := True;
                 S_Fkey := False;
                 End;
            End;
        S_Ch := #00;
        Exit;
        End
    Else
        Begin
        Case S_Ch_Num of
            8  : Begin S_BkSp := True; S_FKey := True;End;
            13 : S_Enter:= True;
            33,34,35,36,37,38,40,41,42,43,58,60,62,63,64,
            65..90,94,95,123,124,125,126:Exit;
            52 : Begin S_Left := True; S_Fkey := True;End;
            54 : Begin S_Right:= True; S_Fkey := True;End;
            56 : Begin S_Up   := True; S_Fkey := True;End;
            50 : Begin S_Down := True; S_Fkey := True;End;
            55 : Begin S_Home := True; S_Fkey := True;End;
            49 : Begin S_End  := True; S_Fkey := True;End;
            57 : Begin S_PgUp := True; S_Fkey := True;End;
            51 : Begin S_PgDn := True; S_Fkey := True;End;
            48 : Begin S_Ins  := True; S_Fkey := True;End;
            46 : Begin S_Del  := True; S_Fkey := True;End;
            27 : Begin S_Esc  := True; S_Fkey := True;End;
            End;
        S_Ch_Num := 0;
        Exit
        End;
    End;

If  (S_Ctrl)         And
    (Not KeyPressed) Then
    Begin
    S_Fkey := True;
    Case S_Ch_Num of
      1..26 : Begin
              S_Ch_Num := S_Ch_Num + 64;
              Exit;
              End;
      27.. 31: Begin
               Case S_Ch_Num of
                 27 : S_Ch := '[';
                 28 : S_Ch := '\';
                 29 : S_Ch := ']';
                 30 : S_Ch := '6';
                 31 : S_Ch := '-';
                 End;{Case of}
               Exit;
               End;
      127    : Begin
               S_BkSp      := True;
               S_Ch_Num    := 0;
               Exit;
               End;
      End;{Case}
    S_Fkey := False;
    End;

If  S_Ch_Num = 27 Then
    Begin
    If  KeyPressed Then
        Begin
        Read(Kbd,S_Ch);
        S_Fkey := True;

        Case S_Ch_Num of
            59,84,94,104   : S_F1   := True;
            60,85,95,105   : S_F2   := True;
            61,86,96,106   : S_F3   := True;
            62,87,97,107   : S_F4   := True;
            63,88,98,108   : S_F5   := True;
            64,89,99,109   : S_F6   := True;
            65,90,100,110  : S_F7   := True;
            66,91,101,111  : S_F8   := True;
            67,92,102,112  : S_F9   := True;
            68,93,103,113  : S_F10  := True;
            115, 178       : S_Left  := True;
            116, 180       : S_Right := True;
            160, 175, 72   : S_Up    := True;
            164, 183, 80   : S_Down  := True;
            119, 174, 71   : S_Home  := True;
            117, 182, 79   : S_End   := True;
            132, 176, 73   : S_PgUp  := True;
            118, 184, 81   : S_PgDn  := True;
            165, 185       : S_Ins   := True;
            166, 186       : S_Del   := True;
                      82   : Begin
                             S_Ins       := True;
                             S_InsertKey := True;
                             S_Fkey      := False;
                             End;
                      83   : Begin
                             S_Del       := True;
                             S_DeleteKey := True;
                             S_Fkey      := False;
                             End;
                      75   : Begin
                             S_Left       := True;
                             S_LeftArrow  := True;
                             S_Fkey       := False;
                             End;
                      77   : Begin
                             S_Right      := True;
                             S_RightArrow := True;
                             S_Fkey       := False;
                             End;
        End;{Case of}
        Case S_Ch_Num Of
             3  : S_Ch    := '2';
            30  : S_Ch    := 'A';
            48  : S_Ch    := 'B';
            46  : S_Ch    := 'C';
            32  : S_Ch    := 'D';
            18  : S_Ch    := 'E';
            33  : S_Ch    := 'F';
            34  : S_Ch    := 'G';
            35  : S_Ch    := 'H';
            23  : S_Ch    := 'I';
            36  : S_Ch    := 'J';
            37  : S_Ch    := 'K';
            38  : S_Ch    := 'L';
            50  : S_Ch    := 'M';
            49  : S_Ch    := 'N';
            24  : S_Ch    := 'O';
            25  : S_Ch    := 'P';
            16  : S_Ch    := 'Q';
            19  : S_Ch    := 'R';
            31  : S_Ch    := 'S';
            20  : S_Ch    := 'T';
            22  : S_Ch    := 'U';
            47  : S_Ch    := 'V';
            17  : S_Ch    := 'W';
            45  : S_Ch    := 'X';
            21  : S_Ch    := 'Y';
            44  : S_Ch    := 'Z';
            114 : S_Ch    := '*';
            120 : S_Ch    := '1';
            121 : S_Ch    := '2';
            122 : S_Ch    := '3';
            123 : S_Ch    := '4';
            124 : S_Ch    := '5';
            125 : S_Ch    := '6';
            126 : S_Ch    := '7';
            127 : S_Ch    := '8';
            128 : S_Ch    := '9';
            129 : S_Ch    := '0';
            130 : S_Ch    := '-';
            131 : S_Ch    := '=';
        Else
            S_Ch_Num := 0;
        End;{Case of}
        End
    Else
        Begin
        S_Fkey := True;
        S_Esc  := True;
        End;
    End;

Case S_Ch_Num of
    8      : Begin
             S_BackSpace := True;
             S_BkSp      := True;
             S_Ch_Num    := 0;
             Exit;
             End;
    9      : Begin
             S_Tab       := True;
             S_Ch_Num    := 0;
             Exit;
             End;
    13     : Begin
             S_Enter     := True;
             S_Ch_Num    := 0;
             Exit;
             End;
End;{Case of};
End;





Procedure S_Write;
Var Pointer:integer;
Begin
For Pointer := 1 to lgth do
    Begin
    S_Record^.S_WorkArray[Pointer,1] := Chr(Ord(Lines[Pointer]));
    S_Record^.S_WorkArray[Pointer,2] := Chr(Ord(Attribs[Pointer]));
    End;
S_PutScrMem(S_Record^.S_WorkArray[1,1],
    Mem[S_Seg:S_Ofs + ((Row-1)*S_LineSize) + ((Col-1)*2)],Lgth * 2);
End;



Procedure S_DisplayMessage;
Begin
FillChar(S_WorkAttrib,81,02);
FillChar(S_Padding,81,32);
S_WorkAttrib[0] := #80;
S_Padding[0]    := #80;
Move(Message[1],S_Padding[(80-Length(Message)) Div 2],Length(Message));
FillChar(S_WorkAttrib[(80-Length(Message)) Div 2],Length(Message),(BackG * 16) + ForG);
If  Message > '' Then
    S_Beep(S_Freq,S_Dur);
S_Write(25,1,80,S_Padding,S_WorkAttrib);
End;




Procedure S_PutScrMem;
Begin
  If  S_Mono Then
      Move(Source,Dest,Len)
  Else
      Begin
      Len := Len shr 1;
      Inline($1E/$55/$BA/$DA/$03/$C5/$B6/Source/$C4/$BE/Dest/$8B/$8E/
         Len/$FC/$AD/$89/$C5/$B4/$09/$EC/$D0/$D8/$72/$FB/$FA/$EC/
         $20/$E0/$74/$FB/$89/$E8/$AB/$FB/$E2/$EA/$5D/$1F);
      End;
End;



Procedure S_GetScrMem;
Begin
  If  S_Mono Then
      Move(Source,Dest,Len)
  Else
      Begin
      Len := Len shr 1;
      Inline($1E/$55/$BA/$DA/$03/$C5/$B6/Source/$C4/$BE/Dest/$8B/$8E/
         Len/$FC/$EC/$D0/$D8/$72/$FB/$FA/$EC/$D0/$D8/$73/$FB/$AD/
         $FB/$AB/$E2/$F0/$5D/$1F);
      End;
End;



Procedure S_Beep;
Begin
If  S_Sound = True Then
    Begin
    Sound(Freq);
    Delay(Dur);
    NoSound;
    End;
End;

Procedure S_AllocateMemory;
Begin
If  MaxAvail > 1250 Then
    Begin
    GetMem(S_Indx,SizeOf(S_Indx^));
    GetMem(S_Record,SizeOf(S_Indx^));
    GetMem(S_Field,SizeOf(S_Indx^));
    GetMem(S_FieldPtr,SizeOf(S_FieldPtr^));
    GetMem(S_BuffPtr,SizeOf(S_BuffPtr^));
    End
Else
    Begin
    S_Msg := 'Not enough free Memory!';
    S_DisplayMessage(S_MessBg,S_MessFg,S_Msg);
    Halt;
    End;
S_CursorOld    := 1543;
S_SetCursor(S_GetCursor);
End;
