/*
******************************************************************
*          ScrEdit.H - Turbo C 1.5, 2.0 interface header         *
*                                                                *
*                <C>opyright 1989 by iHn Systems                 *
*                         P.O. Box 4436                          *
*                    Pocatello, Idaho 83205-4436                 *
*                                                                *
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*
* Building a ScrEdit.Lib. Before using Turbo ScrEdit you will    *
* wall want to build library models for LARGE, and HUGE. The     *
* COMPACT object code module must be linked in as a .OBJ file.   *
*                                                                *
* Repeat the following steps for each memory modelthat you will  *
* be using:                                                      *
*                                                                *
* 1. Select on of the memory models and compile ScrEdit.C to an  *
*    object file "ScrEdit.OBJ".                                  *
*                                                                *
* 2. For LARGE and COMPACT models use TLIB to build the library. *
*       For LARGE:   TLIB /E ScrEdit +-LScrEdit                  *
*       For HUDGE:   TLIB /E ScrEdit +-HScrEdit                  *
*                                                                *
* 3. Create a project file for each of the memory models of your *
*    choice:                                                     *
*       For COMPACT: YourProg ScrEdit  other.lib ...             *
*       For LARGE:   YourProg LScrEdit.Lib other.lib ...         *
*       For HUGE:    Yourprog HScrEdit.Lib other.lib ...         *
*                                                                *
* 4. To link in the object code from the Integrated Programming  *
*    Environment:                                                *
*      - use the PROJECT/PROJECT NAME option of the editor menu  *
*        and specifie the project file that fits the memory model*
*        you have specified in for OPTION/COMPILER.              *
*                                                                *
******************************************************************/

#ifndef SCREDIT_DEFINED
   #define SCREDIT_DEFINED
   typedef union
     {
     struct s1
         {
         char           filler;
         char           s_name         [128] [17];
         unsigned char  s_number       [128];
         int            s_recordnumber [128];
         int            s_fieldsrecno  [128];
         int            s_rangerecno   [128];
         unsigned char  s_first        [128];
         unsigned char  s_count        [128];
         unsigned char  s_compiledind  [128];
         int            s_rangerecnext;
         int            s_rangelinenext;
         int            s_sfiled;
         }A;
     struct s2
         {
         char           filler;
         char           s_video     [3840];
         char           s_workarray [80] [2];
         }B;
     struct s3
         {
         char          filler;
         unsigned char s_fieldname     [128] [17];
         unsigned char s_row           [128];
         unsigned char s_col           [128];
         unsigned char s_len           [128];
         unsigned char s_type          [128];
         unsigned char s_prev          [128];
         unsigned char s_next          [128];
         unsigned char s_datalen       [128];
         unsigned char s_normalbg      [128];
         unsigned char s_normalfg      [128];
         unsigned char s_promptbg      [128];
         unsigned char s_promptfg      [128];
         unsigned char s_displaybg     [128];
         unsigned char s_displayfg     [128];
         unsigned int  s_rangenextrec  [128];
         unsigned char s_rangenextline [128];
         }C;
     struct s4
         {
         char          filler;
         char          s_rangelist [51] [79];
         int           s_rangerec  [51];
         unsigned char s_rangeline [51];
         }D;
     } s_rec_def;

   s_rec_def *s_indx, *s_record, *s_field;

   int long S_CursorOld;

   enum S_Cursors {S_OFF,S_BOLD,S_NORMAL,S_GETCURSOR};
   enum S_Cursors S_Cursor;
   char S_Sound;
   char S_NumLock;
   char S_Fkey;
   char S_Shift;
   char S_Alt;
   char S_Ctrl;
   char S_Esc;
   char S_F1;
   char S_F2;
   char S_F3;
   char S_F4;
   char S_F5;
   char S_F6;
   char S_F7;
   char S_F8;
   char S_F9;
   char S_F10;
   char S_F11;
   char S_F12;
   char S_Enter;
   char S_BkSp;
   char S_Home;
   char S_Up;
   char S_PgUp;
   char S_Left;
   char S_Right;
   char S_End;
   char S_Down;
   char S_PgDn;
   char S_Ins;
   char S_Del;
   char S_Tab;
   char S_ShowStatus;
   char S_ScrollLock;
   char S_Caps;
   char S_LeftShift;
   char S_RightShift;
   char S_InsertMode;
   char S_InsertKey;
   char S_DeleteKey;
   char S_BackSpace;
   int  S_FirstField;
   int  S_Point;
   int  S_Freq;
   int  S_Dur;
   unsigned char S_WorkStr [81];
   unsigned char S_Msg [81];
   unsigned char S_EditStr [81];
   unsigned char S_Blanks [81];
   unsigned char S_Ch;
   unsigned char S_ChangeScreen;
   unsigned char S_FirstTime = 1;
   unsigned char S_Sound_Hold;
   unsigned char S_Mono;
   unsigned char S_UpCase;
   unsigned char S_Validate_Finished;
   unsigned char S_ScreenValid;
   unsigned char S_Wait;
   unsigned char S_LeftArrow;
   unsigned char S_RightArrow;
   unsigned char S_PosLastChar;
   int
     S_RecNo,
     S_ValidateLine,
     S_ValidateField,
     S_Str_Pos,
     S_Attrib,
     S_MessBg,
     S_MessFg,
     S_NormBg,
     S_NormFg,
     S_Num,
     S_F_Key,
     S_Direction,
     S_Decimal,
     S_PointHold,
     S_FieldNum,
     S_Sub,
     S_CurrLine,
     S_NextRec;

  unsigned char
     S_NewStr       [81],
     S_Padding      [81],
     S_WorkAttrib   [81],
     S_NormAttrib   [81],
     S_StatusPrev   [41],
     S_StatusLine   [41],
     S_StatusAttrib [41],
     S_Ins_Str      [2],
     S_NextLine,
     S_Reverse,
     S_Skip,
     S_Matched,
     S_Min_Max_Loaded,
     S_EndofLine,
     S_InsideIf,
     S_CurStr[81],
     S_EditStrHold[81],
     S_CompMin[81],
     S_CompMax[81],
     S_CompField[81],
     S_OpCode[81],
     S_OpCode1[81];

  double
     S_Round [8] = {.5,.5,.05,.005,.0005,.00005,.000005,.0000005},
     S_Numeric,
     S_CompMin_Numeric,
     S_CompMax_Numeric;
#endif

#ifdef __TINY__ or __SMALL__ or __MEDIUM__
   #error "TINY,SMALL, and MEDIUM memory models is are not supported";
#endif

void S_ResetKeyFlags (void);
void S_SetCursor(char);
void S_Init(void);
void S_OpenScreenFile (char*);
void S_CloseScreenFile(void);
void S_Beep(int,int);
void S_Write (int,int,int,char*,char*);
void S_DisplayMessage(int,int,char);
void S_LoadScreen(char *);
void S_DisplayScreenField(int,int,int,int,int,
                         int,int,int,int,char);
void S_EditString (int,int,int,int,int,
                  int,int,int,int,int,
                  int,int,char*);
void S_NextKey(void);
void S_ReadField(void);
void S_ReadScreen(void);
