#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <bios.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <alloc.h>

typedef union
    {
    int ch;
    struct{
       unsigned char lsb;
       unsigned char msb;
       } byte;
    }keyindef;
static keyindef shiftstat = 0;

typedef union
  {
  struct s1
      {
      char           filler;
      char           s_name         [128] [17];
      unsigned char  s_number       [128];
      int            s_recordnumber [128];
      int            s_fieldsrecno  [128];
      int            s_rangerecno   [128];
      unsigned char  s_first        [128];
      unsigned char  s_count        [128];
      unsigned char  s_compiledind  [128];
      int            s_rangerecnext;
      int            s_rangelinenext;
      int            s_sfiled;
      }A;
  struct s2
      {
      char           filler;
      char           s_video     [3840];
      char           s_workarray [80] [2];
      }B;
  struct s3
      {
      char          filler;
      unsigned char s_fieldname     [128] [17];
      unsigned char s_row           [128];
      unsigned char s_col           [128];
      unsigned char s_len           [128];
      unsigned char s_type          [128];
      unsigned char s_prev          [128];
      unsigned char s_next          [128];
      unsigned char s_datalen       [128];
      unsigned char s_normalbg      [128];
      unsigned char s_normalfg      [128];
      unsigned char s_promptbg      [128];
      unsigned char s_promptfg      [128];
      unsigned char s_displaybg     [128];
      unsigned char s_displayfg     [128];
      unsigned int  s_rangenextrec  [128];
      unsigned char s_rangenextline [128];
      }C;
  struct s4
      {
      char          filler;
      char          s_rangelist [51] [79];
      int           s_rangerec  [51];
      unsigned char s_rangeline [51];
      }D;
  } s_rec_def;

static FILE *s_file;
extern s_rec_def *s_indx, *s_record, *s_field;

static int   S_FieldPtr [128];
static char *S_BuffPtr  [128];
static char *S_WorkArea;
extern int long S_CursorOld;
extern enum S_Cursors {S_OFF,S_BOLD,S_NORMAL,S_GETCURSOR};
extern enum S_Cursors S_Cursor;
extern unsigned char S_Sound;
extern unsigned char S_NumLock;
extern unsigned char S_Fkey;
extern unsigned char S_Shift;
extern unsigned char S_Alt;
extern unsigned char S_Ctrl;
extern unsigned char S_Esc;
extern unsigned char S_F1;
extern unsigned char S_F2;
extern unsigned char S_F3;
extern unsigned char S_F4;
extern unsigned char S_F5;
extern unsigned char S_F6;
extern unsigned char S_F7;
extern unsigned char S_F8;
extern unsigned char S_F9;
extern unsigned char S_F10;
extern unsigned char S_F11;
extern unsigned char S_F12;
extern unsigned char S_Enter;
extern unsigned char S_BkSp;
extern unsigned char S_Home;
extern unsigned char S_Up;
extern unsigned char S_PgUp;
extern unsigned char S_Left;
extern unsigned char S_Right;
extern unsigned char S_End;
extern unsigned char S_Down;
extern unsigned char S_PgDn;
extern unsigned char S_Ins;
extern unsigned char S_Del;
extern unsigned char S_Tab;
extern unsigned char S_ShowStatus;
extern unsigned char S_ScrollLock;
extern unsigned char S_Caps;
extern unsigned char S_LeftShift;
extern unsigned char S_RightShift;
extern unsigned char S_InsertMode;
extern unsigned char S_InsertKey;
extern unsigned char S_DeleteKey;
extern unsigned char S_BackSpace;
extern int  S_FirstField;
extern int  S_Point;
extern int  S_Freq;
extern int  S_Dur;
extern unsigned char
       S_WorkStr [81],
       S_Msg     [81],
       S_EditStr [81],
       S_Blanks  [81],
       S_Ch;

extern unsigned char S_ChangeScreen;
extern unsigned char S_FirstTime;
extern unsigned char S_Sound_Hold;
extern unsigned char S_Mono;
extern unsigned char S_UpCase;
extern unsigned char S_Validate_Finished;
extern unsigned char S_ScreenValid;
extern unsigned char S_Wait;
extern unsigned char S_LeftArrow;
extern unsigned char S_RightArrow;
extern unsigned char S_PosLastChar;
extern int
  S_RecNo,
  S_ValidateLine,
  S_ValidateField,
  S_Str_Pos,
  S_Attrib,
  S_MessBg,
  S_MessFg,
  S_NormBg,
  S_NormFg,
  S_Num,
  S_F_Key,
  S_Direction,
  S_Decimal,
  S_PointHold,
  S_FieldNum,
  S_Sub,
  S_CurrLine,
  S_NextRec;

extern unsigned char
  S_NewStr       [81],
  S_Padding      [81],
  S_WorkAttrib   [81],
  S_NormAttrib   [81],
  S_StatusPrev   [41],
  S_StatusLine   [41],
  S_StatusAttrib [41],
  S_Ins_Str      [2],
  S_NextLine,
  S_Reverse,
  S_Skip,
  S_Matched,
  S_Min_Max_Loaded,
  S_EndofLine,
  S_InsideIf,
  S_CurStr[81],
  S_EditStrHold[81],
  S_CompMin[81],
  S_CompMax[81],
  S_CompField[81],
  S_OpCode[81],
  S_OpCode1[81];

extern double
  S_Round [8],
  S_Numeric,
  S_CompMin_Numeric,
  S_CompMax_Numeric;

int s_pos(char *string1,char *string2)
{
unsigned long X,Y,Z;
char s1 [80];
char s2 [80];
strcpy(s1,string1);
strcpy(s2,string2);
X = (unsigned long) strstr(s1,s2);
Y = (unsigned long) &s1;
Z = X - Y;
if  (X==0) return -1;
else return Z;
}



void s_delete(char *string1, int startpos,int count)
{
unsigned long x,y,z;
char s1 [80];
strcpy(s1,string1);
if  (startpos < strlen(s1))
    {
    z = startpos + count;
    if  (z > strlen(s1)) count = strlen(s1)-startpos;
    string1[startpos]=0;
    strcat(string1,(char*)&s1[startpos + count]);
    }
}

void s_insert(char *string1,
              char *string2,
              int  insertpoint,
              int  maxlength)
{
unsigned long X,Y,Z;
char s1 [160];
char s2 [80];
char s3 [80];

if ((insertpoint > -1) && (insertpoint <= strlen(string1)))
   {
   strcpy(s3,(char *)&string1[insertpoint]);
   string1[insertpoint]=0;
   strcpy(s1,string1);
   strcpy(s2,string2);
   strcat(s1,s2);
   strcat(s1,s3);
   s1[maxlength]=0;
   strcpy(string1,s1);
   }
}


void s_copy(char *string1, char *string2,int startpos, int count)
{
unsigned long X,Y,Z;
char s1 [160];
char s2 [80];
char s3 [80];
if (startpos < strlen(string1))
   {
   strcpy(s1,string1);
   s1[startpos + count] = 0;
   strcpy(string2,(char *)&s1[startpos]);
   }
}

int s_strlen(char *target_string)
{
int x,y,z;

x=strlen(target_string);
while ((target_string[x-1]<33)&&(x>=0)) x--;
if  (x>-1) x++;
return x;
}

int S_PutScrMem(row,col,len,source)
    char *source;
    int  row,col,len;
    {
    int b_row,b_col;

    if (len>160)
       {
       b_row=len/160;
       b_col=len - (b_row*160);
       b_row += (row - 1);
       if  (b_col==0)
           b_col = 80;
       }
    else
       {
       b_row = row;
       b_col = col + (len/2);
       }
    return puttext(col,row,b_col,b_row,source);
    }





int S_GetScrMem(row,col,len,destination)
    char *destination;
    int  row,col,len;
    {
    int b_row, b_col;

    if (len>160)
       {
       b_row=len/160;
       b_col=len - (b_row*160);
       b_row += (row - 1);
       if  (b_col==0)
           b_col = 80;
       }
    else
       {
       b_row = row;
       b_col = col + (len/2);
       }
    return gettext(col,row,b_col,b_row,destination);
    }





void S_ResetKeyFlags ()
   {
   S_F1     = 0;
   S_F2     = 0;
   S_F3     = 0;
   S_F4     = 0;
   S_F5     = 0;
   S_F6     = 0;
   S_F7     = 0;
   S_F8     = 0;
   S_F9     = 0;
   S_F10    = 0;
   S_F11    = 0;
   S_F12    = 0;
   S_Home   = 0;
   S_End    = 0;
   S_PgUp   = 0;
   S_PgDn   = 0;
   S_Left   = 0;
   S_Right  = 0;
   S_Up     = 0;
   S_Down   = 0;
   S_Del    = 0;
   S_Tab    = 0;
   S_BkSp   = 0;
   S_Esc    = 0;
   S_Ctrl   = 0;
   S_Enter  = 0;
   S_Fkey   = 0;
   S_Alt    = 0;
   S_Shift  = 0;
   S_Ins    = 0;
   }




void S_SetCursor(S)
   char S;
   {
   union REGS in,out;

   in.h.ah = 1;
   in.h.bh = 0;

   if  (S==0)
       in.x.cx = 4096;
   if  (S==1)
       in.x.cx = 15;
   if  (S==2)
       in.x.cx = S_CursorOld;
   if  (S==3)
       in.h.ah = 3;

   int86(0x10,&in,&out);

   if  (S==3)
       S_CursorOld = out.x.cx;
   }



void S_Init()
    {
    struct text_info r;
    int loop1,loop2,loop3;

    S_CursorOld = 1543;
    if (S_FirstTime)
       {
       s_indx      = (s_rec_def *) farmalloc (sizeof(*s_indx));
       s_record    = (s_rec_def *) farmalloc (sizeof(*s_record));
       s_field     = (s_rec_def *) farmalloc (sizeof(*s_field));
       S_SetCursor (S_GETCURSOR);
       S_FirstTime = 0;
       }
    S_SetCursor(S_OFF);

    S_MessBg       = 4;
    S_MessFg       = 15;
    S_NormBg       = 0;
    S_NormFg       = 2;
    S_Sound        = 1;
    S_Freq         = 300;
    S_Dur          = 100;
    S_PosLastChar  = 0;
    S_ChangeScreen = 1;
    S_Ch           = 0;
    S_Point        = 0;
    S_Direction    = 1;
    S_F_Key        = 0;
    S_RecNo        = 0;
    S_ValidateLine = 0;
    S_InsertKey    = 0;
    S_DeleteKey    = 0;
    S_BackSpace    = 0;
    S_LeftArrow    = 0;
    S_RightArrow   = 0;
    S_Cursor       = S_NORMAL;

    for (loop1=0;loop1<81;loop1++)
        S_Msg[loop1] = 0;

    for (loop1=0;loop1<81;loop1++)
        S_Blanks[loop1] = 32;
    S_Blanks[80] = 0;

    strcpy(S_StatusLine,"[Insert] [Caps] [Num Lock] [Scroll Lock]");
    strcpy(S_NormAttrib,S_Msg);
    strcpy(S_NewStr,S_Msg);
    strcpy(S_Padding,S_Msg);

    gettextinfo(&r);
    textmode(r.currmode);
    if ((!s_indx)||(!s_record)||(!s_field))
       {
       cprintf("Unable to allocate far memory..\r\n");
       exit (1);
       }
    S_ResetKeyFlags();
    }


void S_OpenScreenFile (char *screenfilename)
    {
    int loop1,loop2,loop3;

    if (S_FirstTime) S_Init();

    if ((s_file = fopen(screenfilename,"rb")) == NULL)
       {
       cprintf("open up of %s failed\r\n",screenfilename);
       exit (1);
       }

    if (fseek(s_file,0L,0) != 0)
       {
       puts("seek failed ");
       exit (1);
       }

   if (fread(s_indx,sizeof(*s_indx),1,s_file) < 1)
      {
      puts("read failed ");
      exit (1);
      }
   for (loop1=0;loop1 < s_indx->A.s_sfiled;loop1++)
       {
       loop2 = s_indx->A.s_name[loop1][0];
       for (loop3=1;loop3 < (loop2+2);loop3++)
	   s_indx->A.s_name[loop1][loop3-1]=s_indx->A.s_name[loop1][loop3];
       s_indx->A.s_name[loop1][loop2]=0;
       }
   }




void S_CloseScreenFile()
   {
   if  (S_FirstTime) S_Init();
   fclose(s_file);
   S_SetCursor(S_NORMAL);
   farfree(s_indx);
   farfree(s_record);
   farfree(s_field);
   S_FirstTime = 1;
   }



void S_Beep(int t,int l)
   {
   if  (S_Sound > 0)
       {
       sound(t);
       delay(l);
       nosound();
       }
   }

void S_Write (int Row, int Col, int Len,char *Source, char *Attribs)
   {
   int X,Y,Ptr,Ch;
   for (Ptr=0;Ptr<=Len;Ptr++)
       {
       s_record->B.s_workarray[Ptr][0]=Source[Ptr];
       s_record->B.s_workarray[Ptr][1]=Attribs[Ptr];
       }
   S_PutScrMem(Row,Col,(Len*2),&s_record->B.s_workarray);
   for (Ptr=1;Ptr<81;Ptr++)
       S_NormAttrib[Ptr]=0;
   }




void S_DisplayMessage(Bg,Fg,Msg)
   int
     Bg,
     Fg;
   char
     Msg [81];
   {
   int Msg_Len,W,X,Y;
   if  (S_FirstTime) S_Init();
   strcpy(S_Padding,S_Blanks);
   strcpy(S_WorkAttrib,S_Blanks);
   Msg_Len = strlen(Msg);
   Y       = (80 - Msg_Len)/2;
   W       = 0;
   for (X=0;X<80;X++)
       {
       if  (X<Y)
           S_WorkAttrib[X] = 2;
       else
           if  (X>((Y+Msg_Len)-1))
               S_WorkAttrib[X] = 2;
           else
               {
               S_WorkAttrib[X]=(Bg*16)+Fg;
               S_Padding   [X]=Msg[W];
               W++;
               }
       }
   if (strlen(Msg)>0)
      S_Beep(S_Freq,S_Dur);
   S_Write(25,1,80,S_Padding,S_WorkAttrib);
   S_Msg[0]=0;
   }



void S_Store_Buf_Loc(char *ScrName, char *ScrBuff)
   {
   int X,Y,Z;
   if  (S_FirstTime) S_Init();
   for (X=0;X<s_indx->A.s_sfiled;X++)
       {
       if  (strcmp(strupr(ScrName),strupr(s_indx->A.s_name[X]))==0)
           {
           S_BuffPtr [X] = ScrBuff;
	   break;
           }
       }
   }




void S_LoadScreen(char *ScrName)
   {
   int A,B,X,Y,Z;
   int RR;
   long rec;
   if  (S_FirstTime) S_Init();
   S_Num = -1;
   for (X=0;X<s_indx->A.s_sfiled;X++)
       {
       if (strcmp(strupr(ScrName),strupr(s_indx->A.s_name[X]))==0)
           {
           S_Num = X;
           break;
           }
       }

   S_Msg[0]=0;

   if  (S_Num==-1)
       {
       strcpy(S_Msg,"<               > has not been found");
       Y=1;
       for (X=0;ScrName[X]!=NULL;X++)
           S_Msg[Y++]=ScrName[X];
       }
   if  (s_indx->A.s_compiledind[S_Num]==0)
       {
       strcpy(S_Msg,"<               > has not been compiled");
       Y=1;
       for (X=0;ScrName[X]!=NULL;X++)
           S_Msg[Y++]=ScrName[X];
       }
   if  (S_Msg[0]>0)
       {
       S_DisplayMessage(S_MessBg,S_MessFg,S_Msg);
       S_CloseScreenFile();
       exit(1);
       }

   S_WorkArea = S_BuffPtr[S_Num];

   rec = (s_indx->A.s_recordnumber[S_Num])*sizeof(*s_record);

   fseek(s_file,rec,0);
   fread(s_record,sizeof(*s_record),1,s_file);

   S_FirstField = 0;
   if  (s_indx->A.s_fieldsrecno[S_Num])
       {
       rec = (s_indx->A.s_fieldsrecno[S_Num])*sizeof(*s_record);
       fseek(s_file,rec,0);
       fread(s_field,sizeof(*s_field),1,s_file);
       S_FirstField = (s_indx->A.s_first[S_Num])-1;
       S_Point      = 0;
       for (X=0;X<s_indx->A.s_count[S_Num];X++)
           {
           Y = s_field->C.s_fieldname[X][0];
           movmem(&s_field->C.s_fieldname[X][1],
                  &s_field->C.s_fieldname[X][0],16);

           s_field->C.s_fieldname[X][Y]=0;
           S_FieldPtr[X] = S_Point;

           if  ((s_field->C.s_type[X]==8)  ||
                (s_field->C.s_type[X]==9)  ||
                (s_field->C.s_type[X]==98) ||
                (s_field->C.s_type[X]==99))
               S_Point = S_Point + s_field->C.s_len[X]+1;
           else
               S_Point = S_Point + sizeof((double)0);

           A = (s_field->C.s_col[X]+s_field->C.s_len[X])*2;
           B = (s_field->C.s_row[X]-1)*160;

           for (Z=((s_field->C.s_col[X]-1)*2);Z<=A;Z+=2)
               s_record->B.s_video[B+Z]=32;
           }
       }
   if  (S_ChangeScreen)
       {
       puttext(1,1,80,24,&s_record->B.s_video[0]);
       S_Point = S_FirstField;
       }
   else
       S_ChangeScreen = 1;
   }




void S_DisplayScreenField(int R,int C,int T,int L,int DL,
                          int DF,int DB,int NF,int NB,char *S)
   {
   int           Attr,x,y,z,l;
   char          Wk[80];
   double        *Dbl;
   unsigned char BackColor, ForColor;

   if  (S_FirstTime) S_Init();
   strcpy(S_EditStr,S);
   DL = strlen(S_EditStr);

   if  (DL>0)
       Attr = (DB * 16) + DF;
   else
       Attr = (NB * 16) + NF;

   setmem(S_NormAttrib,80,Attr);

   l = (L - strlen(S_EditStr))+1;

   if (l > 0)
      {
      movmem(&S_Blanks,&S_Padding,80);
      S_Padding[l]=0;
      }
   else
      {
      S_Padding[0]=32;
      S_Padding[1]=0;
      }

   if ((T > 89)&&(T<98)) T-=89;
   Wk[0]=0;
   if  (T<8)
       {
       strcpy(Wk,S_Padding);
       strcat(Wk,S_EditStr);
       strcat(Wk," ");
       }
   else
       {
       strcat(Wk,S_EditStr);
       strcat(Wk,S_Padding);
       }

   S_Write(R,C,L+1,Wk,S_NormAttrib);

   }





void S_FillScreen()
{
int  Sign,DecPos,S_PointHold,Screen_Point,p,x,y,z,C;
unsigned char WorkAttrib;
double dbl_work, rounding, *Dbl;

S_PointHold = S_Point;
S_Point     = 0;

while (S_Point < s_indx->A.s_count[S_Num])
   {
   S_Decimal = (s_field->C.s_type[S_Point]>89) ?
               (s_field->C.s_type[S_Point] - 90): s_field->C.s_type[S_Point];

   if  (S_Decimal > 7)
       {
       strcpy(S_EditStr,(char*)&S_WorkArea[(int)S_FieldPtr[S_Point]]);
       s_field->C.s_datalen[S_Point] = strlen(S_EditStr);
       }
   else
       {
       dbl_work = *((double *)(S_WorkArea+S_FieldPtr[S_Point]));
       if  (dbl_work!=0)
           {
           rounding = (dbl_work<0)?(0-S_Round[S_Decimal]):S_Round[S_Decimal];
           strcpy(S_EditStr,ecvt((dbl_work+rounding),20,&DecPos,&Sign));
           while (DecPos<1)
               {
               s_insert(S_EditStr,"0",0,20);
               DecPos++;
               }
           s_insert(S_EditStr,".",DecPos,80);
           while (S_EditStr[0]=='0') s_delete(S_EditStr,0,1);
           if  (Sign)
               s_insert(S_EditStr,"-",0,80);
           }
       else
           strcpy(S_EditStr,".000000");
       S_EditStr[(s_pos(S_EditStr,".")+S_Decimal)]=0;
       if  (S_EditStr[0]==0)
           {
           S_EditStr[0]='0';
           S_EditStr[1]=0;
           }
       x = strlen(S_EditStr);
       y = x - s_field->C.s_len[S_Point];

       if  (y>0)
           while (y--)
               {
               s_delete(S_EditStr,0,1);
               x--;
               }
       s_field->C.s_datalen[S_Point] = x;
       }

   Screen_Point = ((s_field->C.s_row[S_Point]-1)*160)
                + ((s_field->C.s_col[S_Point]-1)*2);

   if  (s_field->C.s_datalen[S_Point]>0)
       WorkAttrib = (s_field->C.s_displaybg[S_Point] * 16)
                  + s_field->C.s_displayfg[S_Point];
   else
       WorkAttrib = (s_field->C.s_normalbg[S_Point] * 16)
                  +  s_field->C.s_normalfg[S_Point];

   p=0;
   x=((s_field->C.s_len[S_Point])+2)*2;
   y=(s_field->C.s_datalen[S_Point])*2;
   if (S_Decimal > 7)
      {
      C=0;
      while (C<x)
          {
          if  (C>0)
              s_record->B.s_video[Screen_Point+C]=
                   (C<=y)? S_EditStr[p++]:32;
          else
              s_record->B.s_video[Screen_Point+C]=32;
          C++;
          s_record->B.s_video[Screen_Point+C]= WorkAttrib;
          C++;
          }
      }
   else
      {
      z=(x-y)-4;
      C=0;
      while (C<x)
          {
          if  (C>0)
              s_record->B.s_video[Screen_Point+C]= (C>z)?S_EditStr[p++]:32;
          else
              s_record->B.s_video[Screen_Point+C]=32;
          C++;
          s_record->B.s_video[Screen_Point+C]= WorkAttrib;
          C++;
          }
      }
   S_Point++;
   }

puttext(1,1,80,24,&s_record->B.s_video[0]);
S_Point = S_PointHold;
}



void S_GetKey()
   {
   static int C_nt;
   static unsigned char Two_Keys, Toggle,KeyDetected;
   char ch;
   typedef union
       {
       int ch;
       struct{
	  unsigned char lsb;
          unsigned char msb;
          } byte;
       }keyindef;

   keyindef keyin;
   keyindef shiftstat;

   S_ResetKeyFlags();

   if  (S_Msg[0]!=0)
       S_DisplayMessage(S_MessBg,S_MessFg,S_Msg);

   do
       {
       Two_Keys    = 0;
       Toggle      = 0;
       KeyDetected = 0;
       keyin.ch    = 0;
       while (!KeyDetected)
           {
           while ((!KeyDetected)&&(!Two_Keys)&&(!Toggle))
               {
               shiftstat.ch = bioskey(2);
               C_nt = 0;
               if  (shiftstat.byte.lsb & 1) C_nt++;
               if  (shiftstat.byte.lsb & 2) C_nt++;
               if  (shiftstat.byte.lsb & 4) C_nt++;
               if  (shiftstat.byte.lsb & 8) C_nt++;
               if  (C_nt > 1)
                   Two_Keys = 1;

               if  (shiftstat.byte.lsb & 16)
                   {
                   if (!S_ScrollLock) Toggle = 1;
                   }
               else
                   if  (S_ScrollLock) Toggle = 1;

               if  (shiftstat.byte.lsb & 33)
                   {
                   if (!S_NumLock)   Toggle = 1;
                   }
               else
                   if  (S_NumLock) Toggle = 1;

               if  (shiftstat.byte.lsb & 64)
                   {
                   if (!S_Caps)    Toggle = 1;
                   }
               else
                   if (S_Caps)     Toggle = 1;

               if  (shiftstat.byte.lsb & 128)
                   {
                   if (!S_InsertMode) Toggle = 1;
                   }
               else
                   if  (S_InsertMode) Toggle = 1;
               if (!bioskey(1)==0) KeyDetected = 1;
               }

           if  (KeyDetected)
               keyin.ch = bioskey(0);

           S_RightShift = 0;
           S_LeftShift  = 0;
           S_Shift      = 0;
           S_ScrollLock = 0;
           S_Caps       = 0;
           S_InsertMode = 0;
           S_NumLock    = 0;
           C_nt         = 0;

           if  (shiftstat.byte.lsb & 1){S_RightShift = 1; C_nt++; S_Shift = 1;}
           if  (shiftstat.byte.lsb & 2){S_LeftShift  = 1; C_nt++; S_Shift = 1;}
           if  (shiftstat.byte.lsb & 4){S_Ctrl       = 1; C_nt++;}
           if  (shiftstat.byte.lsb & 8){S_Alt        = 1; C_nt++;}
           if  (shiftstat.byte.lsb & 16)  S_ScrollLock = 1;
           if  (shiftstat.byte.lsb & 32)  S_NumLock    = 1;
           if  (shiftstat.byte.lsb & 64)  S_Caps       = 1;
           if  (shiftstat.byte.lsb & 128) S_InsertMode = 1;

           if  (Two_Keys)
               {
               keyin.ch    = 0;
               S_Ch        = 0;
               S_Fkey      = 1;
               goto Exit;
               }

           if  (S_ShowStatus)
               {
               memset(S_StatusAttrib,2,40);
               if  (S_InsertMode) memset(S_StatusAttrib,32,8);
               if  (S_Caps)       memset(&S_StatusAttrib[9],32,6);
               if  (S_NumLock)    memset(&S_StatusAttrib[16],32,10);
               if  (S_ScrollLock) memset(&S_StatusAttrib[27],32,13);
               setmem(S_Padding,80,32);
               setmem(S_WorkAttrib,80,0);
               memmove((char *)&S_Padding[21],S_StatusLine,40);
               memmove((char *)&S_WorkAttrib[21],S_StatusAttrib,40);
               S_Write(25,1,80,S_Padding,S_WorkAttrib);
               Toggle = 0;
               }
           }
       }
   while (keyin.ch == 0);

   if  ((S_Ctrl) && (keyin.byte.lsb > 0) && (keyin.byte.lsb < 29))
       {
       S_Fkey = 1;
       ch     = keyin.byte.lsb + 64;
       goto Exit;
       }

   ch = 0;

   if  ((keyin.byte.lsb == 0)&&(keyin.byte.msb>0))
       {
       S_Fkey = 1;
       switch (keyin.byte.msb){
         case 59 : S_F1   = 1; break; /* regular fkeys */
         case 60 : S_F2   = 1; break;
         case 61 : S_F3   = 1; break;
         case 62 : S_F4   = 1; break;
         case 63 : S_F5   = 1; break;
         case 64 : S_F6   = 1; break;
         case 65 : S_F7   = 1; break;
         case 66 : S_F8   = 1; break;
         case 67 : S_F9   = 1; break;
         case 68 : S_F10  = 1; break;
         case 133: S_F11  = 1; break;
         case 134: S_F12  = 1; break;
         case 84 : S_F1   = 1; break; /* shifted fkeys */
         case 85 : S_F2   = 1; break;
         case 86 : S_F3   = 1; break;
         case 87 : S_F4   = 1; break;
         case 88 : S_F5   = 1; break;
         case 89 : S_F6   = 1; break;
         case 90 : S_F7   = 1; break;
         case 91 : S_F8   = 1; break;
         case 92 : S_F9   = 1; break;
         case 93 : S_F10  = 1; break;
         case 135: S_F11  = 1; break;
         case 136: S_F12  = 1; break;
         case 94 : S_F1   = 1; break; /* control fkeys */
         case 95 : S_F2   = 1; break;
         case 96 : S_F3   = 1; break;
         case 97 : S_F4   = 1; break;
         case 98 : S_F5   = 1; break;
         case 99 : S_F6   = 1; break;
         case 100: S_F7   = 1; break;
         case 101: S_F8   = 1; break;
         case 102: S_F9   = 1; break;
         case 103: S_F10  = 1; break;
         case 137: S_F11  = 1; break;
         case 138: S_F12  = 1; break;
         case 104: S_F1   = 1; break; /* alt fkeys */
         case 105: S_F2   = 1; break;
         case 106: S_F3   = 1; break;
         case 107: S_F4   = 1; break;
         case 108: S_F5   = 1; break;
         case 109: S_F6   = 1; break;
         case 110: S_F7   = 1; break;
         case 111: S_F8   = 1; break;
         case 112: S_F9   = 1; break;
         case 113: S_F10  = 1; break;
         case 139: S_F11  = 1; break;
         case 140: S_F12  = 1; break;
         case 71 : S_Home = 1; break; /* regular & shift cursor keys */
         case 79 : S_End  = 1; break;
         case 73 : S_PgUp = 1; break;
         case 81 : S_PgDn = 1; break;
         case 75 : S_Left = 1; break;
         case 77 : S_Right= 1; break;
         case 72 : S_Up   = 1; break;
         case 80 : S_Down = 1; break;
         case 82 : S_Ins  = 1; break;
         case 83 : S_Del  = 1; break;
         case 15 : S_Tab  = 1; break;
         case 119: S_Home = 1; break; /* control cursor control keys */
         case 117: S_End  = 1; break;
         case 132: S_PgUp = 1; break;
         case 118: S_PgDn = 1; break;
         case 115: S_Left = 1; break;
         case 116: S_Right= 1; break;
         case 16 : ch     = 'Q'; break; /* alt alpha keys */
         case 17 : ch     = 'W'; break;
         case 18 : ch     = 'E'; break;
	 case 19 : ch     = 'R'; break;
	 case 20 : ch     = 'T'; break;
	 case 21 : ch     = 'Y'; break;
	 case 22 : ch     = 'U'; break;
	 case 23 : ch     = 'I'; break;
	 case 24 : ch     = 'O'; break;
         case 25 : ch     = 'P'; break;
         case 30 : ch     = 'A'; break;
	 case 31 : ch     = 'S'; break;
	 case 32 : ch     = 'D'; break;
	 case 33 : ch     = 'F'; break;
	 case 34 : ch     = 'G'; break;
	 case 35 : ch     = 'H'; break;
	 case 36 : ch     = 'J'; break;
	 case 37 : ch     = 'K'; break;
	 case 38 : ch     = 'L'; break;
	 case 44 : ch     = 'Z'; break;
	 case 45 : ch     = 'X'; break;
	 case 46 : ch     = 'C'; break;
	 case 47 : ch     = 'V'; break;
	 case 48 : ch     = 'B'; break;
	 case 49 : ch     = 'N'; break;
	 case 50 : ch     = 'M'; break;
	 case 129: ch     = '0'; break;
	 case 120: ch     = '1'; break;
	 case 121: ch     = '2'; break;
	 case 122: ch     = '3'; break;
	 case 123: ch     = '4'; break;
	 case 124: ch     = '5'; break;
	 case 125: ch     = '6'; break;
	 case 126: ch     = '7'; break;
	 case 127: ch     = '8'; break;
	 case 128: ch     = '9'; break;
	 case 130: ch     = '-'; break;
	 case 131: ch     = '='; break;
	 case 114: ch     = '*'; break;
         }
       }
   if  ((keyin.byte.msb != 0) &&
        (!S_Alt))
       {
       switch (keyin.byte.lsb)
           {
           case   9 : {S_Tab   = 1;break;}
           case   8 : {S_BkSp  = 1;break;}
           case 127 : {S_BkSp  = 1;break;}
           case  27 : {S_Esc   = 1;break;}
           case  13 : {S_Enter = 1;break;}
           default  : ch = keyin.byte.lsb;
           }
       if  ((S_Tab)||(S_BkSp)||(S_Esc)||(S_Enter))
           S_Fkey = 1;
       }
   Exit:
   S_Ch = ch;
   }






void S_Get_Field_Value(int S_Point)
   {
   int    DecPos,Sign,x,y,z;
   double dbl_work,rounding;

   S_Decimal = (s_field->C.s_type[S_Point]>89) ?
               (s_field->C.s_type[S_Point] - 90): s_field->C.s_type[S_Point];

   if  (S_Decimal > 7)
       strcpy(S_EditStr,(char*)&S_WorkArea[(int)S_FieldPtr[S_Point]]);
   else
       {
       dbl_work = *((double *)(S_WorkArea+S_FieldPtr[S_Point]));
       if  (dbl_work!=0)
           {
           rounding = (dbl_work<0)?(0-S_Round[S_Decimal]):S_Round[S_Decimal];
           strcpy(S_EditStr,(char *)ecvt((dbl_work+rounding),
                  20,&DecPos,&Sign));
           while (DecPos<0)
               {
               s_insert(S_EditStr,"0",0,20);
               DecPos++;
               }
           s_insert(S_EditStr,".",DecPos,80);
           while (S_EditStr[0]=='0') s_delete(S_EditStr,0,1);
           if  (Sign)
               s_insert(S_EditStr,"-",0,80);
           }
       else
           strcpy(S_EditStr,".000000");
       S_EditStr[(s_pos(S_EditStr,".")+S_Decimal)]=0;
       if  (S_EditStr[0]==0)
           {
           S_EditStr[0]='0';
           S_EditStr[1]=0;
           }
       x = strlen(S_EditStr);
       y = x - s_field->C.s_len[S_Point];

       if  (y>0)
           while (y--)
               {
               s_delete(S_EditStr,0,1);
               x--;
               }
       s_field->C.s_datalen[S_Point] = x;
       }
   }





void S_EditString (int R, int C, int T, int L, int B,
                   int F, int DB, int DF, int NB, int NF,
                   int HR, int HL, char *S)
   {
   int    x,y,z;
   static char   S_CurString[160];
   double DoubleWork;
   long   rec;

   if  (S_FirstTime) S_Init();
   S_SetCursor(S_Cursor);

   if  ( (s_pos("0.000000",S)==0) || (s_pos(".000000",S)==0) )
       S[0]=0;

   S_Str_Pos = 1;

   strcpy(S_Ins_Str," ");

   S_Attrib  = (B*16)+F;
   S_Reverse = (S_Attrib > 16) ? 15:((7*16)+F);

   strcpy(S_WorkStr,S_Blanks);

   x = 0;

   while (S[x]!=0) S_WorkStr[x]=S[x++];
   S_WorkStr[L]=0;
   S_Str_Pos = 1;
   if  (S_PosLastChar)
       {
       S_Str_Pos = s_strlen(S)-1;
       if (S_Str_Pos < 0)
          S_Str_Pos = 1;
       else
          if (S_Str_Pos < L) S_Str_Pos++;
       }
   S_PosLastChar = 0;

   S_ResetKeyFlags();


   while ((!S_Enter)&&(!S_Tab)&&(!S_Esc)&&(!S_Fkey))
       {
       setmem(S_CurString,160,0);
       S_CurString[0]=32;
       S_CurString[1]=S_Attrib;
       x = 0;
       y = 0;
       while (x<L)
          {
          y = (x*2)+2;
          S_CurString[y]   =S_WorkStr[x];
          S_CurString[y+1] =S_Attrib;
          x++;
          }
       y = (x*2)+2;
       S_CurString[y]  =32;
       S_CurString[y+1]=S_Attrib;

       S_CurString[(S_Str_Pos*2)+1]=S_Reverse;
       puttext(C,R,C+(L+1),R,(char *)&S_CurString);
       gotoxy((C+S_Str_Pos),R);

       S_GetKey();

       S_CurString[(S_Str_Pos*2)+1]=S_Attrib;

       puttext(C,R,C+(L+1),R,(char *)&S_CurString);

       if  (S_Ins)
           {
           S_Ins  = 0;
           S_Fkey = 0;
           continue;
           }

       if  ((S_Left)||(S_BkSp))
           {
           if  (S_Str_Pos > 1)
               {
               S_Str_Pos--;
               if  (S_BkSp) S_Del = 1;
               }
           else
               {
               if  (S_Left)
                   {
                   S_Shift       = 1;
                   S_Tab         = 1;
                   S_PosLastChar = 1;
                   }
               }
           S_Left  = 0;
           S_BkSp  = 0;
           S_Fkey  = 0;
           if  (!S_Del) continue;
           }

       if  (S_Right)
           {
           if  (S_Str_Pos < L)
               {
               if  (T>7)
                   S_Str_Pos++;
               else
                   {
                   if  (S_Str_Pos==(s_strlen(S_WorkStr)+1))
                       S_Tab = 1;
                   else
                       S_Str_Pos++;
                   }
               }
           else
               S_Tab = 1;
           S_Shift = 0;
           S_Right = 0;
           S_Fkey  = 0;
           continue;
           }

       if  (S_Del)
           {
           if  (s_strlen(S_WorkStr)>-1)
               {
               s_delete(S_WorkStr,(S_Str_Pos-1),1);
               strcat(S_WorkStr," ");
               }
           S_Fkey = 0;
           continue;
           }

       if  ((S_Ch > 31)&&(S_Ch < 128))
           {
           if  (T<8)
               {
               if  (S_Ch=='?')
                   {
                   if  (S_Str_Pos > 1) S_Ch = 0;
                   }
               else
                   {
                   if  (((S_Ch=='-')&&(S_Str_Pos>1))||
		        ((S_Ch=='.')&&(T==0))||
		        ((S_Ch!='.')&&(S_Ch!='-')&&((S_Ch<'0')||(S_Ch>'9'))))
                   S_Ch = 0;
                   }
               }
           if  (T==8)
               {
               if  (S_Ch=='?')
                   {
                   if  (S_Str_Pos > 1) S_Ch = 0;
                   }
               else
                   {
	           if  ((S_Ch!=32)&&
                        ((S_Ch<'A')||(S_Ch>'Z'))&&
		        ((S_Ch<'a')||(S_Ch>'z')))
                   S_Ch = 0;
                   }
               }
           if  (S_Ch>0)
               {
               if  (S_InsertMode)
                   {
                   S_Ins_Str[0]=S_Ch;
                   S_Ins_Str[1]=0;
                   s_insert(S_WorkStr,S_Ins_Str,(S_Str_Pos-1),L);
                   S_WorkStr[L]=0;
                   if  (S_Str_Pos < L)
                       S_Str_Pos++;
                   else
                       {
                       S_Tab  =1;
                       S_Shift=0;
                       }
                   continue;
                   }
               else
                   {
                   S_WorkStr[S_Str_Pos-1]=S_Ch;
                   if  (S_Str_Pos < L)
                       S_Str_Pos++;
                   else
                       {
                       S_Tab  =1;
                       S_Shift=0;
                       }
                   continue;
                   }
               }
           }
       if  (((S_Enter)||(S_Tab))&&(S_WorkStr[0] == '?'))
           {
           S_Msg[0] = 0;
           if  (HR > 0)
               {
               rec = HR * sizeof(*s_record);
               fseek(s_file,rec,0);
               fread(s_indx,sizeof(*s_field),1,s_file);
               if  (s_indx->D.s_rangelist[HL-1][1]=='H')
                   {
                   s_indx->D.s_rangelist[HL-1][s_indx->D.s_rangelist[HL-1][0]]=0;
                   strcpy(S_Msg,&s_indx->D.s_rangelist[HL-1][6]);
                   }
               rec = 0;
               fseek(s_file,rec,0);
               fread(s_indx,sizeof(*s_field),1,s_file);
               for (x=0;x < s_indx->A.s_sfiled;x++)
                   {
                   y = s_indx->A.s_name[x][0];
                   for (z=1;z< (y+2);z++)
                       s_indx->A.s_name[x][z-1]=
                       s_indx->A.s_name[x][z];
                   s_indx->A.s_name[x][y]=0;
                   }
               }
           if (S_Msg[0] == 0)
               strcpy(S_Msg," No Help is available for this field ");
           S_Str_Pos = S_Str_Pos - 1;
           strcpy(S_WorkStr,&S_WorkStr[1]);
           S_Enter = 0;
           S_Tab   = 0;
           S_Wait  = 1;
           S_Fkey  = 0;
           }
       }

   S_SetCursor(S_OFF);
   strcpy(S_EditStr,S_WorkStr);
   if  (s_strlen(S_WorkStr)>-1)
       S_EditStr[s_strlen(S_WorkStr)]=0;
   if  (T<8)
       {
       y=strlen(S_EditStr);
       while ((y>0)&&(S_EditStr[y-1]<33))
          {
          S_EditStr[y-1]=0;
          y--;
          }
       if  (strchr(S_EditStr,'.')==NULL)
           strcat(S_EditStr,".000000");
       else
           strcat(S_EditStr,"000000");
       S_EditStr[s_pos(S_EditStr,".")+T]=0;
       S_Str_Pos = (S_EditStr[0]=='-')?1:0;
       while ((S_EditStr[0]==32)||(strlen(S_EditStr)>L))
	     s_delete(S_EditStr,S_Str_Pos,1);
       if  (strcmp("-",S_EditStr)==0) S_EditStr[0]=0;
       }
   strcpy(S_NewStr,S_EditStr);
   S_WorkStr[0]=32;
   S_WorkStr[1]=0;
   strcat(S_WorkStr,S_EditStr);
   strcat(S_WorkStr," ");
   S_DisplayScreenField(R,C,T,L,strlen(S_WorkStr),DF,DB,NF,NB,S_WorkStr);
   strcpy(S_EditStr,S_NewStr);
   }



void S_Find_Min_and_Max()
{
int C1, C2, s_len;

S_CompMin[0]=0;
S_CompMax[0]=0;
C1 = 0;
C2 = 0;

s_len=strlen(S_CurStr);

S_Min_Max_Loaded = 0;
S_EndofLine    = 0;

while (!S_Min_Max_Loaded)
    {
    S_Sub++;
    if  (S_Sub<s_len)
        {
        if  (S_CurStr[S_Sub]==94)
            {
            S_Sub++;
            S_CompMax[C2++]=S_CurStr[S_Sub];
            }
        else
            {
            if  (S_CurStr[S_Sub]==39)
                {
                if  (S_CompMax[0]==0)
                    strcpy(S_CompMax,S_CompMin);
                S_Min_Max_Loaded = 1;
                }
            else
                {
                if  (S_CompMax[0]==0)
                    {
                    S_CompMin[C1++]=S_CurStr[S_Sub];
                    S_CompMin[C1]=0;
                    }
                else
                    {
                    S_CompMax[C2++]=S_CurStr[S_Sub];
                    S_CompMax[C2]=0;
                    }
                }
            }
        if  ((S_CompMin[0]==92)||(S_CompMin[0]==61))
            S_Min_Max_Loaded = 1;
        }
    else
        {
        S_Min_Max_Loaded=1;
        S_EndofLine   =1;
        }
    }
if  (S_UpCase)
    {
    strcpy(S_CompMin,strupr(S_CompMin));
    strcpy(S_CompMax,strupr(S_CompMax));
    }
}


void S_ReadNextRangeRec()
{
long rec;

S_CurrLine = S_NextLine;

if  (S_RecNo != S_NextRec)
    {
    rec = (S_NextRec)*sizeof(*s_record);
    fseek(s_file,rec,0);
    fread(s_record,sizeof(*s_record),1,s_file);
    S_RecNo = S_NextRec;
    }

S_NextRec   = s_record->D.s_rangerec [S_CurrLine];
S_NextLine  = s_record->D.s_rangeline[S_CurrLine]-1;
movmem(&s_record->D.s_rangelist[S_CurrLine][1],&S_CurStr,
       s_record->D.s_rangelist[S_CurrLine][0]);
S_CurStr[s_record->D.s_rangelist[S_CurrLine][0]]=0;
S_Sub = (S_InsideIf) ? 4:1;
S_CompMin[0]=0;
S_CompMax[0]=0;

}



void S_ProcessDate()
{
char
   DateMask[40],
   TestMonth[3],
   TestDay[3],
   TestYear[5],
   CheckMonth,
   CheckDay,
   CheckYear;
int
   x,y,z,
   WorkMonth,
   WorkDay,
   WorkYear,
   WorkNum;

CheckMonth   = 0;
CheckDay     = 0;
CheckYear    = 0;
WorkMonth    = 0;
WorkDay      = 0;
WorkYear     = 0;
S_Msg[0]     = 0;
x = (S_InsideIf) ? 8:5;
z = x;
y = 0;

while (S_CurStr[x]!=0)
    {
    switch (S_CurStr[x])
        {
        case 'D':{
                 if  (!isdigit(S_EditStr[y]))
                     {
                     strcpy(S_Msg,"Day contains a invalid character for <");
                     strcat(S_Msg,(char *)&S_CurStr[z]);
                     strcat(S_Msg,"> Format");
                     goto Exit_Point;
                     }
                 CheckDay++;
                 TestDay[CheckDay-1]=S_EditStr[y];
                 TestDay[CheckDay]  =0;
                 break;
                 }
        case 'M':{
                 if  (!isdigit(S_EditStr[y]))
                     {
                     strcpy(S_Msg,"Month contains a invalid character for <");
                     strcat(S_Msg,(char *)&S_CurStr[z]);
                     strcat(S_Msg,"> Format");
                     goto Exit_Point;
                     }
                 CheckMonth++;
                 TestMonth[CheckMonth-1]=S_EditStr[y];
                 TestMonth[CheckMonth]  =0;
                 break;
                 }
        case 'Y':{
                 if  (!isdigit(S_EditStr[y]))
                     {
                     strcpy(S_Msg,"Year contains a invalid character for <");
                     strcat(S_Msg,(char *)&S_CurStr[z]);
                     strcat(S_Msg,"> Format");
                     goto Exit_Point;
                     }
                 CheckYear++;
                 TestYear[CheckYear-1]=S_EditStr[y];
                 TestYear[CheckYear]  =0;
                 break;
                 }
        default :{
                 if  (S_EditStr[y]!=S_CurStr[x])
                     {
                     strcpy(S_Msg,"Please enter date in <");
                     strcat(S_Msg,(char *)&S_CurStr[z]);
                     strcat(S_Msg,"> Format");
                     goto Exit_Point;
                     }
                 }
        }
    y++;
    x++;
    }

if  (S_EditStr[y]!=0)
    {
    strcpy(S_Msg,"You have keyed to many charactes for <");
    strcat(S_Msg,(char *)&S_CurStr[z]);
    strcat(S_Msg,"> Format");
    goto Exit_Point;
    }

WorkDay   = (CheckDay  >0) ? atoi(TestDay)  :0;
WorkMonth = (CheckMonth>0) ? atoi(TestMonth):0;
WorkYear  = (CheckYear >0) ? atoi(TestYear) :0;
WorkNum   = (WorkYear/4);
WorkNum  *= 4;
WorkNum  -= WorkYear;

if  ((CheckMonth>0)&&((WorkMonth < 1)||(WorkMonth>12)))
    {
    strcpy(S_Msg,"You have keyed a invalid Month. Use 1 thru 12 only");
    goto Exit_Point;
    }

if  (CheckDay>0)
    {
    if  ((WorkMonth==4)||(WorkMonth==6)||(WorkMonth==9)||(WorkMonth==11))
        {
        if  (WorkDay>30)
            {
            strcpy(S_Msg,"This month can have only 30 days or less");
            goto Exit_Point;
            }
        }
    else
        {
        if  ((WorkMonth!=2)&&(WorkDay>31))
            {
            strcpy(S_Msg,"This month can have only 31 days or less");
            goto Exit_Point;
            }
        else
            {
            if  (WorkMonth == 2)
                {
                if  (WorkNum==0)
                    {
                    if  (WorkDay>29)
                        {
                        strcpy(S_Msg,"February can have only 29 days or less");
                        goto Exit_Point;
                        }
                    }
                else
                    {
                    if  (WorkDay>28)
                        {
                        strcpy(S_Msg,"February can have only 28 days or less");
                        goto Exit_Point;
                        }
                    }
                }
            }
        }
    }

if  ((CheckYear>0)&&(WorkYear<1))
    {
    strcpy(S_Msg,"Year must have a value greater than zero.");
    goto Exit_Point;
    }

Exit_Point:

if  (S_Msg[0]!=0)
    {
    S_ScreenValid       = 0;
    S_Validate_Finished = 1;
    S_PointHold         = 0;
    S_Skip              = 1;
    }
}



void S_ProcessIn()
{
int x,y,z;

S_Decimal = (s_field->C.s_type[S_Point]>89)
          ? (s_field->C.s_type[S_Point] - 90)
          : s_field->C.s_type[S_Point];

S_Matched    = 0;
S_CompMin[0] = 0;

if  (!S_Matched)
    {
    while ((!S_Matched)&&(S_CompMin[0]!=92)&&(S_CompMin[0]!='='))
        {
        S_Find_Min_and_Max();
        if  ((S_CompMin[0]!=92)&&(S_CompMin[0]!='=')&&(!S_EndofLine))
            {
            if  (S_Decimal < 8)
                {
                S_Numeric       = atof(S_EditStr);
                S_CompMin_Numeric = atof(S_CompMin);
                S_CompMax_Numeric = atof(S_CompMax);
                if  ((S_Numeric >= S_CompMin_Numeric) &&
                    (S_Numeric  <= S_CompMax_Numeric))
                    S_Matched = 1;
                }
            else
                {
                if  ((strcmp(S_EditStr,S_CompMin)>=0) &&
                    (strcmp(S_EditStr,S_CompMax)<=0))
                    S_Matched = 1;
                }
            }
        if  ((S_EndofLine) && ((S_CompMin[0]==0) && (S_CompMax[0]==0)))
            {
            S_ReadNextRangeRec();
            while ((S_CurStr[S_Sub]!=39)&&
                   (S_CurStr[S_Sub]!=92)&&
                   (S_CurStr[S_Sub++]!='='));
            if  ((S_CurStr[S_Sub]==92)||(S_CurStr[S_Sub]=='='))
                {
                S_CompMin[0]=S_CurStr[S_Sub];
                S_CompMin[1]=0;
                }
            }
        }
    }

if  (S_Matched)
    {
    while ((S_CurStr[S_Sub]!=92)&&(S_CurStr[S_Sub]!='='))
        {
        S_Sub=0;
        while ((S_CurStr[S_Sub]!=0)&&
               (S_CurStr[S_Sub]!=92)&&
               (S_CurStr[S_Sub]!='=')) S_Sub++;
        if  ((S_CurStr[S_Sub]!=92)&&(S_CurStr[S_Sub]!='='))
            {
            S_ReadNextRangeRec();
            S_Sub=0;
            }
        }
    if  (S_CurStr[S_Sub]=='=')
        {
        S_ScreenValid       = 0;
        S_Validate_Finished = 1;
        S_PointHold         = 0;
        x                   = strlen(S_CurStr);
        s_copy(S_CurStr,S_Msg,S_Sub+1,x-S_Sub);
        }
    else
        {
        S_OpCode[0]=0;
        S_Matched = 0;
        }
    }
else
    {
    if  (S_CurStr[S_Sub]==92)
        {
        S_ScreenValid       = 0;
        S_Validate_Finished = 1;
        S_PointHold         = 0;
        x                   = strlen(S_CurStr);
        s_copy(S_CurStr,S_Msg,S_Sub+1,x-S_Sub);
        }
    else
        S_OpCode[0]=0;
    }
}



void S_Processif()
{
int c,x,y,z;
S_Matched = 0;
S_CompMin[0]=0;
S_CompMax[0]=0;
S_EndofLine =0;

while (strcmp(S_CompMin,"THEN")!=0)
   {
   if  (S_EndofLine)
       {
       S_ReadNextRangeRec();
       S_Sub=0;
       while ((S_CurStr[S_Sub]!=0)&&(S_CurStr[S_Sub]!=39)) S_Sub++;
       }

   if  (S_CurStr[3]=='N')
       {
       x = 7;
       S_OpCode1[0]='N';
       }
   else
       {
       x = 3;
       S_OpCode1[0]=0;
       }

   y=0;
   while (x>0)
       {
       if  ((S_CurStr[x]!=39)&&(S_CurStr[x]!=32))
           S_CompField[y++]=S_CurStr[x++];
       else
           x=0;
       S_CompField[y]=0;
       }

   strupr(S_CompField);

   S_FieldNum = 0;
   x        = 1;
   while (x)
       {
       if  (S_FieldNum == s_indx->A.s_count[S_Num])
           {
           S_FieldNum = -1;
           x        = 0;
           }
       else
           if  (strcmp(S_CompField,strupr(s_field->C.s_fieldname[S_FieldNum]))==0)
               x=0;
           else
               S_FieldNum++;
       }

   S_CompMin[0]=0;
   S_CompMax[0]=0;

   if  (S_FieldNum > -1)
       S_Get_Field_Value(S_FieldNum);
   else
       strcpy(S_CompMin,"THEN");

   if  (S_UpCase)
       strupr(S_EditStr);

   S_Decimal = (s_field->C.s_type[S_FieldNum]>89) ?
               (s_field->C.s_type[S_FieldNum] - 90): s_field->C.s_type[S_FieldNum];


   S_EndofLine = 0;
   while ((strcmp(S_CompMin,"AND")!=0)&&
       (strcmp(S_CompMin,"OR")!=0)&&
       (strcmp(S_CompMin,"THEN")!=0))
       {
       if  (S_EndofLine)
           {
           S_ReadNextRangeRec();
           S_Sub=0;
           while ((S_CurStr[S_Sub]!=0)&&(S_CurStr[S_Sub]!=39)) S_Sub++;
           }
       S_Find_Min_and_Max();
       if  ((strcmp(S_CompMin,"AND")!=0)&&
            (strcmp(S_CompMin,"OR")!=0) &&
            (strcmp(S_CompMin,"THEN")!=0))
           {
           if  (S_Decimal<7)
               {
               S_Numeric         = atof(S_EditStr);
               S_CompMin_Numeric = atof(S_CompMin);
               S_CompMax_Numeric = atof(S_CompMax);
               if  (S_OpCode1[0]=='N')
                   {
                   if  ((S_Numeric < S_CompMin_Numeric)||
                        (S_Numeric > S_CompMax_Numeric))
                        S_Matched = 1;
                   }
               else
                   {
                   if  ((S_Numeric >= S_CompMin_Numeric)&&
                        (S_Numeric <= S_CompMax_Numeric))
                        S_Matched = 1;
                   }
               }
           else
               {
               if  (S_OpCode1[0]=='N')
                   {
                   if  ((strcmp(S_EditStr,S_CompMin)<0)||
                        (strcmp(S_EditStr,S_CompMax)>0))
                       S_Matched = 1;
                   }
               else
                   if  ((strcmp(S_EditStr,S_CompMin)>=0)&&
                        (strcmp(S_EditStr,S_CompMax)<=0))
                       S_Matched = 1;

               }
           }
       }
   if  (strcmp(S_CompMin,"AND")==0)
       {
       if  (!S_Matched)
           {
           S_CompMin[0]=0;
           while ((strcmp(S_CompMin,"OR")!=0)
               &&(strcmp(S_CompMin,"THEN")!=0))
               {
               S_ReadNextRangeRec();
               S_Sub=0;
               while ((S_CurStr[S_Sub]!=0)&&(S_CurStr[S_Sub]!=39)) S_Sub++;
               S_CompMin[0]=0;
               while ((strcmp(S_CompMin,"AND")!=0)
                   &&(strcmp(S_CompMin,"OR")!=0)
                   &&(strcmp(S_CompMin,"THEN")!=0))
                   S_Find_Min_and_Max();
               }
           if  (strcmp(S_CompMin,"OR")==0)
               S_CompMin[0]=0;
           }
       else
           {
           S_CompMin[0] = 0;
           S_Matched    = 0;
           }
       }
   else
       {
       if  (strcmp(S_CompMin,"OR")==0)
           {
           if  (S_Matched)
               {
               while (strcmp(S_CompMin,"THEN")!=0)
                   {
                   S_ReadNextRangeRec();
                   S_Sub=0;
                   while ((S_CurStr[S_Sub]!=0)&&(S_CurStr[S_Sub]!=39)) S_Sub++;
                   while ((strcmp(S_CompMin,"AND")!=0)
                       &&(strcmp(S_CompMin,"OR")!=0)
                       &&(strcmp(S_CompMin,"THEN")!=0))
                       S_Find_Min_and_Max();
                   }
               }
           else
               S_CompMin[0]=0;
           }
       }
   }


strcpy(S_EditStr,S_EditStrHold);

if  (S_Matched)
    {
    S_Matched  = 0;
    S_InsideIf = 1;
    while ((S_ScreenValid)&&(S_CurStr[0]!='E')&&(!S_Skip))
        {
        S_ReadNextRangeRec();
        if  (S_CurStr[0]!='E')
            {
            switch (S_CurStr[3])
                {
                case 'D' : {S_ProcessDate();break;}
                case 'I' : {S_Sub=0;
                           while ((S_CurStr[S_Sub]!=0)&&
                                (S_CurStr[S_Sub]!=39)) S_Sub++;
                           S_ProcessIn();
                           break;
                           }
                case 'S' : {S_Skip = 1;break;}
                case 'E' : {S_ScreenValid = 0;
                           strcpy(S_Msg,&S_CurStr[9]);
                           }
                }
            }
        }
    S_InsideIf = 0;
    }
while (strcmp(S_CurStr,"ENDIF")!=0)
    S_ReadNextRangeRec();

}


void S_Validate_Location()
{
int x,y,z;

S_UpCase         = 0;
S_InsideIf       = 0;
S_Matched        = 0;
S_Skip           = 0;
S_OpCode[0]      = 0;
S_CurrLine       = 9999;
while ((S_NextRec)&&(!S_Skip))
    {
    S_ReadNextRangeRec();
    if  (S_CurStr[0] == 'I') /* check for IN or if */
        {
        S_Sub = s_pos(S_CurStr,"'");
        if  (S_CurStr[1] == 'F')
            S_Processif();
        else
            S_ProcessIn();
        if  (S_Validate_Finished)
            S_NextRec = 0;
        }
    if  (S_CurStr[0] == 'U') /* check for Upshift key word */
        {
        if  (S_CurStr[10] == 'N') /* if ON */
            {
            S_UpCase = 1;
            strupr(S_EditStr);
            }
        else
            {
            S_UpCase = 0;      /* if Off */
            strcpy(S_EditStr,S_NewStr);
            }
        strcpy(S_EditStrHold,S_EditStr);
        }
    if  ((S_CurStr[0] == 'R')||(S_CurStr[0] == 'S'))
        {
        x = strlen(S_EditStr);
        while ((x>0)&&(S_EditStr[x-1]<33))
            {
            S_EditStr[x-1]=0;
            x++;
            }
        if  (S_EditStr[0]==0)
            {
            if  (S_CurStr[0]=='S')
                S_NextRec = 0;
            if  (S_CurStr[0]=='R')
                {
                S_Sub = 0;
                while ((S_CurStr[S_Sub]!=0)&&(S_CurStr[S_Sub]!=39)) S_Sub++;
                if  (S_CurStr[S_Sub]==39)
                    strcpy(S_Msg,(char *)&S_CurStr[S_Sub]);
                else
                    strcpy(S_Msg,"** This field is required **");
                S_ScreenValid = 0;
                S_NextRec = 0;
                }
            }
        }
    if  (S_CurStr[0]=='D') /* Process Date pattern */
        S_ProcessDate();
    }
}




void S_ValidateScreen()
{
S_Point             = 0;
S_PointHold         = 0;
S_RecNo             = 9999;
S_UpCase            = 0;
S_Validate_Finished = 0;

if  (S_ValidateField > -1)
    S_Point = S_ValidateField;

while (!S_Validate_Finished)
   {
   if  (S_Point < s_indx->A.s_count[S_Num])
       {

       S_NextRec  = s_field->C.s_rangenextrec [S_Point];
       S_NextLine = s_field->C.s_rangenextline[S_Point]-1;

       if  (S_NextRec)
           {
           S_PointHold   = S_Point;
           S_ScreenValid = 1;
           S_Get_Field_Value(S_Point);
           strcpy(S_EditStrHold,S_EditStr);
           strcpy(S_NewStr,S_EditStr);
           S_Validate_Location();
           if  ((!S_ScreenValid)||(S_ValidateField > -1))
               {
               S_Validate_Finished = 1;
               S_ResetKeyFlags();
               S_Point--;
               }
           }
       S_Point++;
       }
   else
       {
       S_Validate_Finished = 1;
       }
   }

S_ChangeScreen = 0;
S_PointHold    = S_Point;

strcpy(S_NewStr,S_Msg);
S_LoadScreen(s_indx->A.s_name[S_Num]);
strcpy(S_Msg,S_NewStr);

S_Point = S_PointHold;

S_ValidateField = -1;
}



void S_NextKey()
{
char ShowStatusHold;
if  (S_FirstTime) S_Init();
ShowStatusHold = S_ShowStatus;
S_Wait         = 0;
S_GetKey();
S_ShowStatus = ShowStatusHold;
}




void S_ReadKey()
{
if  (S_FirstTime) S_Init();
if  (s_indx->A.s_count[S_Num] > 0)
    S_FillScreen();
if  (S_Msg[0]!=0)
    S_Wait=1;
S_GetKey();
}




void S_ReadField()
{
double *Dbl;
int x,y;
if  (S_FirstTime) S_Init();
if  (s_indx->A.s_count[S_Num] > 0)
    S_FillScreen();

if  ((S_Point < 0) || (S_Point > s_indx->A.s_count[S_Num]))
    {
    strcpy(S_Msg," Field number in S_Point is out of range ");
    S_ReadKey();
    goto Exit_Proc;
    }

if  (s_field->C.s_type[S_Point] > 9)
    {
    strcpy(S_Msg," Cannot read a DISPLAY only field - Any key to continue ");
    S_ReadKey();
    goto Exit_Proc;
    }

S_PointHold   = S_Point;
S_ScreenValid = 0;
S_ResetKeyFlags();

while ((!S_ScreenValid)&&(!S_Fkey))
    {
    if  (S_Msg[0]!=0)
    S_Wait=1;

    S_Get_Field_Value(S_Point);

    while ((!S_Enter)&&(S_PointHold == S_Point)&&(!S_Fkey))
        {
        S_EditString(s_field->C.s_row[S_Point],
                     s_field->C.s_col[S_Point],
                     s_field->C.s_type[S_Point],
                     s_field->C.s_len[S_Point],
                     s_field->C.s_promptbg[S_Point],
                     s_field->C.s_promptfg[S_Point],
                     s_field->C.s_displaybg[S_Point],
                     s_field->C.s_displayfg[S_Point],
                     s_field->C.s_normalbg[S_Point],
                     s_field->C.s_normalfg[S_Point],
                     s_field->C.s_rangenextrec[S_Point],
                     s_field->C.s_rangenextline[S_Point],
                     S_EditStr);

        s_field->C.s_datalen[S_Point] = strlen(S_EditStr);

        if  ((s_field->C.s_type[S_Point] < 8) ||
             ((s_field->C.s_type[S_Point] > 89)&&
              (s_field->C.s_type[S_Point] < 98)))
             {
             x=0;
             y=0;
             while (S_EditStr[x]!=0)
                 if (S_EditStr[x++]=='.') {y=1;break;};
             if  (y==0)
                 strcat(S_EditStr,".0 ");
             else
                 strcat(S_EditStr,"0 ");
             Dbl = (double *)(S_WorkArea+S_FieldPtr[S_Point]);
             *Dbl=atof(S_EditStr);
             }
         else
             {
             y=strlen(S_EditStr);
             while ((y>0)&&(S_EditStr[y-1]<33))
                 {
                 S_EditStr[y-1]=0;
                 y--;
                 }
             strcpy((char *)S_WorkArea+S_FieldPtr[S_Point],S_EditStr);
             }
        if  (S_Tab) S_Fkey = 1;
        }

    S_Point = S_PointHold;

    if  ((S_Tab)||(S_Enter)||(S_LeftArrow)||(S_RightArrow))
        {
        if  (s_field->C.s_rangenextrec[S_Point]>0)
            {
            S_ValidateField = S_Point;
            S_ValidateScreen();
            S_ValidateField = 0;
            if  (!S_ScreenValid)
                S_ResetKeyFlags();
            }
        else
            if  ((strlen(S_EditStr) > s_field->C.s_len[S_Point])||(S_Enter))
                S_ScreenValid = 1;
        }
   }
Exit_Proc:
delay(0);
}




void S_ReadScreen()
   {
   int x,y;
   double *Dbl;
   if  (S_FirstTime) S_Init();
   switch (s_indx->A.s_compiledind[S_Num])
       {
       case 1 : {S_ReadKey();break;}
       case 2 : {S_ReadKey();break;}
       case 3 : {
                S_ScreenValid   = 0;
                S_ValidateField = -1;
                do
                  {
                  S_FillScreen();
                  if  (S_Msg[0]!=0) S_Wait=1;

                  S_PointHold = -99;

                  if  ((S_Point > s_indx->A.s_count[S_Num])||(S_Point < 0))
                      S_Point = (s_indx->A.s_first[S_Num]-1);

                  do
                     {
                     if  (S_PointHold != S_Point)
                         {
                         while (s_field->C.s_type[S_Point] > 9)
                             {
                             S_Point = (S_Direction > 0)
                                     ? s_field->C.s_next[S_Point]-1
                                     : s_field->C.s_prev[S_Point]-1;
                             }
                          S_PointHold = S_Point;
                          }
                     S_Get_Field_Value(S_Point);

                     S_Direction = 1;
                     S_EditString(s_field->C.s_row[S_Point],
                          s_field->C.s_col[S_Point],
                          s_field->C.s_type[S_Point],
                          s_field->C.s_len[S_Point],
                          s_field->C.s_promptbg[S_Point],
                          s_field->C.s_promptfg[S_Point],
                          s_field->C.s_displaybg[S_Point],
                          s_field->C.s_displayfg[S_Point],
                          s_field->C.s_normalbg[S_Point],
                          s_field->C.s_normalfg[S_Point],
                          s_field->C.s_rangenextrec[S_Point],
                          s_field->C.s_rangenextline[S_Point],
                          S_EditStr);

                     s_field->C.s_datalen[S_Point] = strlen(S_EditStr);

                     if  ((s_field->C.s_type[S_Point] < 8) ||
                          ((s_field->C.s_type[S_Point] > 89)&&
                           (s_field->C.s_type[S_Point] < 98)))
                          {
                          x=0;
                          y=0;
                          while (S_EditStr[x]!=0)
                              if (S_EditStr[x++]=='.') {y=1;break;};
                          if  (y==0)
                              strcat(S_EditStr,".0 ");
                          else
                              strcat(S_EditStr,"0 ");
                          Dbl = (double *)(S_WorkArea+S_FieldPtr[S_Point]);
                          *Dbl=atof(S_EditStr);
                          }
                      else
                          {
                          y=strlen(S_EditStr);
                          while ((y>0)&&(S_EditStr[y-1]<33))
                              {
                              S_EditStr[y-1]=0;
                              y--;
                              }
                          strcpy((char *)S_WorkArea+S_FieldPtr[S_Point],
                                 S_EditStr);
                          }
                     if  (S_Tab)
                         {
                         S_Direction = (S_Shift) ? -1:1;
                         S_Point = (S_Direction > 0)
                              ? (s_field->C.s_next[S_Point]-1)
                              : (s_field->C.s_prev[S_Point]-1);
                         S_Fkey  = 0;
                         S_Shift = 0;
                         }
                     }
                  while ((!S_Enter) && (!S_Fkey));

                  if  (S_Enter)
                       S_ValidateScreen();
                  }
                while ((!S_ScreenValid)&&(!S_Fkey));
                if  (S_Enter)
                    S_Point=-1;
                }
       }
   }
