{========================================================================}
{


                       Christopher E. Brown, 1989


}
{========================================================================}

{
Progran CHANGE19

      Purpose : To load in a bitmaped screen from Screen Mode 19 and
                Allow the user to change colors


          Press :

                   + to Increase/ Decrease  Step Value of cursor
                   S to Save Screen
                   L to Read in the screen again
                   Q to Quit Program





}
{========================================================================}





{$A+,B-,D+,E+,F-,I+,L+,N-,O-,R-,S+,V-}
{$M 16384,0,655360}


USES
   DOS,
   CRT,
   SCR19U;



{========================================================================}

VAR
  NAME : STR8;
  X,Y,Z : BYTE;
  CH : CHAR;

  NEWCOLOR,
  COLOR      : BYTE;
  XPOS, YPOS : INTEGER;


  SPECTRUM : SCR19PTR;
  SCREEN   : SCR19PTR;


{========================================================================}



{

Procedures :

           PROCEDURE MOVEAROUNDSCREEN (VAR X,Y : INTEGER);
                              Moves cursor around the screen until a Special Key is detected

                               Special Keys :

                                     '+' : Increase/ Decrease  Step Value of cursor
                                     'S' : Save Screen
                                     'L' : Read in the screen again
                                     'Q' : Quit Program


           FUNCTION MOVEAROUNDSPECTRUM (OLDCOLOR : BYTE)  : BYTE;
                              Moves cursor around the spectrum until Enter is detected


           PROCEDURE CHANGECOLOR  ( VAR SCREEN : SCRTYPE19;
                                      OLD, NEW : BYTE         );

                              Changes a color to another in the cureent screen



}

{========================================================================}




PROCEDURE MOVEAROUNDSCREEN (VAR X,Y : INTEGER);

VAR
   COLOR : BYTE;
   CH    : CHAR;
   STEP  : INTEGER;

BEGIN

    STEP:=10;

    REPEAT

        COLOR:=COLORAT19 (X,Y);


       REPEAT
          PLOT19 (X,Y,15);
          PLOT19 (X,Y,0);
       UNTIL KEYPRESSED;

       CH:=READKEY;
        IF (CH=#0) AND (KEYPRESSED) THEN CH:=READKEY;

       PLOT19 (X,Y,COLOR);

       CASE CH OF

           #75 :  IF X>000+STEP THEN X:=X-STEP ELSE X:=  0; { LEFT  }
           #77 :  IF X<319-STEP THEN X:=X+STEP ELSE X:=319; { RIGHT }
           #72 :  IF Y>000+STEP THEN Y:=Y-STEP ELSE Y:=  0; { UP    }
           #80 :  IF Y<199-STEP THEN Y:=Y+STEP ELSE Y:=199; { DOWN  }

           '+' :  IF STEP=1  THEN STEP:=10 ELSE STEP:=1;

           'S' :  WRITESCR19 (SCR19,NAME);
           'L' :  READSCR19  (SCR19,NAME);
           'Q' :  BEGIN
                       X:=-1;
                       CH:=#13;
                  END;

       END;

    UNTIL CH=#13;

END;

{========================================================================}

FUNCTION MOVEAROUNDSPECTRUM (OLDCOLOR : BYTE)  : BYTE;

VAR
   COLOR : BYTE;
   CH    : CHAR;
   STEP  : INTEGER;

   OLD,
   NEW   : BYTE;

   X,Y   : INTEGER;


BEGIN

    STEP:=10;
    GOTOXY (1, 7); WRITE (OLDCOLOR);
    NEW:=OLDCOLOR;

    Y:=100;
    X:=OLDCOLOR+35;
    DRAW_VLINE19 (X,0,X,20,15);

    REPEAT

       COLOR:=COLORAT19 (X,Y);
       GOTOXY (1,17); WRITE (COLOR);

       REPEAT
          DRAW_VLINE19 (X,90,X,110,15);
          DRAW_VLINE19 (X,90,X,110, 0);
       UNTIL KEYPRESSED;

       CH:=READKEY;
        IF (CH=#0) AND (KEYPRESSED) THEN CH:=READKEY;

       DRAW_VLINE19 (X,90,X,110, COLOR);

       CASE CH OF

           #75 :  IF X>035+STEP THEN X:=X-STEP ELSE X:= 35; { LEFT  }
           #77 :  IF X<290-STEP THEN X:=X+STEP ELSE X:=290; { RIGHT }
           #72 :  IF Y>010+STEP THEN Y:=Y-STEP ELSE Y:= 10; { UP    }
           #80 :  IF Y<190-STEP THEN Y:=Y+STEP ELSE Y:=190; { DOWN  }

           '+' :  IF STEP=1 THEN STEP:=10 ELSE STEP:=1;

       END;

    UNTIL CH=#13;

    MOVEAROUNDSPECTRUM := COLOR;

END;

{========================================================================}

PROCEDURE CHANGECOLOR  ( VAR SCREEN : SCRTYPE19;
                           OLD, NEW : BYTE         );

VAR
  X,Y : INTEGER;

BEGIN

  SCR19:=SCREEN;

   FOR X:=0 TO 319 DO
     FOR Y:=0 TO 199 DO IF COLORAT19 (X,Y)=OLD THEN PLOT19 (X,Y,NEW);

  SCREEN:=SCR19;


END;

{===========================================================================}











{===========================================================================}

{                                 Main Program                              }

{===========================================================================}

BEGIN


    CLRSCR;

    XPOS:=160;
    YPOS:=100;

    NEW (SPECTRUM);
    NEW (SCREEN);
    READSCR19 (SPECTRUM^,'SPECTRUM');


    IF PARAMCOUNT<1 THEN BEGIN
         WRITE ('ENTER NAME OF SCREEN TO EDIT - ');
         READLN (NAME);
    END
    ELSE NAME:=PARAMSTR(1);

    SCREENMODE (19);
    READSCR19 (SCREEN^,NAME);

    REPEAT

        SHOWSCR(SCREEN^);


        MOVEAROUNDSCREEN (XPOS,YPOS);  { Moves around until ENTER is Hit }


        IF XPOS>0 THEN BEGIN

           COLOR:=COLORAT19 (XPOS,YPOS);
           SHOWSCR(SPECTRUM^);
           NEWCOLOR:=MOVEAROUNDSPECTRUM (COLOR);
           SHOWSCR(SCREEN^);
           CHANGECOLOR (SCREEN^,COLOR,NEWCOLOR);

        END

        ELSE CH:='Q';

    UNTIL CH='Q';
    TEXTMODE (80);
    CLRSCR;


END.