{========================================================================}
{


                       Christopher E. Brown, 1989


}
{========================================================================}

UNIT SCR19U;

INTERFACE

{============================================================================}

USES
  DOS,
  CRT;

{============================================================================}




TYPE

   HALFSCREEN = ARRAY [0..31999] OF BYTE;
   SCRTYPE19  = ARRAY [1..2] OF HALFSCREEN;      { Definitions for SCreen Mode #19 }

   SCRTYPE01  = ARRAY [0..15999] OF BYTE;        { Definitions for SCreen Mode #1 }

VAR

    SCR01 : SCRTYPE01 ABSOLUTE $B800:$0000;      { The location of the Normal video Buffer }
    SCR19 : SCRTYPE19 ABSOLUTE $A000:$0000;      { The location of the VGA SCR19 video Buffer }


{============================================================================}


TYPE
  STR8 = STRING [8];

  SCR19PTR = ^SCR19PTRTYPE;
  SCR19PTRTYPE = SCRTYPE19;



{============================================================================}


PROCEDURE SCREENMODE ( MODE : BYTE );
    { Puts the Screen controler into Screen mode #MODE }





FUNCTION COLORAT19 ( X,Y : INTEGER) : INTEGER;

    {  Returns the number (0-255) of the pixel @X,Y in Screen Mode 19 }
    {   - Returns -1 of X,Y is not a valid location                   }

PROCEDURE PLOT19 ( X,Y,C : INTEGER);

   {  Plots a pixel of Color C @X,Y   }




PROCEDURE DRAW_VLINE19 (X1,Y1,X2,Y2,C : INTEGER);
   { Draws a Verticle Line in Screen Mode 19 }

PROCEDURE DRAW_HLINE19 (X1,Y1,X2,Y2,C : INTEGER);
   { Draws a Horizonal Line in Screen Mode 19 }



PROCEDURE READSCR19 (VAR SCR : SCRTYPE19;
                        NAME : STR8);
    { You Guesed it! Reads a bitmap of a Screen Mode 19
          screen from file NAME.scr                     }


PROCEDURE WRITESCR19 (VAR SCREEN : SCRTYPE19;
                            NAME : STR8);
    { Reads a bitmap of a Screen Mode 19 screen from file NAME.scr }



PROCEDURE SHOWSCR (VAR SCREEN : SCRTYPE19);
    { Makes the Screen pointed to by SCREEN the current Screen }














{============================================================================}

                             IMPLEMENTATION

{============================================================================}


PROCEDURE SCREENMODE ( MODE : BYTE );

VAR
   REGS : REGISTERS;

BEGIN  { SCREENMODE }

     REGS.AH:=0;
     REGS.AL:=MODE;
     INTR ($10,REGS);

END;   { SCREENMODE }




{------------------------------------------------------------------------}





FUNCTION COLORAT19 ( X,Y : INTEGER) : INTEGER;

{  Returns the number (0-255) of the pixel @X,Y in Screen Mode 19 }
{   - Returns -1 of X,Y is not a valid location                   }


BEGIN
      IF (X<0) OR (X>319) OR (Y<0) OR (Y>199)
        THEN COLORAT19:=-1
        ELSE
            IF Y<=100 THEN COLORAT19:=SCR19[1][(320*(Y    ))+X]
                      ELSE COLORAT19:=SCR19[2][(320*(Y-100))+X];
END;




{------------------------------------------------------------------------}







PROCEDURE PLOT19 ( X,Y,C : INTEGER);

   {  Plots a pixel of Color C @X,Y   }

BEGIN
      IF (X<0) OR (X>319) OR (Y<0) OR (Y>199)
        THEN BEGIN END
        ELSE
            IF Y<=100 THEN SCR19[1][(320*(Y    ))+X]:=C
                      ELSE SCR19[2][(320*(Y-100))+X]:=C;
END;






{------------------------------------------------------------------------}









PROCEDURE DRAW_VLINE19 (X1,Y1,X2,Y2,C : INTEGER);

VAR

 COUNT : INTEGER;

BEGIN

    FOR COUNT:=Y1 TO Y2 DO PLOT19 (X1,COUNT,C);

END;

{------------------------------------------------------}

PROCEDURE DRAW_HLINE19 (X1,Y1,X2,Y2,C : INTEGER);

VAR

 COUNT : INTEGER;

BEGIN

    FOR COUNT:=X1 TO X2 DO PLOT19 (Y1,COUNT,C);

END;






{------------------------------------------------------------------------}


PROCEDURE READSCR19 (VAR SCR : SCRTYPE19;
                        NAME : STR8);

VAR
  SCRFILE  : FILE OF SCRTYPE19;

BEGIN

    FILLCHAR (SCR,SIZEOF(SCR),0);
    ASSIGN (SCRFILE,NAME+'.SCR');
    {$I-}  RESET (SCRFILE); {$I+}

    IF IORESULT=0 THEN BEGIN
                            READ (SCRFILE,SCR);
                            CLOSE (SCRFILE);
                       END;
END;

{========================================================================}

PROCEDURE WRITESCR19 (VAR SCREEN : SCRTYPE19;
                        NAME : STR8);

VAR
  SCRFILE  : FILE OF SCRTYPE19;

BEGIN

     ASSIGN (SCRFILE,NAME+'.SCR');
     REWRITE (SCRFILE);
     WRITE (SCRFILE,SCREEN);
     CLOSE (SCRFILE);

END; { SAVESCREEN }



{===========================================================================}

PROCEDURE SHOWSCR (VAR SCREEN : SCRTYPE19);

BEGIN

     SCR19:=SCREEN;

END;

{========================================================================}

Begin

End.