/* ************************************************************* */
/* readxgf.c For Turbo C - Demonstrates how to display XGF files */
/*                         that are 64K or less. Use disxgf.c    */
/*			   for files that are greater than 64K   */
/*                                                               */
/* Use Raster Clip/Rastport to convert PCX files to XGF format.  */
/*                                                               */
/* ************************************************************* */

#include <stdio.h>
#include <alloc.h>
#include <graphics.h>

int huge DetectVGA256(void)
{
 return(0);   /* change 0 to other value for SVGA modes */
}

void setvga256(void)
{
 int gm,driver = DETECT;
 installuserdriver("svga256",DetectVGA256);
 initgraph(&driver,&gm,"");
}

void setvga16()
{
 int driver = VGA,
     mode = VGALO;

 initgraph(&driver, &mode, "");
}

void read_xgf(int x, int y, char *filename)
{
  char *imgBuf;
  FILE *F;
  unsigned int size;

  F=fopen(filename,"rb");
  if (F!=NULL)
  {
   size=filelength(fileno(F));
   imgBuf=malloc(size);
   fread(imgBuf,size,1,F);
   fclose(F);
   putimage(x,y,imgBuf,COPY_PUT);
   free(imgBuf);
  }
}

void main()
{
  setvga16();          /* replace with setvga256 for 256 color XGF files */
  setfillstyle(SOLID_FILL,BLUE);
  bar(0,0,getmaxx(),getmaxy());
  read_xgf(0,0,"image2.xgf");
  getch();
  closegraph();
}
