/* ************************************************************* */
/* disres.c For Turbo C - Demonstrates how to display XGF images */
/*                        inside a resource file.                */
/*                                                               */
/* Use the Rastport to create resource files.                    */
/*                                                               */
/* ************************************************************* */

#include <stdio.h>
#include <graphics.h>


int huge DetectVGA256(void)
{
 return(0);   /* change 0 to other value for SVGA modes */
}

void setvga256(void)
{
 int gm,driver = DETECT;
 installuserdriver("svga256",DetectVGA256);
 initgraph(&driver,&gm,"");
}

void setvga16()
{
 int driver = VGA,
     mode = VGALO;

 initgraph(&driver, &mode, "");
}

void res_dis_xgf(int x, int y, char *filename, int ri)
{
 FILE *F;
 unsigned int width,height,bpl,i;
 int scanline[1030];
 int rt;
 char rid[12];
 long offset,size;

 F=fopen(filename,"rb");

 if (F!=NULL)
 {
   fseek(F,((long)5+(long)(ri-1)*(long)22),SEEK_SET);

   fread(&rt,2,1,F);             /* resource type          */
   fread(rid,12,1,F);            /* resource id            */
   fread(&offset,4,1,F);         /* resource offset        */
   fread(&size,4,1,F);           /* resource size          */

   fseek(F,offset,SEEK_SET);
   fread(&width,2,1,F);
   fread(&height,2,1,F);

   scanline[0]=width;
   scanline[1]=0;

   if (getmaxcolor()==255)
   {
     bpl=width+1;
   }
   else
   {
     bpl=imagesize(0,0,width,0)-6;
   }
   for(i=0;i<height;i++)
   {
     fread(&scanline[2],1,bpl,F);
     putimage(x,y+i,scanline,0);
   }
   fclose(F);
 }
}


void main()
{
  setvga16();          /* replace with setvga256 for 256 color XGF files */

  setfillstyle(SOLID_FILL,BLUE);
  bar(0,0,getmaxx(),getmaxy());

  res_dis_xgf(0,0,"pics.res",1);
  res_dis_xgf(200,50,"pics.res",2);
  res_dis_xgf(300,100,"pics.res",3);
  res_dis_xgf(200,0,"pics.res",4);
  res_dis_xgf(400,50,"pics.res",5);
  res_dis_xgf(500,100,"pics.res",6);

  getch();
  closegraph();
}
