
  procedure WriteHelp;
    {-Wr a series of help screens}
  var
    c              : Char;
  begin
    HiVid;
    WrL(Copyright);
    WrL(Version);
    WrL('');
    WrL('');
    WrL('Usage: RPL [-F CommandFile] [options] [input/output redirection]');
    WrL(''); LoVid;
    WrL('  Entering RPL by itself will start an interactive prompting session.');
    WrL('  RPL  uses  standard input and output.  The "-F CommandFile"  option');
    WrL('  reads the first line of a text file and interprets it as a  command');
    WrL('  line.  CommandFile  can  be located anywhere on the PATH,  and  may');
    WrL('  contain nested "-F" commands.  Default extension of CommandFile  is');
    WrL('  ".PAT". The max length of any text line used by RPL is 1024 characters.');
    WrL('  The max length of any command file line is 255 characters.');
    WrL(''); HiVid;
    WrL('Options: ');
    WrL(''); LoVid;
    WrL('  -S  select     Use only lines from InputFile that match "select" pattern.');
    WrL('  -V  select     Use only lines from InputFile that do NOT match "select".');
    WrL('  -M  match      Match criteria applied to selected lines.');
    WrL('  -R  replace    Replacement criteria within matched and selected lines.');
    WrL('  -US            Output "un-selected" lines (no meaning if -S or -V not used).');
    WrL('  -OM            Output only "modified" lines (no meaning if -R not used).');
    WrL('  -OC            Output ONLY a count of selected and matched lines.');
    WrL('  -N             Attach the line number to start of each output line.');
    WrL('  -I             Ignore case (text converted to uppercase within RPL).');
    WrL(''); HiVid;
    WrL('Press any key to view next help page (Q to quit)....');
    c := ReadKey;
    if UpCaseMac(c) = 'Q' then Halt;
    WrL('"Select" and "Match" Regular Expressions (RE for short):');
    WrL(''); LoVid;
    WrL('  Regular  expressions  are combinations of normal  text  characters,');
    WrL('  special   characters   and  the  following   operators.');
    WrL(''); HiVid;
    WrL('  ?      single char                ^      beginning of line ');
    WrL('  $      end of line                *      closure (0 or more times) ');
    WrL('  +      closure (1 or more times)  !      closure (0 or 1 time) ');
    WrL('  [ccl]  character class            [^ccl] negated character class ');
    WrL('  \      escape                     -      range indicator in ccl ');
    WrL('  (RE)   group of RE''s              (RE)(RE) concatenated RE''s ');
    WrL('  RE#RE  alternation                {RE}   define tag match ');
    WrL(''); LoVid;
    WrL('  To  obtain a literal match of any of these characters,  it must  be');
    WrL('  preceded by an escape character (e.g., literal backslash = \\).');
    WrL(''); HiVid;
    WrL('"Replace" Regular Expressions:');
    WrL(''); LoVid;
    WrL('  Replaced  text  includes  the  leading  unmatched  text,  then  the');
    WrL('  replaced version of the matched text, then the trailing unmatched.');
    WrL(''); HiVid;
    WrL('  &     all of match                \n     tagged match n (0<n<10) ');
    WrL('');
    WrL('Press any key to view next help page (Q to quit)....');
    c := ReadKey;
    if UpCaseMac(c) = 'Q' then Halt;
    WrL('');
    WrL('');
    WrL('Special Characters:');
    WrL(''); LoVid;
    WrL('  Expressions  on  the  command line or in a  command  file  may  not');
    WrL('  contain blank space. The following special characters may be');
    WrL('  used in either match or replace expressions, and also within');
    WrL('  character class definitions.');
    WrL(''); HiVid;
    WrL('  \s   space               \t   tab               \b   backspace ');
    WrL('  \r   return              \l   linefeed');
    WrL('  \i   input redir (<)     \o   output redir (>)  \p   pipe (|)');
    WrL('');
    WrL('Extra Special Characters:');
    WrL(''); LoVid;
    WrL('  The following may not be used inside of character class');
    WrL('  definitions.');
    WrL(''); HiVid;
    WrL('  \w word delimiter = [\t\s!"&()*+,-./:;<=>?@[\]^`{|}~]');
    WrL('  \h hex character  = [0-9A-F]');
    WrL('  \z creates a null expression (use by itself)');
    WrL('  \n newline (CR followed by LF)');
    WrL('');
    WrL('Press any key to view next help page (Q to quit)....');
    c := ReadKey;
    if UpCaseMac(c) = 'Q' then Halt;
    WrL('');
    WrL('Examples:');
    WrL('');
    WrL('  RPL -M ^{?+[^\s]}\s* -R \1 <myfile.txt >myfile.cln');
    WrL(''); LoVid;
    WrL('    Strips trailing blanks from myfile.txt (output to myfile.cln).');
    WrL(''); HiVid;
    WrL('  RPL -I -M \w*{[''$#%A-Z0-9]+}\w* -R \1\n <\pathname\file1 >file2');
    WrL(''); LoVid;
    WrL('    Strips word delimiters and puts one word per line.');
    WrL(''); HiVid;
    WrL('  RPL -N -M ^\s*(PROCEDURE)#(FUNCTION) myfile.pas');
    WrL(''); LoVid;
    WrL('    Lists all Pascal Proc/Fn declarations preceded by line number.');
    WrL(''); HiVid;
    WrL('  RPL -F rmblines myfile.txt >myfile.cln');
    WrL(''); LoVid;
    WrL('    Calls the command file RMBLINES.PAT to remove all blank lines.');
    WrL(''); HiVid;
    WrL('  RPL -M ? -OC longfile.pas');
    WrL(''); LoVid;
    WrL('    Counts the number of non-empty lines in longfile.pas.');
    WrL('');
    Halt;
  end;                            {writehelp}
