{$R-,S-}

{Conditional defines that may affect this program}
{$I APDEFINE.INC}

program RTerm;
  {-A "doorway" mode remote terminal for RMTCTL}
uses
  Crt,
  ApTimer,
  ApMisc,
  ApPort,
  ApUart,
  ApCom,
  ApAnsiF;

const
  ComX = Com3;
  Baud = 19200;
  ExitKey = #$83;    {<Alt>=}

var
  P : PortRecPtr;
  C : Char;
  Finished : Boolean;

const
  ParityChar : array[ParityType] of Char = ('N', 'O', 'E', 'M', 'S');
  OnOff : array[Boolean] of String[3] = ('Off', 'On ');

procedure Abort(Msg : String; Code : Integer);
  {-Close port and halt}
begin
  WriteLn(Msg, Code);
  Halt(1);
end;

begin
  WriteLn('RTERM "doorway" mode remote program for RMTCTL');
  WriteLn('Press <Alt>= to exit');
  Delay(2000);
  ClrScr;

  {Open a port}
  InitPort(P, ComX, Baud, NoParity, 8, 1, 16384, 16384, DefPortOptions);
  if AsyncStatus <> ecOk then
    Abort('Failed to open port: ', AsyncStatus);

  HWFlowEnable(P, hfRequireCTS or hfUseRTS, 14000, 200);

  {$IFDEF Tracing}
  InitTracing(5000);
  {$ENDIF}

  {Simple terminal}
  Finished := False;
  repeat
    {Process chars to send}
    if KeyPressed then begin
      C := ReadKey;
      if C = #0 then begin
        C := ReadKey;
        if C = ExitKey then
          Finished := True
        else begin
          PutChar(P, #0);
          PutChar(P, C);
        end
      end else begin
        while not TransReady(P) do ;
        PutChar(P, C);
      end;
    end;

    {Process chars received}
    if CharReady(P) then begin
      GetChar(P, C);
      WriteCharAnsi(C);
    end;
  until Finished;

  DonePort(P);
  ClrScr;

  {$IFDEF Tracing}
  DumpTrace('rterm.trc');
  {$ENDIF}
end.
