{ TestDoor - Copyright (c) 1991 by Randy Hunt and Mark Goodwin }
{            A sample door showing some routines from RMDoor   }

{$M $4000,0,0}                     (* Necessary for Drop to DOS *)
uses rmdoor;                       (* Use the RMDOOR.TPU file! *)

var
  wannaquit:boolean;      (* Checks if users wants to quit the door *)

(***************************************)
(*   This door will allow the user to  *)
(*   try to guess the number that the  *)
(*   computer is "thinking" of.        *)
(***************************************)

procedure displaywelcome;
begin
  rmsetcolor(15,0);     (* Set color to white on blue *)
  rmclrscr;             (* Clear screen *)
  rmwriteln('TestDoor 1.0');
  rmsetcolor(14,0);     (* Set color to yellow on black *)
  rmwriteln('Copyright (c) 1991 by Randy Hunt and Mark Goodwin');
  rmwriteln('');        (* Enter a blank line *)
end;


procedure playgame;
var
  computernum:integer;               (* Number the computer chooses *)
  usernum:integer;                    (* Number the user chooses *)
  win:boolean;
  numguesses:integer;
  input:char;
begin
  rmsetcolor(3,0);    (* Set color to cyan on black *)
  computernum:=random(1000);  (* Get a random number 1-1000 *)
  win:=false;
  numguesses:=0;
  rmsetcolor(13,0);
  rmwriteln('The computer is thinking of a number from 1-1000!');
  repeat
    inc(numguesses);
    rmsetcolor(10,0);
    rmwrite('Enter a number from 1-1000 (0 to quit): ');
    rmsetcolor(12,0);
    usernum:=rmreadi;
    if ((usernum<1) or (usernum>1000)) and (usernum<>0) then
      begin
        rmsetcolor(14,0);
        rmwriteln('Number must be between 1 and 1000!!');
      end
    else
     if usernum<>0 then
      begin
        if computernum=usernum then
          win:=true
        else
          begin
            rmsetcolor(14,0);
            if usernum>computernum then
              rmwriteln('   Too high!');
            if usernum<computernum then
              rmwriteln('   Too low!');
          end;
      end;
  until win or (usernum=0);
  if win then
    begin
      rmsetcolor(14,0);
      rmwrite('You got it in ');
      rmwritei(numguesses);
      rmwriteln(' guesses');
    end;
  rmsetcolor(14,0);
  rmwrite('Play again (y/n)? ');
  repeat
    input:=rmreadkey;
  until (input='Y') or (input='y') or (input='N') or (input='n');
  if (input='N') or (input='n') then
   begin
    wannaquit:=true;
    rmsetcolor(3,0);
    rmwriteln('No');
   end
  else
    begin
      rmsetcolor(3,0);
      rmwriteln('Yes');
      rmwriteln('');
      rmwriteln('');
    end;
end;


begin
  doorname:='TestDoor 1.0';   (* Tell RMDoor what your program name is *)
  randomize;            (* Initialize random generator (Turbo Pascal) *)
  displaywelcome;
  wannaquit:=false;
  repeat
    playgame;
  until wannaquit;
end.
