{$A+,B-,D+,E-,F-,I-,L+,N-,O-,R-,S-,V-}
{$M 16384,0,655360}
UNIT Readers;

(*******************************************************)
  interface
(*******************************************************)

USES
  DOS, Crt, moveops, RLine;

TYPE
  ViewPtr = ^Reader;
  Reader = Object(Scroller)
    FO : FileOfLines;
    CONSTRUCTOR Init(FN : String; FileBufSize : Word;
		     px1,py1,px2,py2 : integer);
    DESTRUCTOR Done;
    PROCEDURE Help; virtual;

    FUNCTION DTAline(Row : LongInt) : String; virtual;
    PROCEDURE GotoLine(X : LongInt); virtual;

    PROCEDURE CheckRFerror;
    PROCEDURE ShowStatus; virtual;
    PROCEDURE Message(s : str80); virtual;
    FUNCTION AskString(prompt : string) : string; virtual;
  END;

(*******************************************************)
  implementation
(*******************************************************)

  CONSTRUCTOR Reader.Init(FN : string; FileBufSize : word;
		     px1,py1,px2,py2 : integer);
  BEGIN
    IF FO.Init(FN, FileBufSize)
    THEN BEGIN
      checkrferror;
      Scroller.Init(px1,py1,px2,py2,FO.TotalLines)
    END ELSE Fail;
  END;

  PROCEDURE Reader.CheckRFerror;
  BEGIN
    With FO Do BEGIN
      if (RFerror <> 0) and (RFerror <> $FFFF) THEN BEGIN
	Writeln(RFerrorString);
	Halt(1);
      END;
    END;
  END;


  DESTRUCTOR Reader.Done;
  BEGIN
    FO.Done;
    Scroller.Done;
  END;

  FUNCTION Reader.DTAline(Row : LongInt) : String;
  CONST
    Blanks : string[8] = '        ';
  VAR
    i : Integer;
  BEGIN
    With FO DO BEGIN
      SeekLine(Row);
      IF RFerror = 0 THEN BEGIN
        i := pos(^I,LastLine);		{ Expand existing tabs }
        while i > 0 do BEGIN
	  LastLine[i] := ' ';
	  Blanks[0] := chr(i mod 8);
	  if blanks[0] > #0
          then blanks[0] := chr(8 - ord(blanks[0]));
	  insert(blanks, LastLine, i);
	  i := pos(^I,LastLine);
        END;
        DTAline := LastLine;
      END ELSE BEGIN
        DTAline := '';
        RFerror := 0;
      END;
    END;
  END;

  PROCEDURE Reader.GotoLine(X : LongInt);
  BEGIN
    IF x <= TotalItems
    THEN Scroller.GotoLine(x)
    ELSE Message('Attempted to GotoLine past End Of File.');
  END;

  TYPE
    Helper = object(Scroller)
      FUNCTION DTAline(Row : Longint) : String; virtual;
    END;

  CONST
    NHelpers = 17;

{$F+}
   FUNCTION Helper.DTAline(Row : Longint) : String;
   CONST
     Hstrings : array[1..NHelpers] of String[32] =
     (' F          Find text',
      ' C          Case-sensitive find',
      ' N          Find next',
      ' A          Auto-Scroll',
      ' 0..9       Adjust scroll speed',
      'PgUp/PgDn   Page up and down',
      'Home        Top of file',
      'End         Bottom of file',
      'Up arrow    Move up',
      'Down arrow  Move down',
      'Right arrow Scroll right',
      'Left arrow  Scroll Left',
      'Ctrl-Right  Scroll 8 chars right',
      'Ctrl-Left   Go to first column',
      'ESCape      Exit to DOS',
      '',
      '  Press ESCape now to return');
   BEGIN
     if Row <= NHelpers
     THEN DTAline := Hstrings[Row]
     ELSE DTAline := '';
   END;
{$F-}

  PROCEDURE Reader.Help;
  var
    H : Helper;
  BEGIN
    H.Init(x1,y1,x2,y2,NHelpers);
    H.WrScr;
    while H.scrollselect <> #27 do ;
    H.Done;
    wrscr;
  END;

  FUNCTION Reader.AskString(prompt : string) : string;
  var
    s : string[40];
  BEGIN
    AskString := '';
    gotoxy(1,2);
    clreol;
    write(prompt, ' ');
    readln(s);
    AskString := s;
  END;

  PROCEDURE Reader.ShowStatus;
  var i : integer;
  BEGIN
    gotoxy(1,1);
    write(fo.filename, '   Line ',IxNoY1, ' of ', TotalItems, '.  Col: ',FirstColumn);
    clreol;
    gotoxy(1,2);
    write('> F1 for commands');
    clreol;
  END;

  PROCEDURE Reader.Message(s : str80);
  BEGIN
    gotoxy(1,2);
    write('> ', s);
    clreol;
  END;

END.
