{$R+,S+,I+,F-,V+,B- }
{$M 16384,0,0 }

PROGRAM RLEgenerator(RLEinput,INPUT,OUTPUT);
   {Created by Rob Rosenberger
               CIS ID 74017,1344

Version 1.00: released to the public domain on 30 Nov 88.
   This program will generate a run-length-encoded array that can be unpacked
   to a given destination device via the supplied unpacking routine.}

USES
   CRT;

CONST
   TempFilename    = 'RLE.TMP'; {it's just a temporary working file}
   MaxSourceLength = 78; {max line length of the output source code}

   Granularity = 5; {how big our original array is compared to our "ideal"
                       array.  The original array could theoretically have
                       up to (Granularity - 1) too many characters reserved
                       in the array.  This excess portion comes up due to a
                       TP4/TP5 limitation in typed constant declarations.}

VAR
   RLEinput  : FILE OF CHAR;
   CONoutput : TEXT;

   RLElength   : WORD;
   LineChCount : BYTE;
   LineCounter : WORD;
   ActiveQuote : BOOLEAN;

{============================================================================}
PROCEDURE CreateTheRLEarray;

   {This procedure creates the run-length encoded array for the given
input text file.}

VAR
   Ch1 : CHAR;
   Ch2 : CHAR;
   RepeatIndex  : BYTE;
   CRLFdetected : BOOLEAN; {tells us if we have to read a char into Ch1}
   CRLFIndex    : BYTE;
   InputCount   : WORD;

{============================================================================}
PROCEDURE ShipOutputRLE(Ch : CHAR; Index : BYTE);

   {This procedure writes the output to the RLE array text file.  Due to
limitations within TP4, we must write a multiple-index array and then use the
ABSOLUTE clause to redefine it as a single-index array.}

VAR
   FORindex : BYTE;

{============================================================================}
PROCEDURE CheckForNewLine;

   {This procedure determines if a new array must be started.}

BEGIN {CheckForNewLine}
INC(LineChCount);
IF (LineChCount = Granularity)
 THEN {time to start a new line of source code text}
    BEGIN
    IF ActiveQuote
     THEN {close out the active quote}
        BEGIN
        WRITE(OUTPUT,'''');
        ActiveQuote := FALSE
        END;
    WRITELN(OUTPUT);
    INC(LineCounter);
    LineChCount := 0
    END
END; {CheckForNewLine}
{============================================================================}

BEGIN {ShipOutputRLE}

IF ((Index >= 4) OR (Ch IN [^A..^Z,#255]))
 THEN {do we need to close out an active quote?}
    BEGIN
    IF ActiveQuote
     THEN {yes, close out the active quote}
        BEGIN
        WRITE(OUTPUT,'''');
        ActiveQuote := FALSE
        END
    END
 ELSE {do we need to open an active quote?}
    BEGIN
    IF NOT ActiveQuote
     THEN {yes, open an active quote}
        BEGIN
        WRITE(OUTPUT,'''');
        ActiveQuote := TRUE
        END
    END;

{We finally get to write to the RLEarray!}
IF (Index < 4)
 THEN
    CASE Ch OF
      ^A..^Z :
        FOR FORindex := 1 TO Index
         DO BEGIN
            WRITE(OUTPUT,'^',CHR(ORD(Ch) + 64));
            CheckForNewLine
            END;
      #255 :
        FOR FORindex := 1 TO Index
         DO BEGIN
            WRITE(OUTPUT,'#255');
            CheckForNewLine
            END
      ELSE
        FOR FORindex := 1 TO Index
         DO BEGIN
            WRITE(OUTPUT,Ch);
            IF (Ch = '''')
             THEN {Pascal demands one more!}
                WRITE(OUTPUT,Ch);
            CheckForNewLine;
            IF ((FORindex < Index) AND NOT ActiveQuote)
             THEN {whoops, need to re-open an active quote}
                BEGIN
                WRITE(OUTPUT,'''');
                ActiveQuote := TRUE
                END
            END
     END {CASE}
 ELSE
    BEGIN
    WRITE(OUTPUT,'#0');
    CheckForNewLine;
    WRITE(OUTPUT,'#',Index);
    CheckForNewLine;
    CASE Ch OF
      ^A..^Z :
        BEGIN
        WRITE('^',CHR(ORD(Ch) + 64));
        CheckForNewLine
        END;
      #255 :
        BEGIN
        WRITE(OUTPUT,'#255');
        CheckForNewLine
        END
      ELSE
        BEGIN
        WRITE(OUTPUT,'''',Ch);
        ActiveQuote := TRUE; {we just opened one}
        IF (Ch = '''')
         THEN {Pascal demands one more!}
            WRITE(OUTPUT,Ch);
        CheckForNewLine
        END
     END {CASE}
    END
END; {ShipOutputRLE}
{============================================================================}

{============================================================================}
PROCEDURE PutStatsOnScreen;

   {This procedure displays input/output stats for the user to see.}

BEGIN {PutStatsOnScreen}
IF (InputCount > 0) {division by zero not allowed!}
 THEN
    WRITE(CONoutput,^M,InputCount:5,RLElength:8,
       (100 - ((RLElength / InputCount) * 100)):9:1,'%')
END; {PutStatsOnScreen}
{============================================================================}

BEGIN {CreateTheRLEarray}
{Initialize.}
InputCount   := 0;
RepeatIndex  := 1;    {there is always at least 1 repetition of a char}
CRLFdetected := TRUE; {must read a char into Ch1 the first time around!}
CRLFIndex    := 0;


WHILE NOT EOF(RLEinput)
 DO BEGIN
    IF CRLFdetected
     THEN {need to read in two chars, not one}
        BEGIN
        CRLFdetected := FALSE;
        READ(RLEinput,Ch1);
        IF EOF(RLEinput)
         THEN {no more chars!}
            BEGIN
            INC(InputCount);
            Ch2 := CHR(255) {guaranteed to be unique compared to Ch1}
            END
         ELSE {read a char into Ch2}
            BEGIN
            READ(RLEinput,Ch2);
            INC(InputCount,2)
            END
        END
     ELSE {just read a char into Ch2}
        BEGIN
        READ(RLEinput,Ch2);
        INC(InputCount)
        END;

    IF ((Ch1 = ^M) AND (Ch2 = ^J))
     THEN {this is a CR/LF}
        BEGIN
        CRLFdetected := TRUE;
        INC(CRLFIndex)
        END
     ELSE
        BEGIN
        IF (CRLFIndex > 0)
         THEN {it means there were some CRLFs queued up}
            BEGIN
            ShipOutputRLE(#255,CRLFIndex);
            IF (CRLFindex < 4)
             THEN INC(RLElength,CRLFIndex)
             ELSE INC(RLElength,3);
            PutStatsOnScreen;
            CRLFindex := 0
            END;
        IF (Ch2 = Ch1)
         THEN {repetative character}
            INC(RepeatIndex)
         ELSE {ship out the current char}
            BEGIN
            ShipOutputRLE(Ch1,RepeatIndex);
            IF (RepeatIndex < 4)
             THEN INC(RLElength,RepeatIndex)
             ELSE INC(RLElength,3);
            RepeatIndex := 1;
            Ch1         := Ch2
            END
        END
    END; {WHILE NOT EOF(RLEinput)}

{Need to wrap up the RLEarray source code text.}
IF ActiveQuote
 THEN {close the active quote}
    BEGIN
    WRITE(OUTPUT,'''');
    ActiveQuote := FALSE
    END;
IF (CRLFIndex > 0)
 THEN {it means there were some CRLFs queued up}
    BEGIN
    ShipOutputRLE(#255,CRLFIndex);
    IF (CRLFindex < 4)
     THEN INC(RLElength,CRLFIndex)
     ELSE INC(RLElength,3);
    CRLFindex := 0
    END;
PutStatsOnScreen;
IF (LineChCount = 0)
 THEN {oops, we declared one line too many}
    DEC(LineCounter)
 ELSE {need to "round out" the last array string}
    FOR RepeatIndex
          := 1 TO (Granularity - LineChCount)
      DO WRITE(OUTPUT,'#0');

WRITELN(CONoutput)
END; {CreateTheRLEarray}
{============================================================================}

{============================================================================}
PROCEDURE WriteTheRLEarray;

   {This procedure creates the Pascal source code for the given
input file's text.  It assumes INPUT and OUTPUT have been opened.}

VAR
   TempText : STRING;

   SourceLength : BYTE;

BEGIN {WriteTheRLEarray}
WRITELN(OUTPUT);
WRITELN(OUTPUT,'   RLELength   = ',RLELength,';');
WRITELN(OUTPUT);
WRITE(OUTPUT,'   RLEarray : ARRAY [1..',LineCounter,',1..',Granularity,']');
WRITELN(OUTPUT,' OF CHAR =');
WRITELN(OUTPUT,'(');

SourceLength := 0;
WHILE NOT EOF(INPUT)
 DO BEGIN {insert the RLEarray at this point}
    READLN(INPUT,TempText);
    IF ((SourceLength + LENGTH(TempText)) >= MaxSourceLength)
     THEN
        BEGIN
        WRITELN(OUTPUT);
        SourceLength := 0
        END;
    WRITE(OUTPUT,TempText);
    IF NOT EOF(INPUT)
     THEN {need a comma to separate the arrays}
        WRITE(OUTPUT,',');
    INC(SourceLength,(LENGTH(TempText) + 1))
    END; {WHILE}

WRITELN(OUTPUT,');');
WRITELN(OUTPUT)
END; {WriteTheRLEarray}
{============================================================================}

BEGIN
{Initialize all global items.}
RLElength   := 0;
LineChCount := 0;
LineCounter := 1;
ActiveQuote := FALSE;
ASSIGNCRT(CONoutput); {so we can watch how things are going!}
REWRITE(CONoutput);
WRITELN(CONoutput);
WRITELN(CONoutput,'Text-to-RLE source code generator v1.00 for TP4/TP5');
WRITELN(CONoutput,'   written by a guy named Rob Rosenberger (who?)');
WRITELN(CONoutput,'             "An exercise in utility"');
WRITELN(CONoutput);
WRITELN(CONoutput,'INPUT   ARRAY    PERCENT');
WRITELN(CONoutput,'CHARS   CHARS   REDUCTION');

ASSIGN(RLEinput,PARAMSTR(1));
RESET(RLEinput);
ASSIGN(OUTPUT,TempFilename);
REWRITE(OUTPUT);

CreateTheRLEarray;

CLOSE(INPUT);
CLOSE(OUTPUT);

ASSIGN(INPUT,TempFilename);
RESET(INPUT);
ASSIGN(OUTPUT,PARAMSTR(2));
REWRITE(OUTPUT);

WriteTheRLEarray;

CLOSE(INPUT);
CLOSE(OUTPUT);

{And we're done!}
ERASE(INPUT); {get rid of the temporary file we created}
CLOSE(CONoutput)
END. {RLEgenerator}
