Program GenKey;

{
 This is a sample programme using RkPlus.  It is a sample of a registration
 key generation programme that would be used by the programmer to create
 registration keys to be distributed to registered users.  The user would
 then enter the registration key into a registration programme (such as
 Register or Brand) to create the key file. The key generation programme
 itself would NOT be distributed, as it would allow users to generate keys.
 This sample can create a 1 or 2 month limited use demo key, a 1 year
 registration key or an unlimited registration key, for the Sample1, Sample2,
 Sample3 and Sample4 programmes.

 GenKey uses the example encoding unit Encode.
}


Uses
  Crt,
  Dos,
  RkPlus,
  Encode;


Const
  MonthNames : Array[1..12] of String[3]
  = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');


Var
  kc          : Char;
  ey,em,dd,dw : Word;


Begin
  SetProgID('Sample');
  SetKeyFile('Sample');
  WriteLn('GenKey');
  WriteLn('Registration Key Generation Programme for Sample1/Sample2/Sample3/Sample4');
  WriteLn('See RKPLUS.DOC for more info');
  WriteLn;
  WriteLn('GenKey would be used by the programmer to create registration keys.');
  WriteLn('It would NOT be distributed.');
  WriteLn;
  Write('Enter name of person to register : ');
  ReadLn(Rkp.Name1);
  WriteLn;
  WriteLn('[1] 1 month limited use demo key');
  WriteLn('[2] 2 month limited use demo key');
  WriteLn('[R] registration key (1 year)');
  WriteLn('[U] unlimited registration key');
  WriteLn;
  Write('Type? ');
  kc := UpCase(ReadKey);
  WriteLn(kc);
  WriteLn;
  GetDate(ey,em,dd,dw);
  If (kc = '1') then Begin
    If (em = 12) then Begin
      em := 1;
      Inc(ey);
    End Else
      Inc(em);
    WriteLn('Creating limited use demo key (will expire 1-',MonthNames[em],'-',ey,')');
    Rkp.Level := 0;
    Rkp.ExpYear := ey;
    Rkp.ExpMonth := em;
  End Else If (kc = '2') then Begin
    If (em = 11) then Begin
      em := 1;
      Inc(ey);
    End Else If (em = 12) then Begin
      em := 2;
      Inc(ey);
    End Else Begin
      Inc(em,2);
    End;
    WriteLn('Creating limited use demo key (will expire 1-',MonthNames[em],'-',ey,')');
    Rkp.Level := 0;
    Rkp.ExpYear := ey;
    Rkp.ExpMonth := em;
  End Else If (kc in ['R','r']) then Begin
    If (em = 12) then Begin
      em := 1;
      Inc(ey);
    End Else
      Inc(em);
    Inc(ey);
    WriteLn('Creating registration key (will expire 1-',MonthNames[em],'-',ey,')');
    Rkp.Level := 1;
    Rkp.ExpYear := ey;
    Rkp.ExpMonth := em;
  End Else Begin
    WriteLn('Creating unlimited registration key');
    Rkp.Level := 1;
    Rkp.ExpYear := 0;
    Rkp.ExpMonth := 0;
  End;
  Rkp.Name2 := '';
  Rkp.Name3 := '';
  CreateKey;
  WriteLn;
  WriteLn('Key is ',Rkp.Key);
End.
