{ DemoAppD - Turbo Pascal/DOS version of the RegKey demonstration program.    }
{            Demonstrates the use of file-based registration key validation   }
{            within a program using the RegKey system. Displays one of two    }
{            simple messages based upon whether or not the user is            }
{            registered. To test in registerd mode, use KeyGen to generate    }
{            a *.KEY registration key file for DemoApp, and place that file   }
{            in the current default directory. To test in unregistered mode   }
{            remove any valid *.KEY files from the current default directory. }

program DemoAppD;

uses RegKeyD;             { This must be included in any program using RegKey }

var
   RegisteredMode      : RKValid;      { Variable to store mode to operate in }
   RegistrationString  : string[255];      { To store name of registered user }


begin

   { Check for a valid registration key file }

   RegKeyFileValidate('*.KEY',            { Filespec of registration key file }
                      '0C9HMN1NDL',           { Application's validation code }
                      'Your Name', 0,         { Your RegKey registration info }
                      RegistrationString,  { Where reg. string will be placed }
                      255,                      { Maximum size of reg. string }
                      RegisteredMode);  { Where to store result of validation }


   if RegisteredMode = RKRegistered then
   begin

      { If we are operating in registered mode, display registered message }

      WriteLn('DemoApp is registered to: ', RegistrationString);
      WriteLn('Thanks for registering DemoApp!');

   end
   else
   begin

      { If we are operating in UNregistered mode, display UNregistered message }

      WriteLn('DemoApp is NOT registered');
      WriteLn('Please remember to register DemoApp!');
   end

end.
