Program RkSample;

{
 This is a sample Program using rKey.
 This is a very simple Program that doesn't actually do anything, but it
 should demonstrate some of what can be done with rKey.
}


Uses
  Crt, rKey;


Const
  RkSampleVer = '2.4';


Var
  kc : Char;


Procedure BadRegBeep;

Begin
  Sound(1200);
  Delay(200);
  Sound(600);
  Delay(200);
  Sound(1200);
  Delay(200);
  Sound(600);
  Delay(200);
  NoSound;
End;


Procedure NotRegBeep;

Begin
  Sound(600);
  Delay(200);
  Sound(1200);
  Delay(200);
  NoSound;
End;


Procedure DoView;

Begin
  WriteLn('Sample data :');
  WriteLn;
  WriteLn('4.465536  7.918270  0.118373  5.367233');
  WriteLn('1.396349  4.868343  7.079323  4.783021');
  WriteLn('3.947924  8.864673  8.846264  2.999999');
  WriteLn('8.490832  6.874378  5.338329  3.729270');
  WriteLn('6.839882  8.873478  6.750373  7.018948');
  WriteLn('5.034784  3.003763  3.253290  4.892387');
  WriteLn('3.874378  8.314159  9.880869  3.987842');
  WriteLn('2.764947  9.265358  4.013002  9.903278');
End;


Procedure DoCalc;

Begin
  If RegStatus then Begin
    Write('The calculated result is ');
    WriteLn(4.465536+7.918270+0.118373+5.367233+1.396349+4.868343+7.079323+4.783021
    +3.947924+8.864673+8.846264+2.999999+8.490832+6.874378+5.338329+3.729270
    +6.839882+8.873478+6.750373+7.018948+5.034784+3.003763+3.253290+4.892387
    +3.874378+8.314159+9.880869+3.987842+2.764947+9.265358+4.013002+9.903278);
  End Else
    WriteLn('Not available in evaluation version!');
End;


Procedure DoTest;

Begin
  If RegStatus then Begin
    Write('Performing tests...');
    Delay(300);
    WriteLn;
    WriteLn('All tests passed.');
  End Else
    WriteLn('Not available in evaluation version!');
End;


Begin
  OwnerCode := 'ArgleBarbWotsLeeb';
  ProgramCode := 'RkSample Two';
  KeyFileName := 'RKSAMPLE';
  GetRegInfo;
  Write('RkSample v' + RkSampleVer);
  If RegError then
    WriteLn(' [invalid]')
  Else If RegStatus then
    WriteLn(' [registered]')
  Else
    WriteLn(' [evaluation]');
  WriteLn('(c) 1990 TrEndSoft, Inc.');
  WriteLn;
  If RegError then Begin
    WriteLn(KeyFilePath+' has been altered!');
    WriteLn('Please contact TrEndSoft, Inc. to obtain a valid key file.');
    BadRegBeep;
    Halt(1);
  End Else If RegStatus then Begin
    WriteLn('This version of RkSample is registered to '+RegName);
    WriteLn('Thank you for registering!');
  End Else Begin
    WriteLn('This version of RkSample is a limited evaluation copy.');
    WriteLn('Contact TrEndSoft, Inc. for information on obtaining a registered version.');
    NotRegBeep;
    Delay(500);
  End;
  WriteLn;
  Write('RkSample v' + RkSampleVer);
  If Not RegStatus then
    Write(' Evaluation');
  WriteLn(' Menu');
  WriteLn;
  WriteLn('[V]iew sample data');
  Write('[C]alculate');
  If Not RegStatus then
    WriteLn('  (not available in evaluation version)')
  Else
    WriteLn;
  Write('[T]est results');
  If Not RegStatus then
    WriteLn('  (not available in evaluation version)')
  Else
    WriteLn;
  WriteLn;
  Write('Selection : ');
  kc := UpCase(ReadKey);
  WriteLn;
  WriteLn;
  Case kc of
  'V' :
    DoView;
  'C' :
    DoCalc;
  'T' :
    DoTest;
  Else
    WriteLn('Invalid selection!');
  End;
End.
