{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Demo program                                 }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

{ This is an adaptation of the demo program BSCRLAPP.PAS included
  with Turbo Pascal for Windows.  The changes to this program allow
  a 256 color bitmap to be displayed with the appropriate colors.
  This is a "trial and error" attempt.  There may well be API calls
  that should be made that aren't being made as well as techniques that
  accomplish the same thing in an easier manner. }

{ Modifications by Pat Ritchey, CIS:[70007,4660]  }  (*  Changes made are marked with {!!}   *)

{ Modifications by Robert Norton CIS:[70017,1765] to use a resource file. }
{ Many thanks to Kurt Barthelmess (TeamB) for his invaluable guidance. }


program BMP256;

{$R RES256.RES}

uses WinTypes, WinProcs, WinDos, Objects, OStdDlgs, Strings, OMemory, OWindows, Win31;

const
  bsa_Name =  'BitmapScroll';
  DbgInfo = false;              { set this to true if you want to see how it is going. }

type
   PLogPal256 = ^TLogPal256;
   TLogPal256 = record          { Moral equivalent to TLogPalette.}
      palVersion: Word;
      palNumEntries: Word;
      palPalEntry: array[0..255] of TPaletteEntry;
      end;

   { TBitScrollApp, a TApplication descendant }
   TBitScrollApp = object(TApplication)
      procedure InitMainWindow; virtual;
      end;

   { TBitScrollWindow, a TWindow descendant }
   PScrollWindow = ^TBitScrollWindow;
   TBitScrollWindow = object(TWindow)
      BitmapHandle: HBitmap;           { This is the handle to the bitmap from the RES file }
      IconizedBits: HBitmap;
      hPal : hPalette;                 {!!}      { special palette for this bitmap }
      PixelHeight, PixelWidth: Word;
      constructor Init(ATitle: PChar);
      destructor Done; virtual;
      function GetClassName : PChar; virtual;
      procedure GetWindowClass(var WndClass: TWndClass); virtual;
      procedure Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
      procedure WMSize(var Msg: TMessage); virtual wm_First + wm_Size;
      procedure AdjustScroller;
      function FindLoadLockDIB: boolean;         { get bitmap from RES file to BitmapHandle. }
      function CopyDIBPalette(pBMI: PBitMapInfo): integer; {!!}
      end;

{ Warnings if something is going amiss.}
procedure Alert(Mess: string);
begin
   Mess := Mess + #0;
   messagebox(0, @Mess[1], 'Alert!', mb_ok);
   end;

{ Info that is interesting while debugging. }
procedure DBG(Mess: string; Val: integer);
var
   Anum: string[20];
begin
   if DbgInfo
   then begin
      str(Val, Anum);                  { Make number into string. }
      Mess := Mess + Anum + #0;        { make string pChar compatible. }
      messagebox(0, @Mess[1], 'Debug', mb_ok);
      end;
   end;

{ Construct the TBitScrollApp's MainWindow of type TBitScrollWindow }
procedure TBitScrollApp.InitMainWindow;
begin
   MainWindow := New(PScrollWindow, Init(bsa_name));
   end;

{ Constructor for a TBitScrollWindow, sets scroll styles and constructs
  the Scroller object.  }
constructor TBitScrollWindow.Init(ATitle: PChar);
var
   DCHandle: HDC;
begin
   TWindow.Init(nil, ATitle);
   Attr.Style := Attr.Style or ws_VScroll or ws_HScroll;
   Attr.Menu := LoadMenu(HInstance, bsa_Name);
   BitmapHandle := 0;                  { no picture as yet. }
   hPal := 0;                {!!}      { no palette as yet. }
   Scroller := New(PScroller, Init(@Self, 1, 1, 200, 200));
   DCHandle := CreateDC('Display', nil, nil, nil);
   IconizedBits := CreateCompatibleBitmap(DCHandle, 64, 64);
   DeleteDC(DCHandle);
   FindLoadLockDIB;
   end;

{ Change the class name to the application name. }
function TBitScrollWindow.GetClassName : PChar;
begin
   GetClassName := bsa_Name;
   end;

{ Allow the iconic picture to be drawn from the client area. }
procedure TBitScrollWindow.GetWindowClass(var WndClass: TWndClass);
begin
   TWindow.GetWindowClass(WndClass);
   WndClass.hIcon := 0; { Client area will be painted by the app. }
   end;

{ Adjust the Scroller range so that the the origin is the
  upper-most scrollable point and the corner is the
  bottom-most. }
procedure TBitScrollWindow.AdjustScroller;
var
   ClientRect: TRect;
begin
   GetClientRect(HWindow, ClientRect);
   with ClientRect do Scroller^.SetRange(
      PixelWidth - (right - left),
      PixelHeight - (bottom - top));
   Scroller^.ScrollTo(0, 0);
   InvalidateRect(HWindow, nil, True);
   end;

{ Reset scroller range. }
procedure TBitScrollWindow.WMSize(var Msg: TMessage);
var
   ClientRect: TRect;
   DC, MemDC1, MemDC2: HDC;
   OldBitmap1, OldBitmap2: HBitmap;
   OldCursor: HCursor;
begin
   TWindow.WMSize(Msg);
   Scroller^.AutoOrg := not (Msg.wParam = sizeIconic);
   if not (Msg.WParam = sizeIconic)
   then AdjustScroller
   else begin                { Paint the icon in system palette. }
       DC := GetDC(HWindow);
       MemDC1 := CreateCompatibleDC(DC);
       MemDC2 := CreateCompatibleDC(DC);
       ReleaseDC(HWindow, DC);
       OldBitmap1 := SelectObject(MemDC1, IconizedBits);
       OldBitmap2 := SelectObject(MemDC2, BitmapHandle);
       OldCursor := SetCursor(LoadCursor(0, idc_Wait));
       StretchBlt(MemDC1, 0, 0, Msg.lParamLo, Msg.lParamHi, MemDC2,
         0, 0, PixelWidth, PixelHeight, SrcCopy);
       SetCursor(OldCursor);
       SelectObject(MemDC1, OldBitmap1);
       SelectObject(MemDC2, OldBitmap2);
       DeleteDC(MemDC1);
       DeleteDC(MemDC2);
       end;
   end;


{ Make a palette based on bitmap requirements, and save the handle. }
function TBitScrollWindow.CopyDIBPalette(pBMI : PBitMapInfo): integer;  {!!}
var
   MyLogPal: TLogPal256;     { local allocation TLogPalette equivalent.}
   i : integer;
   PalSize : integer;
begin
   if pBMI^.bmiHeader.biClrUsed = 0
   then PalSize := 1 shl pBMI^.bmiHeader.biBitCount
   else PalSize := pBMI^.bmiHeader.biClrUsed;
   Dbg('Colors used = ', PalSize);
   MyLogPal.palNumEntries := PalSize;
   MyLogPal.palVersion := $0300;
{$R-}  { bmicolors is an array dimensioned [0,0] }
   for i := 0 to PalSize - 1 do
   with MyLogPal.palPalEntry[i], pBMI^.bmicolors[i] do begin
      peRed   := rgbRed;
      peBlue  := rgbBlue;
      peGreen := rgbGreen;
      peFlags := 0;          { 0 implies normal mapping. }
      end;
{$R+}
   hPal := CreatePalette(PLogPalette(@MyLogPal)^);
   if hPal = 0 then Alert('Palette creation failed.');
   CopyDIBPalette := PalSize;
   end;

{ Attempt to open device independent bitmap from resource. }
function TBitScrollWindow.FindLoadLockDIB: Boolean;
var
   hDIB : THandle;                     { results of FindResource. }
   hGlobalDIB: THandle;                { results of LoadResource. }
   pDIB: pointer;                      { results of LockResource. }

   ColorsUsed: integer;                { How many TRGBQuads were there? }
   DCHandle: HDC;                      { Temporary working display context. }
   pBits: Pointer;                     { calculated pointer to image bytes. }
   NewBitmapHandle, OldPal: THandle;   { !! }
   NewPixelWidth, NewPixelHeight: word;          { retrieved height and width. }
begin
   hDIB := FindResource(hInstance, 'RES256_BMP', RT_BITMAP);  { Look up DIB }
   if hDIB = 0 then Alert('Bitmap not found.');
   hGlobalDIB := LoadResource(hInstance, hDIB);               { Sort of load it. }
   if hGlobalDIB = 0 then Alert('Bitmap not loaded.');
   pDIB := LockResource(hGLobalDIB);                          { Really load it. }
   if pDIB = nil then Alert('No address for bitmap.');

   NewPixelWidth := PBitMapINfoHeader(pDib)^.biWidth;     { access TBitMapInfo }
   Dbg('Width = ', NewPixelWidth);
   NewPixelHeight := PBitMapInfoHeader(pDIB)^.biHeight;
   Dbg('Height = ', NewPixelHeight);
   Dbg('Image size is = ', PBitMapInfoHeader(pDIB)^.biSizeImage);
   Dbg('Bits per pixel in DIB = ', PBitMapInfoHeader(pDIB)^.biBitCount);
   case PBitMapInfoHeader(pDIB)^.biCompression of
      BI_RGB:  Dbg( 'RGB coded = ', PBitMapInfoHeader(pDIB)^.biCompression);
      BI_RLE8: Dbg( 'RLE8 coded = ', PBitMapInfoHeader(pDIB)^.biCompression);
      BI_RLE4: Dbg( 'RLE4 coded = ', PBitMapInfoHeader(pDIB)^.biCompression);
      else     Dbg( 'Unknown code = ', PBitMapInfoHeader(pDIB)^.biCompression);;
      end;
   if PBitMapInfoHeader(pDIB)^.biCompression <> BI_RGB then Alert('Not an RGB DIB.');
   Dbg('Size of infoHeader from header = ',  PBitMapInfoHeader(pDIB)^.biSize);
   Dbg('Size of infoHeader from compiler = ',  sizeof(TBitMapInfoHeader));

   ColorsUsed := CopyDIBPalette(pDIB);           { Make hPal a real palette. }

   pBits := ptr(seg(pDIB^), ofs(pDIB^) +         { Mint a pointer to image bits. }
                            PBitMapInfoHeader(pDIB)^.biSize +
                            (sizeof(TRGBQuad) * ColorsUsed));

   DCHandle := CreateDC('Display', nil, nil, nil);
   if DCHandle = 0 then Alert('No display context received.');
   OldPal := SelectPalette(DCHandle, hPal, false); {!!}
   if OldPal = 0 then Alert('SelectPalette failed.');
   RealizePalette(DCHandle);                       {!!}
   NewBitmapHandle := CreateDIBitmap(
      DCHandle,
      PBitmapInfoHeader(pDIB)^,        { just the info }
      cbm_Init,                        { initialize the bitmap with our picture. }
      pBits,                           { pointer to the resource DIB }
      PBitmapInfo(pDIB)^,              { both info and colors. }
      DIB_RGB_COLORS);
   SelectPalette(DCHandle, OldPal, false);         {!!}
   DeleteDC(DCHandle);

   UnlockResource(hGlobalDIB);        { Give back the DIB memory to the system. }
   FreeResource(hGlobalDIB);

   if NewBitmapHandle <> 0             { Did the magic work ? }
   then begin
      if BitmapHandle <> 0 then DeleteObject(BitmapHandle);
      BitmapHandle := NewBitmapHandle;           { save picture handle in permanent place}
      PixelWidth := NewPixelWidth;
      PixelHeight := NewPixelHeight;
      end
   else begin
      BitMapHandle := 0;                         { No bitmap. }
      Alert('Bitmap creation failed.');
      end;
   end;


{ Responds to an incoming "paint" message by redrawing the bitmap.  (The
  Scroller's BeginView method, which sets the viewport origin relative
  to the present scroll position, has already been called. )  }
procedure TBitScrollWindow.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
var
   MemoryDC: HDC;
   OldBitmapHandle: THandle;
   OldPal : THandle;       {!!}
   ClientRect: TRect;
begin
   if BitmapHandle <> 0
   then  begin
      MemoryDC := CreateCompatibleDC(PaintDC);
      OldPal := SelectPalette(MemoryDC, hPal, false);        {!!}
      RealizePalette(MemoryDC);                              {!!}
      if IsIconic(HWindow)
      then OldBitmapHandle := SelectObject(MemoryDC, IconizedBits)
      else begin
         OldBitmapHandle := SelectObject(MemoryDC, BitmapHandle);
         SetBkColor(PaintDC, GetNearestColor(PaintDC, $800000));
         SetTextColor(PaintDC, $FFFFFF);
         end;

      BitBlt(PaintDC, 0, 0, PixelWidth, PixelHeight, MemoryDC, 0, 0, SrcCopy);
      SelectObject(MemoryDC,OLDPal);    {!!}
      SelectObject(MemoryDC, OldBitmapHandle);
      DeleteDC(MemoryDC);
      end;
   end;

{ Clean up on exit }
destructor TBitScrollWindow.Done;
begin
   if hPal <> 0 then DeleteObject(hPal);   {!!}
   hPal := 0;                              {!!}
   if BitmapHandle <> 0 then DeleteObject(BitmapHandle);
   TWindow.Done;
   end;


{ Declare a variable of type TBitScrollApp }
var
  ScrollApp: TBitScrollApp;

{ Run the BitScrollApp }
begin
   ScrollApp.Init(bsa_Name);
   ScrollApp.Run;
   ScrollApp.Done;
   end.
